/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.ccs.formats.dashboardimage.impl;

import com.cognos.ccs.formats.dashboardimage.impl.DashboardPanelComponentPaintBackgroundImage;
import com.cognos.ccs.formats.dashboardimage.ldx.Dashboard;
import com.cognos.ccs.formats.dashboardimage.ldx.WidgetInstance;
import com.cognos.ccs.formats.dashboardimage.panel.WidgetContentLoader;
import com.cognos.ccs.formats.dashboardimage.panel.WidgetFactory;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.MediaTracker;
import java.awt.Rectangle;
import java.util.PriorityQueue;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.apache.commons.httpclient.Cookie;

public class DashboardPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private final PriorityQueue<WidgetInstance> m_widgetQueue;
    private final MediaTracker m_mediaTracker;
    private Dimension m_preferredSize;
    private Color m_bgColor;
    private final Dashboard m_dashboard;

    public DashboardPanel(Dashboard dashboard, String string, Cookie[] cookieArray, Dimension dimension, WidgetContentLoader widgetContentLoader, WidgetFactory widgetFactory) {
        this.m_dashboard = dashboard;
        this.m_widgetQueue = dashboard.widgetInstances();
        this.m_bgColor = dashboard.bgColor();
        this.m_mediaTracker = new MediaTracker(this);
        boolean bl = dimension.height == dimension.width;
        Dimension dimension2 = this.m_preferredSize = bl ? new Dimension(1024, 1024) : new Dimension(800, 600);
        while (this.m_widgetQueue.peek() != null) {
            WidgetInstance widgetInstance = this.m_widgetQueue.poll();
            String string2 = widgetInstance.viewerContentURL();
            boolean bl2 = "STATIC".equals(string) || null == string2;
            JComponent jComponent = null;
            jComponent = bl2 ? widgetFactory.staticWidget(widgetInstance) : widgetFactory.viewerHTMLWidget(widgetInstance, widgetContentLoader, cookieArray, this.m_mediaTracker);
            this.add(jComponent);
            Rectangle rectangle = widgetInstance.boxStyle();
            this.m_preferredSize.width = Math.max(this.m_preferredSize.width, rectangle.x + rectangle.width);
            this.m_preferredSize.height = Math.max(this.m_preferredSize.height, rectangle.y + rectangle.height);
        }
        try {
            this.m_mediaTracker.waitForAll();
        }
        catch (InterruptedException interruptedException) {
            interruptedException.printStackTrace();
        }
        if (!bl) {
            this.m_preferredSize.width += 200;
            this.m_preferredSize.height += 200;
        } else if (this.m_preferredSize.width < this.m_preferredSize.height) {
            this.m_preferredSize.width = this.m_preferredSize.height;
        } else {
            this.m_preferredSize.height = this.m_preferredSize.width;
        }
        this.setLayout(null);
        this.setSize(this.m_preferredSize);
        this.setPreferredSize(this.m_preferredSize);
        this.setOpaque(true);
        this.setBackground(this.m_bgColor);
    }

    @Override
    protected void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        Dimension dimension = this.getPreferredSize();
        DashboardPanelComponentPaintBackgroundImage dashboardPanelComponentPaintBackgroundImage = new DashboardPanelComponentPaintBackgroundImage(dimension, this.m_dashboard);
        dashboardPanelComponentPaintBackgroundImage.paintComponent(graphics);
    }
}

