/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.ccs.formats.dashboardimage.impl;

import com.cognos.ccs.formats.dashboardimage.ldx.BackgroundImageProperties;
import com.cognos.ccs.formats.dashboardimage.ldx.BackgroundStyleGroup;
import com.cognos.ccs.formats.dashboardimage.panel.ComponentPaint;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Rectangle;

public class DashboardPanelComponentPaintBackgroundImage
implements ComponentPaint {
    private static final String DEFAULT_POSITION = "center center";
    private static final String POSITION_SPLIT_CHAR = " ";
    private final Dimension m_componentDimension;
    private String m_position;
    private Rectangle m_rectangle;
    private final Image m_img;
    private final Color m_bgColor;
    private String m_repeat;
    private final BackgroundStyleGroup m_styleGroup;

    public DashboardPanelComponentPaintBackgroundImage(Dimension dimension, BackgroundStyleGroup backgroundStyleGroup) {
        this.m_componentDimension = dimension;
        this.m_styleGroup = backgroundStyleGroup;
        this.m_img = backgroundStyleGroup.bgImage();
        this.m_bgColor = backgroundStyleGroup.bgColor();
        if (null != this.m_img) {
            String[] stringArray;
            this.m_rectangle = new Rectangle();
            int n = this.m_img.getWidth(null);
            int n2 = this.m_img.getHeight(null);
            Dimension dimension2 = new Dimension(n, n2);
            this.m_rectangle.width = this.imageLenFloor(this.m_componentDimension.width, dimension2.width);
            this.m_rectangle.height = this.imageLenFloor(this.m_componentDimension.height, dimension2.height);
            BackgroundImageProperties backgroundImageProperties = backgroundStyleGroup.bgImageProperties();
            if (null != backgroundImageProperties) {
                this.m_repeat = backgroundImageProperties.bgImageRepeat();
                this.m_position = backgroundImageProperties.bgImagePosition();
            }
            if (null == this.m_position) {
                this.m_position = DEFAULT_POSITION;
            }
            if ((stringArray = this.m_position.split(POSITION_SPLIT_CHAR)).length < 2) {
                this.m_position = DEFAULT_POSITION;
                stringArray = this.m_position.split(POSITION_SPLIT_CHAR);
            }
            String string = stringArray[0];
            String string2 = stringArray[1];
            if ("repeat".equals(this.m_repeat)) {
                this.m_rectangle.x = this.xValueLeft();
            } else if ("repeat-x".equals(this.m_repeat)) {
                this.m_rectangle.x = this.xValueLeft();
            } else if ("right".equals(string)) {
                this.m_rectangle.x = this.xValueRight();
            } else if ("left".equals(string)) {
                this.m_rectangle.x = this.xValueLeft();
            } else if ("center".equals(string)) {
                this.m_rectangle.x = this.xValueCenter();
            }
            if ("repeat".equals(this.m_repeat)) {
                this.m_rectangle.y = this.yValueTop();
            } else if ("repeat-y".equals(this.m_repeat)) {
                this.m_rectangle.y = this.yValueTop();
            } else if ("top".equals(string2)) {
                this.m_rectangle.y = this.yValueTop();
            } else if ("bottom".equals(string2)) {
                this.m_rectangle.y = this.yValueBottom();
            } else if ("center".equals(string2)) {
                this.m_rectangle.y = this.yValueCenter();
            }
        }
    }

    private int imageLenFloor(int n, int n2) {
        int n3 = Math.min(n - 1, n2);
        return n3;
    }

    private int yValueTop() {
        return 1;
    }

    private int yValueBottom() {
        int n = this.m_componentDimension.height - this.m_rectangle.height;
        return n > 0 ? n : 0;
    }

    private int yValueCenter() {
        int n = Math.round(this.m_componentDimension.height / 2) - Math.round(this.m_rectangle.height / 2);
        return n > 0 ? n : 1;
    }

    private int xValueCenter() {
        int n;
        int n2 = (int)Math.round(this.m_componentDimension.getWidth() / 2.0);
        int n3 = n2 - (n = this.m_rectangle.width / 2);
        return n3 > 0 ? n3 : 1;
    }

    private int xValueLeft() {
        return 1;
    }

    private int xValueRight() {
        int n = this.m_componentDimension.width;
        int n2 = this.m_rectangle.width;
        int n3 = n - n2;
        return n3 > 0 ? n3 : 1;
    }

    public void draw(Graphics graphics) {
        if (null != this.m_img) {
            int n = this.m_img.getWidth(null);
            int n2 = 1;
            if ("repeat".equals(this.m_repeat) || "repeat-x".equals(this.m_repeat)) {
                n2 = this.m_componentDimension.width / n + 1;
            }
            int n3 = this.m_img.getHeight(null);
            int n4 = 1;
            if ("repeat".equals(this.m_repeat) || "repeat-y".equals(this.m_repeat)) {
                n4 = this.m_componentDimension.height / n3 + 1;
            }
            Rectangle rectangle = new Rectangle(this.m_rectangle.x, this.m_rectangle.y, this.m_rectangle.width, this.m_rectangle.height);
            for (int i = 0; i < n2; ++i) {
                for (int j = 0; j < n4; ++j) {
                    graphics.drawImage(this.m_img, rectangle.x, rectangle.y, rectangle.width, rectangle.height, this.m_bgColor, null);
                    rectangle.y += n3;
                }
                rectangle.y = this.m_rectangle.y;
                rectangle.x += n;
            }
        }
    }

    @Override
    public BackgroundStyleGroup backgroundStyleGroup() {
        return this.m_styleGroup;
    }

    @Override
    public void paintComponent(Graphics graphics) {
        this.draw(graphics);
    }
}

