/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.ccs.formats.dataset;

import com.cognos.ccs.formats.dataset.ADatasetElement;
import com.cognos.ccs.formats.dataset.DatasetHandler;
import com.cognos.ccs.service.ConfigMgr;
import com.cognos.ccs.utility.Utilities;

public abstract class ADatasetImageElement
extends ADatasetElement {
    protected static final String TABLE = "dataTable";
    protected static final String TABLE_ROW = "row";
    protected static final String VERSION_BASE = "versionBase";
    protected static final String PATH_SEPERATOR = "/";

    public ADatasetImageElement(DatasetHandler datasetHandler) {
        super(datasetHandler);
    }

    protected void generateImageURL(boolean bl) {
        String string = (String)this.handler.getGlobal(VERSION_BASE);
        StringBuffer stringBuffer = new StringBuffer();
        String string2 = this.handler.getTextNode();
        if (!string2.substring(0, 4).equalsIgnoreCase("http")) {
            stringBuffer.append(ConfigMgr.getInstance().getCognosGateway());
            stringBuffer.append(PATH_SEPERATOR);
            if (!Utilities.isNullOrEmpty(string)) {
                stringBuffer.append(string);
                stringBuffer.append(PATH_SEPERATOR);
            }
        }
        stringBuffer.append(string2);
        if (bl) {
            this.handler.write(Utilities.escapeXML(stringBuffer.toString()));
        } else {
            this.handler.get_columnMap().put(this.handler.get_itemCount() + "x", Utilities.escapeXML(stringBuffer.toString()));
        }
    }

    @Override
    public void processEvent(int n) {
        super.processEvent(n);
        switch (n) {
            case 3200: {
                this.handler.RecordTextNodeOn();
                break;
            }
            case 3201: {
                if (this.handler.get_isSingleObject()) {
                    this.generateImageURL(true);
                    break;
                }
                if (this.handler.get_insideCol() || this.handler.get_inNestedRow()) break;
                this.generateImageURL(false);
                break;
            }
        }
    }
}

