/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.ccs.formats.dataset;

import com.cognos.ccs.formats.dataset.ADatasetElement;
import com.cognos.ccs.formats.dataset.ADatasetTableElement;
import com.cognos.ccs.formats.dataset.DatasetCell;
import com.cognos.ccs.formats.dataset.DatasetDimensions;
import com.cognos.ccs.formats.dataset.DatasetHandler;
import com.cognos.ccs.formats.dataset.DatasetRow;
import com.cognos.ccs.utility.MemoryBufferStream;
import com.cognos.ccs.utility.SAXParserFactoryWrapper;
import java.io.StringReader;
import java.util.HashMap;
import javax.xml.parsers.SAXParser;
import org.xml.sax.InputSource;
import org.xml.sax.helpers.DefaultHandler;

public class DatasetCrosstab
extends ADatasetTableElement {
    DatasetDimensions columnDims = null;
    DatasetDimensions rowDims = null;
    private int rowCount = 0;
    private boolean doNotProcess = false;

    public DatasetCrosstab(DatasetHandler datasetHandler) {
        super(datasetHandler);
        this.initialize(datasetHandler);
    }

    private void initialize(DatasetHandler datasetHandler) {
        this.rowCount = 0;
        this.doNotProcess = false;
        this.columnDims = new DatasetDimensions(datasetHandler);
        this.rowDims = new DatasetDimensions(datasetHandler);
    }

    @Override
    public void processEvent(int n) {
        super.processEvent(n);
        switch (n) {
            case 1400: {
                if (this.doNotProcess) break;
                this.handler.set_isCtabCol(true);
                this.handler.set_isCorner(true);
                this.handler.pushFsm(new DatasetCell(this.handler, n));
                this.handler.injectEvent(n);
                break;
            }
            case 1030: {
                if (!this.handler.get_isSingleObject()) {
                    this.handler.get_columnMap().put(this.handler.get_itemCount() + "x", "Unsupported");
                    this.doNotProcess = true;
                    break;
                }
                this.handler.set_columnMap(new HashMap());
                this.handler.set_isSingleObject(false);
                this.handler.set_getID(true);
                this.handler.set_rowNumber(0);
                this.handler.set_columnNumber(0);
                this.handler.writeOpen("dataTable");
                break;
            }
            case 1050: {
                if (this.doNotProcess) break;
                this.handler.pushFsm(this.columnDims);
                this.handler.injectEvent(n);
                break;
            }
            case 1040: {
                if (this.doNotProcess) break;
                this.handler.pushFsm(this.rowDims);
                this.handler.injectEvent(n);
                break;
            }
            case 1070: {
                if (this.doNotProcess) break;
                this.handler.pushFsm(new CrosstabDataTable(this.handler));
                this.handler.injectEvent(n);
                break;
            }
            case 1401: {
                if (this.doNotProcess) break;
                for (int i = 0; i < this.handler.get_cSpan(); ++i) {
                    this.handler.set_columnNumber(this.handler.get_columnNumber() + 1);
                    Integer n2 = new Integer(this.handler.get_columnNumber());
                    this.handler.get_columnMap().put(n2, "dim" + n2);
                }
                this.handler.set_isCorner(false);
                break;
            }
            case 1031: {
                if (!this.doNotProcess) {
                    this.handler.writeClose("dataTable");
                    this.handler.set_isSingleObject(true);
                }
                this.handler.popFsm();
            }
        }
    }

    public void writeRowDim() {
        this.handler.set_columnNumber(0);
        this.handler.set_inNestedRow(true);
        this.handler.writeOpen("row");
        if (this.rowCount < this.rowDims.getNestedLevels()) {
            String[] stringArray = this.rowDims.getDimensionCells(this.rowCount);
            this.writeDimensionCells(stringArray);
        }
        ++this.rowCount;
    }

    private void writeColumnDims() {
        this.handler.set_tableStart(this.handler.get_columnNumber());
        for (int i = 0; i < this.columnDims.getNestedLevels(); ++i) {
            this.handler.set_columnNumber(this.handler.get_tableStart());
            this.handler.set_isCtabCol(true);
            String[] stringArray = this.columnDims.getDimensionCells(i);
            this.writeDimensionCells(stringArray);
        }
    }

    private void writeDimensionCells(String[] stringArray) {
        for (int i = 0; i < stringArray.length; ++i) {
            try {
                SAXParser sAXParser = SAXParserFactoryWrapper.getParser();
                MemoryBufferStream memoryBufferStream = new MemoryBufferStream();
                DatasetHandler datasetHandler = (DatasetHandler)this.handler.getClass().newInstance();
                datasetHandler.shareStates(this.handler);
                datasetHandler.setOutStream(memoryBufferStream);
                datasetHandler.pushFsm(new DatasetCell(datasetHandler, 1100));
                sAXParser.parse(new InputSource(new StringReader(stringArray[i])), (DefaultHandler)datasetHandler);
                this.handler.write(memoryBufferStream.getBuffer());
                continue;
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    @Override
    public void reset() {
        this.initialize(this.handler);
    }

    private class CrosstabDataTable
    extends ADatasetElement {
        public CrosstabDataTable(DatasetHandler datasetHandler) {
            super(datasetHandler);
        }

        @Override
        public void processEvent(int n) {
            switch (n) {
                case 1070: {
                    DatasetCrosstab.this.writeColumnDims();
                    break;
                }
                case 1040: {
                    this.handler.set_isFirstCell(true);
                    this.handler.set_isCtabCol(false);
                    this.handler.set_rowNumber(this.handler.get_rowNumber() + 1);
                    this.handler.set_columnNumber(0);
                    DatasetCrosstab.this.writeRowDim();
                    this.handler.set_inNestedRow(false);
                    this.handler.pushFsm(new DatasetRow(this.handler));
                    break;
                }
                case 1071: {
                    this.handler.popFsm();
                    this.handler.set_isCtabCol(false);
                }
            }
        }
    }
}

