/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.ccs.formats.dataset;

import com.cognos.ccs.formats.dataset.ADatasetElement;
import com.cognos.ccs.formats.dataset.DatasetHandler;
import java.util.Vector;

public class DatasetDimensions
extends ADatasetElement {
    String cellXML = null;
    Vector rowcols = new Vector();
    boolean firstChild = true;

    public DatasetDimensions(DatasetHandler datasetHandler) {
        super(datasetHandler);
    }

    @Override
    public void processEvent(int n) {
        switch (n) {
            case 1050: {
                this.handler.pushFsm(new DatasetDimension(this.handler, 0, true, this.firstChild));
                if (!this.firstChild) break;
                this.firstChild = false;
                break;
            }
            case 1040: {
                this.insertRowIfNeeded(0);
                this.handler.pushFsm(new DatasetDimension(this.handler, 0, false, this.firstChild));
                if (!this.firstChild) break;
                this.firstChild = false;
                break;
            }
            case 1041: 
            case 1051: {
                this.handler.popFsm();
            }
        }
    }

    private void AddDimension(DatasetDimension datasetDimension, int n) {
        if (datasetDimension.isColumn) {
            Vector vector = this.getRow(n);
            vector.add(datasetDimension);
        } else if (datasetDimension.isFirstCell) {
            Vector vector = this.getRow(this.rowcols.size() - 1);
            vector.add(datasetDimension);
        } else {
            this.insertRowIfNeeded(this.rowcols.size());
            Vector vector = this.getRow(this.rowcols.size() - 1);
            vector.add(datasetDimension);
        }
    }

    private void insertRowIfNeeded(int n) {
        if (this.rowcols.size() <= n) {
            this.rowcols.add(new Vector());
        }
    }

    private Vector getRow(int n) {
        Vector vector = (Vector)this.rowcols.get(n);
        return vector;
    }

    public int getNestedLevels() {
        return this.rowcols.size();
    }

    public String[] getDimensionCells(int n) {
        Vector vector = this.getRow(n);
        String[] stringArray = new String[vector.size()];
        for (int i = 0; i < vector.size(); ++i) {
            DatasetDimension datasetDimension = (DatasetDimension)vector.get(i);
            stringArray[i] = datasetDimension.dimensionCellXML;
        }
        return stringArray;
    }

    private class DatasetDimension
    extends ADatasetElement {
        int m_state;
        protected static final int DIM_START = 100;
        protected static final int DIM_DRILLS = 200;
        private String dimensionCellXML;
        private int position;
        private boolean isColumn;
        private boolean isFirstCell;
        private boolean isFirstChild;

        public DatasetDimension(DatasetHandler datasetHandler, int n, boolean bl, boolean bl2) {
            super(datasetHandler);
            this.m_state = 100;
            this.dimensionCellXML = "";
            this.position = 0;
            this.isColumn = false;
            this.isFirstCell = false;
            this.isFirstChild = true;
            this.position = n;
            this.isColumn = bl;
            this.isFirstCell = bl2;
        }

        @Override
        public void processEvent(int n) {
            switch (this.m_state) {
                case 100: {
                    this.processDim(n);
                    break;
                }
                case 200: {
                    this.processDrill(n);
                }
            }
        }

        public void processDim(int n) {
            switch (n) {
                case 1100: {
                    if (this.isColumn) {
                        DatasetDimensions.this.insertRowIfNeeded(this.position);
                    }
                    this.handler.startRecording();
                    break;
                }
                case 1101: {
                    this.dimensionCellXML = this.handler.getRecordedText();
                    this.handler.stopRecording();
                    DatasetDimensions.this.AddDimension(this, this.position);
                    break;
                }
                case 10000: {
                    this.m_state = 200;
                    break;
                }
                case 1090: {
                    this.handler.pushFsm(new DatasetDimension(this.handler, this.position + 1, this.isColumn, this.isFirstChild));
                    if (!this.isFirstChild) break;
                    this.isFirstChild = false;
                    break;
                }
                case 1091: {
                    this.handler.popFsm();
                    break;
                }
                case 1041: 
                case 1051: {
                    this.handler.popFsm();
                    this.handler.injectEvent(n);
                }
            }
        }

        public void processDrill(int n) {
            switch (n) {
                case 10001: {
                    this.m_state = 100;
                }
            }
        }
    }
}

