/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.ccs.formats.dataset;

import com.cognos.ccs.formats.dataset.ADatasetElement;
import com.cognos.ccs.formats.dataset.DatasetHandler;
import com.cognos.ccs.formats.dataset.DatasetPage;

public class DatasetDocument
extends ADatasetElement {
    private static final String XML_DECLARATION = "<?xml version=\"1.0\"?>";
    private static final String DATASET_ROOT_OPEN = "dataSet xmlns=\"http://www.ibm.com/xmlns/prod/cognos/dataSet/201006\"";
    private static final String DATASET_ROOT_CLOSE = "dataSet";
    private boolean doNotProcess = false;

    public DatasetDocument(DatasetHandler datasetHandler) {
        super(datasetHandler);
    }

    @Override
    public void processEvent(int n) {
        switch (n) {
            case 3300: {
                if (!this.handler.get_isSingleObject()) {
                    this.handler.get_columnMap().put(this.handler.get_itemCount() + "x", "Unsupported");
                    this.doNotProcess = true;
                    break;
                }
                this.handler.set_metaMap(null);
                this.startDatasetDocument();
                break;
            }
            case 3100: {
                if (this.doNotProcess) break;
                this.handler.RecordTextNodeOn();
                break;
            }
            case 3101: {
                if (this.doNotProcess) break;
                this.handler.setGlobal("versionBase", this.handler.getTextNode());
                break;
            }
            case 2800: {
                if (this.doNotProcess) break;
                this.handler.pushFsm(new DatasetPage(this.handler));
                this.handler.injectEvent(n);
                break;
            }
            case 3301: {
                this.endDatasetDocument();
                break;
            }
        }
    }

    protected void endDatasetDocument() {
        if (!this.doNotProcess) {
            this.handler.writeClose(DATASET_ROOT_CLOSE);
        }
        this.handler.popFsm();
    }

    protected void startDatasetDocument() {
        this.handler.write(XML_DECLARATION);
        this.handler.writeOpen(DATASET_ROOT_OPEN);
    }
}

