/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.ccs.formats.dataset;

import com.cognos.ccs.formats.dataset.ADatasetTableElement;
import com.cognos.ccs.formats.dataset.DatasetCell;
import com.cognos.ccs.formats.dataset.DatasetGroupSection;
import com.cognos.ccs.formats.dataset.DatasetHandler;
import java.util.HashMap;

public class DatasetList
extends ADatasetTableElement {
    private boolean doNotProcess = false;

    public DatasetList(DatasetHandler datasetHandler) {
        super(datasetHandler);
    }

    @Override
    public void processEvent(int n) {
        super.processEvent(n);
        switch (n) {
            case 1020: {
                if (!this.handler.get_isSingleObject()) {
                    this.handler.get_columnMap().put(this.handler.get_itemCount() + "x", "Unsupported");
                    this.doNotProcess = true;
                    break;
                }
                this.startList();
                break;
            }
            case 1700: {
                if (this.doNotProcess) break;
                this.handleColTitleToken(n);
                break;
            }
            case 1800: {
                if (this.doNotProcess) break;
                this.handleGroupToken();
                break;
            }
            case 1021: {
                if (!this.doNotProcess) {
                    this.buildList();
                }
                this.handler.popFsm();
            }
        }
    }

    private void startList() {
        this.handler.set_columnMap(new HashMap());
        this.handler.set_isList(true);
        this.handler.set_isSingleObject(false);
        this.handler.set_getID(true);
        this.handler.set_columnNumber(0);
        this.handler.set_rowNumber(0);
        this.handler.writeOpen("dataTable");
    }

    private void buildList() {
        for (int i = 1; i <= this.handler.get_rowNumber(); ++i) {
            this.handler.writeOpen("row");
            for (int j = 1; j <= this.handler.get_columnNumber() + 1; ++j) {
                String string;
                String string2 = "row" + i + "col" + j;
                if (!this.handler.get_columnMap().containsKey(string2)) continue;
                String string3 = (String)this.handler.get_columnMap().get(new Integer(j));
                if (string3 == null) {
                    string3 = "dim" + j;
                }
                if ((string = (String)this.handler.get_columnMap().get(string2)).equals("") || string.charAt(0) != '<') {
                    this.handler.writeOpen(string3);
                    this.handler.write(string);
                    this.handler.writeClose(string3);
                    continue;
                }
                this.handler.write(string);
            }
            this.handler.writeClose("row");
        }
        this.handler.writeClose("dataTable");
        this.handler.set_isList(false);
        this.handler.set_isSingleObject(true);
    }

    private void handleColTitleToken(int n) {
        this.handler.set_insideCol(true);
        this.handler.pushFsm(new DatasetCell(this.handler, n));
        this.handler.injectEvent(n);
    }

    private void handleGroupToken() {
        this.handler.set_columnNumber(0);
        this.handler.pushFsm(new DatasetGroupSection(this.handler));
    }
}

