/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.ccs.formats.dataset;

import com.cognos.ccs.drill.ContextItem;
import com.cognos.ccs.drill.ContextList;
import com.cognos.ccs.drill.MetadataItem;
import com.cognos.ccs.exceptions.CCSAuthenticationException;
import com.cognos.ccs.exceptions.CCSGeneralException;
import com.cognos.ccs.exceptions.CCSPromptException;
import com.cognos.ccs.formats.dataset.ADatasetSpanElement;
import com.cognos.ccs.formats.dataset.DatasetHandler;
import com.cognos.ccs.service.Cognos8Connector;
import com.cognos.ccs.service.Conversation;
import com.cognos.ccs.utility.Utilities;

public class DatasetText
extends ADatasetSpanElement {
    private String value = null;
    private String fmtValue = null;
    boolean hasFormatVal = false;

    public DatasetText(DatasetHandler datasetHandler) {
        super(datasetHandler);
    }

    @Override
    public void processEvent(int n) {
        super.processEvent(n);
        switch (n) {
            case 2500: {
                break;
            }
            case 1080: {
                this.handler.RecordTextNodeOn();
                break;
            }
            case 1081: {
                this.value = this.handler.getTextNode();
                this.handler.RecordTextNodeOff();
                break;
            }
            case 3800: {
                this.handler.RecordTextNodeOn();
                break;
            }
            case 3801: {
                if (null == this.value) {
                    this.fmtValue = this.handler.getTextNode();
                    this.handleText(this.fmtValue);
                    this.hasFormatVal = true;
                }
                this.handler.RecordTextNodeOff();
                break;
            }
            case 2501: {
                if (!this.hasFormatVal && null != this.value) {
                    this.handleText(this.value);
                }
                this.handler.popFsm();
                break;
            }
        }
    }

    private void handleText(String string) {
        if (this.handler.get_insideCol()) {
            if (!this.handler.get_isCorner()) {
                string = DatasetHandler.encodeNameForTag(string);
                this.addColumn(string);
            }
        } else if (!this.handler.get_isSingleObject()) {
            string = Utilities.escapeXML(string);
            if (this.handler.get_inNestedRow()) {
                this.addRow(string);
            } else {
                this.handler.get_columnMap().put(this.handler.get_itemCount() + "x", string);
            }
        } else {
            string = Utilities.escapeXML(string);
            this.handler.write("<dataTable><row><value>" + string + "</value></row></dataTable>");
        }
    }

    private void addColumn(String string) {
        for (int i = 0; i < this.handler.get_cSpan(); ++i) {
            this.handler.set_columnNumber(this.handler.get_columnNumber() + 1);
            Integer n = new Integer(this.handler.get_columnNumber());
            StringBuffer stringBuffer = new StringBuffer();
            if (this.handler.get_columnMap().containsKey(n)) {
                stringBuffer.append(this.handler.get_columnMap().get(n));
                stringBuffer.append("_");
                stringBuffer.append(string);
                this.handler.get_columnMap().put(n, stringBuffer.toString());
                continue;
            }
            this.handler.get_columnMap().put(n, string);
            this.handler.set_insideCol(false);
        }
    }

    private void addRow(String string) {
        int n;
        for (n = 0; n < this.handler.get_rSpan(); ++n) {
            int n2 = this.handler.get_rowNumber() + n;
            String string2 = "row" + n2 + "col" + this.handler.get_columnNumber();
            while (this.handler.get_columnMap().containsKey(string2)) {
                this.handler.set_columnNumber(this.handler.get_columnNumber() + 1);
                string2 = "row" + n2 + "col" + this.handler.get_columnNumber();
            }
            String string3 = string;
            this.handler.get_columnMap().put(string2, string3);
        }
        if (this.handler.get_rowNumber() == 1) {
            this.getDimContext();
        }
        for (n = 1; n < this.handler.get_cSpan(); ++n) {
            this.handler.set_columnNumber(this.handler.get_columnNumber() + 1);
        }
    }

    private void getDimContext() {
        if (this.handler.get_inNestedRow() && this.handler.get_cornerDimContext() != null) {
            Cognos8Connector cognos8Connector = this.handler.getConnector();
            Conversation conversation = this.handler.getConversation();
            if (cognos8Connector != null && conversation != null) {
                try {
                    ContextItem contextItem;
                    String[] stringArray = ContextList.extractIds(this.handler.get_cornerDimContext());
                    ContextList contextList = cognos8Connector.getContext(conversation, null, stringArray);
                    if (this.handler.get_metaMap() == null) {
                        this.handler.set_metaMap(cognos8Connector.getMetadata(conversation, null));
                    }
                    if (!(contextItem = contextList.getContextItem(stringArray[0])).getMun().equals("")) {
                        MetadataItem metadataItem = this.handler.get_metaMap().getMetadataItem(contextItem.getMun());
                        if (metadataItem != null) {
                            String string = this.getDimensionValue(metadataItem.getValue("m"));
                            string = DatasetHandler.encodeNameForTag(string);
                            this.handler.get_columnMap().put(new Integer(this.handler.get_columnNumber()), string);
                        }
                    } else {
                        MetadataItem metadataItem = this.handler.get_metaMap().getMetadataItem(contextItem.getRdi());
                        String string = metadataItem.getValue("r");
                        string = DatasetHandler.encodeNameForTag(string);
                        this.handler.get_columnMap().put(new Integer(this.handler.get_columnNumber()), string);
                    }
                }
                catch (CCSGeneralException cCSGeneralException) {
                    cCSGeneralException.printStackTrace();
                }
                catch (CCSAuthenticationException cCSAuthenticationException) {
                    cCSAuthenticationException.printStackTrace();
                }
                catch (CCSPromptException cCSPromptException) {
                    cCSPromptException.printStackTrace();
                }
            }
        }
    }

    private String getDimensionValue(String string) {
        if (string.indexOf("->") < string.indexOf(".")) {
            return string.substring(string.indexOf("[") + 1, string.indexOf("]"));
        }
        if (string.indexOf(".") != -1) {
            return this.getDimensionValue(string.substring(string.indexOf(".") + 1));
        }
        return null;
    }
}

