/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.ccs.formats.datasetatom;

import com.cognos.ccs.formats.dataset.ADatasetElement;
import com.cognos.ccs.formats.dataset.DatasetHandler;
import com.cognos.ccs.formats.datasetatom.DatasetAtomObserver;

public class DatasetAtomCell
extends ADatasetElement {
    protected int startEvent;
    protected int closeEvent;

    public DatasetAtomCell(DatasetHandler datasetHandler, int n) {
        super(datasetHandler);
        this.startEvent = n;
        this.closeEvent = n + 1;
        datasetHandler.set_rSpan(1);
        datasetHandler.set_cSpan(1);
    }

    @Override
    public void processEvent(int n) {
        super.processEvent(n);
        if (n == this.startEvent) {
            if (n == 1700 || this.handler.get_isCtabCol()) {
                this.handler.set_insideCol(true);
            } else {
                this.openCell();
            }
        } else if (n == this.closeEvent) {
            this.handleClose(n);
        } else if (n == 1600) {
            this.handler.RecordTextNodeOn();
        } else if (n == 1601) {
            this.handler.set_rSpan(Integer.parseInt(this.handler.getTextNode()));
            this.handler.RecordTextNodeOff();
        } else if (n == 1500) {
            this.handler.RecordTextNodeOn();
        } else if (n == 1501) {
            this.handler.set_cSpan(Integer.parseInt(this.handler.getTextNode()));
            this.handler.RecordTextNodeOff();
        } else if (n == 8000) {
            this.handler.RecordTextNodeOn();
        } else if (n == 8001) {
            if (this.handler.get_inNestedRow()) {
                this.handler.set_cornerDimContext(this.handler.getTextNode());
            }
            this.handler.RecordTextNodeOff();
        } else if (n == 2300) {
            this.handleItem();
        }
    }

    private void openCell() {
        this.handler.set_insideCol(false);
        this.handler.set_itemCount(0);
        this.handler.set_columnNumber(this.handler.get_columnNumber() + 1);
        if (!this.handler.get_inNestedRow() && !this.handler.get_isList() && this.handler.get_isFirstCell()) {
            for (int i = 1; i <= this.handler.get_tableStart(); ++i) {
                String string = "row" + this.handler.get_rowNumber() + "col" + i;
                if (!this.handler.get_columnMap().containsKey(string)) continue;
                String string2 = (String)this.handler.get_columnMap().get(new Integer(i));
                if (string2 == null) {
                    string2 = "dim" + i;
                }
                this.handler.writeOpen(string2);
                this.handler.write((String)this.handler.get_columnMap().get(string));
                this.handler.writeClose(string2);
            }
            this.handler.set_isFirstCell(false);
        }
    }

    private void handleClose(int n) {
        if (n == 1701 && !this.handler.get_columnMap().containsKey(new Integer(this.handler.get_columnNumber())) && this.handler.get_insideCol()) {
            this.handler.set_columnNumber(this.handler.get_columnNumber() + 1);
            Integer n2 = new Integer(this.handler.get_columnNumber());
            this.handler.get_columnMap().put(n2, "dim" + n2);
        }
        if (this.handler.get_rowNumber() > 0) {
            if (this.handler.get_isList()) {
                this.handleList();
            } else if (!(this.handler.get_isSingleObject() || this.handler.get_insideCol() || this.handler.get_inNestedRow())) {
                this.handleCtab();
            }
        }
        this.handler.popFsm();
        this.handler.injectEvent(n);
    }

    private void handleList() {
        int n;
        String string = "row" + this.handler.get_rowNumber() + "col" + this.handler.get_columnNumber();
        while (this.handler.get_columnMap().containsKey(string)) {
            this.handler.set_columnNumber(this.handler.get_columnNumber() + 1);
            string = "row" + this.handler.get_rowNumber() + "col" + this.handler.get_columnNumber();
        }
        StringBuilder stringBuilder = new StringBuilder();
        this.getListItem(stringBuilder);
        String string2 = stringBuilder.toString();
        for (n = 0; n < this.handler.get_rSpan(); ++n) {
            int n2 = this.handler.get_rowNumber() + n;
            string = "row" + n2 + "col" + this.handler.get_columnNumber();
            this.handler.get_columnMap().put(string, string2);
        }
        for (n = 1; n < this.handler.get_cSpan(); ++n) {
            this.handler.set_columnNumber(this.handler.get_columnNumber() + 1);
        }
    }

    private void getListItem(StringBuilder stringBuilder) {
        if (this.handler.get_itemCount() > 1) {
            Integer n = new Integer(this.handler.get_columnNumber());
            String string = (String)this.handler.get_columnMap().get(n);
            if (string == null) {
                string = "dim" + n;
            }
            for (int i = 1; i <= this.handler.get_itemCount(); ++i) {
                String string2 = i + "x";
                stringBuilder.append("<" + string + "_" + string + i + ">");
                stringBuilder.append(this.handler.get_columnMap().get(string2));
                stringBuilder.append("</" + string + "_" + string + i + ">");
            }
        } else if (this.handler.get_itemCount() == 1) {
            stringBuilder.append(this.handler.get_columnMap().get("1x"));
        }
    }

    private void handleCtab() {
        if (this.handler.get_itemCount() > 1) {
            Integer n = new Integer(this.handler.get_columnNumber());
            String string = (String)this.handler.get_columnMap().get(n);
            if (string == null) {
                string = "dim" + n;
            }
            for (int i = 1; i <= this.handler.get_itemCount(); ++i) {
                String string2 = i + "x";
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append(string);
                stringBuilder.append("_");
                stringBuilder.append(string);
                stringBuilder.append(i);
                String string3 = stringBuilder.toString();
                this.handler.writeOpen(string3);
                this.handler.write((String)this.handler.get_columnMap().get(string2));
                this.handler.writeClose(string3);
            }
        } else if (this.handler.get_itemCount() == 1) {
            Integer n = new Integer(this.handler.get_columnNumber());
            String string = (String)this.handler.get_columnMap().get(n);
            if (string == null) {
                string = "dim" + n;
            }
            this.handler.writeOpen(string);
            this.handler.write((String)this.handler.get_columnMap().get("1x"));
            this.handler.writeClose(string);
        }
    }

    private void handleItem() {
        this.handler.set_itemCount(this.handler.get_itemCount() + 1);
        this.handler.pushFsm(new DatasetAtomObserver(this.handler, 2301));
    }
}

