/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.ccs.formats.datasetatom;

import com.cognos.ccs.content.ContentProvider;
import com.cognos.ccs.exceptions.CCSAuthenticationException;
import com.cognos.ccs.exceptions.CCSGeneralException;
import com.cognos.ccs.filter.Filter;
import com.cognos.ccs.formats.dataset.ADatasetElement;
import com.cognos.ccs.formats.dataset.DatasetHandler;
import com.cognos.ccs.formats.datasetatom.DatasetAtomPage;
import com.cognos.ccs.service.Cognos8Connector;
import com.cognos.ccs.service.ConfigMgr;
import com.cognos.ccs.service.Conversation;
import com.cognos.ccs.utility.Utilities;
import com.cognos.developer.schemas.bibus._3.BaseClass;
import com.cognos.developer.schemas.bibus._3.PropEnum;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.TimeZone;

public class DatasetAtomDocument
extends ADatasetElement {
    private boolean doNotProcess = false;

    public DatasetAtomDocument(DatasetHandler datasetHandler) {
        super(datasetHandler);
    }

    @Override
    public void processEvent(int n) {
        switch (n) {
            case 3300: {
                if (!this.handler.get_isSingleObject()) {
                    this.handler.get_columnMap().put(this.handler.get_itemCount() + "x", "Unsupported");
                    this.doNotProcess = true;
                    break;
                }
                this.handler.set_metaMap(null);
                this.startDatasetDocument();
                break;
            }
            case 3100: {
                if (this.doNotProcess) break;
                this.handler.RecordTextNodeOn();
                break;
            }
            case 3101: {
                if (this.doNotProcess) break;
                this.handler.setGlobal("versionBase", this.handler.getTextNode());
                break;
            }
            case 2800: {
                if (this.doNotProcess) break;
                this.handler.pushFsm(new DatasetAtomPage(this.handler));
                this.handler.injectEvent(n);
                break;
            }
            case 3301: {
                this.endDatasetDocument();
                break;
            }
        }
    }

    protected void endDatasetDocument() {
        if (!this.doNotProcess) {
            this.handler.write("</atom:feed>");
        }
        this.handler.popFsm();
    }

    protected void startDatasetDocument() {
        this.handler.write("<?xml version=\"1.0\"?>");
        this.handler.write("<atom:feed xmlns=\"http://www.ibm.com/xmlns/prod/cognos/dataSetAtom/201006\" xmlns:atom=\"http://www.w3.org/2005/Atom\">");
        Cognos8Connector cognos8Connector = this.handler.getConnector();
        Conversation conversation = this.handler.getConversation();
        String string = (String)conversation.getProperty("searchPath");
        try {
            PropEnum[] propEnumArray = new PropEnum[]{PropEnum.defaultName, PropEnum.storeID, PropEnum.modificationTime, PropEnum.searchPath};
            BaseClass[] baseClassArray = cognos8Connector.queryCM(string, propEnumArray);
            if (baseClassArray.length > 0) {
                String string2;
                String string3 = Utilities.escapeXML(baseClassArray[0].getDefaultName().getValue());
                String string4 = baseClassArray[0].getStoreID().getValue().get_value();
                Calendar calendar = baseClassArray[0].getModificationTime().getValue();
                SimpleDateFormat simpleDateFormat = new SimpleDateFormat();
                simpleDateFormat.applyPattern("yyyy-MM-dd'T'HH:mm:ss'Z'");
                simpleDateFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
                this.handler.set_reportUpdated(simpleDateFormat.format(calendar.getTime()));
                String string5 = string2 = baseClassArray[0].getSearchPath().getValue();
                String string6 = ConfigMgr.getInstance().getCognosGateway();
                if (string5.startsWith("/")) {
                    string5 = string5.substring(1, string5.length());
                }
                string2 = Utilities.IRIEncode(ContentProvider.convertSearchPathToResourcePath(string2, cognos8Connector), true);
                this.handler.write("<atom:id>");
                this.handler.write("tag:ibm-cognos.com,2011:" + this.handler.escapeIfNeeded(string2));
                this.handler.write("</atom:id>");
                this.handler.write("<atom:title type=\"text\">");
                this.handler.write(string3);
                this.handler.write("</atom:title>");
                this.handler.write("<atom:link href=\"");
                this.handler.write(string6);
                this.handler.write("/rds/");
                this.handler.write(Utilities.getReportTypeString(this.handler.getConversation()));
                this.handler.write("/report/");
                this.handler.write(string4);
                this.handler.write("?fmt=DatasetAtom");
                String string7 = (String)conversation.getProperty("filter");
                Filter[] filterArray = (Filter[])conversation.getProperty("filters");
                if (string7 != null) {
                    this.handler.write("&amp;selection=" + Utilities.IRIEncode(string7, false));
                } else if (filterArray != null && filterArray.length > 0) {
                    this.handler.write("&amp;selection=");
                    int n = filterArray.length;
                    for (int i = 0; i < n; ++i) {
                        String string8 = Utilities.IRIEncode(filterArray[i].getFilterValue(), false);
                        if (i < n - 1) {
                            string8 = string8 + ";";
                        }
                        this.handler.write(string8);
                    }
                }
                this.handler.write("\" rel=\"self\" type=\"application/atom+xml\"/>");
                this.handler.write("<atom:updated>");
                this.handler.write(this.handler.escapeIfNeeded(this.handler.get_reportUpdated()));
                this.handler.write("</atom:updated>");
                this.handler.write("<atom:author>");
                this.handler.write("<atom:name>");
                this.handler.write("IBMCognos10");
                this.handler.write("</atom:name>");
                this.handler.write("</atom:author>");
            }
        }
        catch (CCSGeneralException cCSGeneralException) {
            throw new RuntimeException(cCSGeneralException);
        }
        catch (CCSAuthenticationException cCSAuthenticationException) {
            throw new RuntimeException(cCSAuthenticationException);
        }
    }
}

