/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.ccs.formats.html;

import com.cognos.ccs.content.StyleGroup;
import com.cognos.ccs.formats.CCSFormatter;
import com.cognos.ccs.formats.css.CSSPreprocessor;
import com.cognos.ccs.formats.html.HTMLHandler;
import com.cognos.ccs.fsm.LdxHandler;
import com.cognos.ccs.utility.Utilities;
import com.ibm.cognos.ccs.internal.utility.Constants;
import com.ibm.json.java.JSONObject;
import java.util.Iterator;
import java.util.Vector;

public class AHTMLElement
implements LdxHandler.FilterFSM {
    protected static final String CLASS = "class";
    protected static final String CLOSE_TAG = ">";
    protected HTMLHandler handler;
    protected Vector<String> styles;
    protected String id = null;
    protected JSONObject drills;
    protected Vector<String> ctxes;
    protected boolean isHeader = false;
    protected boolean isInHdrs = false;
    protected boolean isFirstCell = false;
    protected Vector<String> hdrIds;
    protected static final String SPAN_SUMMARY = "<span id=\"%ID%\" style=\"position: absolute;margin-left: -9999px; margin-top: -9999px;\">%SUMMARY_TEXT%</span>";
    protected static final String HEADERS = "headers";
    protected static final String TABINDEX = "tabindex";
    protected static final String TABINDEX_VALUE_NOTAB = "-1";
    protected static final String TABINDEX_VALUE_NATURALORDER = "0";

    public AHTMLElement(HTMLHandler hTMLHandler) {
        this.handler = hTMLHandler;
        this.styles = new Vector();
        this.ctxes = new Vector();
        this.drills = new JSONObject();
    }

    @Override
    public void processEvent(int n) {
        switch (n) {
            case 1010: {
                this.handler.RecordTextNodeOn();
                break;
            }
            case 1011: {
                this.id = this.handler.getTextNode();
                if (this.isInHdrs) {
                    this.hdrIds.add(this.id);
                    break;
                }
                this.handler.writeAttribute("id", CCSFormatter.encodeName(this.id));
                break;
            }
            case 8000: {
                this.handler.RecordTextNodeOn();
                break;
            }
            case 8001: {
                String string = this.handler.getTextNode();
                if (this.handler.getRequestVersion() == Constants.RequestVersion.V3) {
                    this.ctxes.add(string);
                    break;
                }
                this.writeCustomOutput("ctx", string);
                break;
            }
            case 2400: {
                this.handler.RecordTextNodeOn();
                break;
            }
            case 2401: {
                this.addStyle();
                break;
            }
            case 130100: {
                this.handler.RecordTextNodeOn();
                break;
            }
            case 130101: {
                String string = Utilities.escapeXML(this.handler.getTextNode());
                if (string.contains("DOWN")) {
                    this.drills.put((Object)"down", (Object)string);
                    break;
                }
                this.drills.put((Object)"up", (Object)string);
                break;
            }
            case 1320: {
                this.handler.RecordTextNodeOn();
                break;
            }
            case 1321: {
                String string = this.handler.getTextNode();
                if (!"true".equals(string)) break;
                this.isHeader = true;
                break;
            }
            case 1310: {
                this.handler.RecordTextNodeOn();
                break;
            }
            case 1311: {
                String string = this.handler.getTextNode();
                if (!"true".equals(string)) break;
                this.isFirstCell = true;
                break;
            }
            case 1330: {
                this.isInHdrs = true;
                this.hdrIds = new Vector();
                break;
            }
            case 1331: {
                this.isInHdrs = false;
                if (!this.handler.isGeneratingA11Y()) break;
                StringBuffer stringBuffer = new StringBuffer();
                for (int i = 0; i < this.hdrIds.size(); ++i) {
                    if (i > 0) {
                        stringBuffer.append(" ");
                    }
                    stringBuffer.append(this.hdrIds.get(i));
                }
                this.handler.writeAttribute(HEADERS, stringBuffer.toString());
                break;
            }
        }
    }

    @Override
    public void reset() {
        this.isHeader = false;
        this.isInHdrs = false;
        this.isFirstCell = false;
    }

    protected void addStyle() {
        String string = this.handler.getTextNode();
        this.styles.add(string);
    }

    protected void writeStyles() {
        StringBuffer stringBuffer = new StringBuffer();
        Iterator<String> iterator = this.styles.iterator();
        if (!this.handler.useInlineStyles()) {
            this.writeStyleReference(stringBuffer, iterator);
        } else {
            this.writeInlineStyles(stringBuffer, iterator);
        }
        if (!this.drills.isEmpty()) {
            this.handler.writeAttribute("drills", this.drills.toString(), "'");
            this.drills.clear();
        }
        this.styles.clear();
    }

    protected void writeCtxes() {
        if (this.handler.getRequestVersion() == Constants.RequestVersion.V3 && !this.ctxes.isEmpty()) {
            Iterator<String> iterator = this.ctxes.iterator();
            while (iterator.hasNext()) {
                this.writeCustomOutput("ctx", iterator.next());
            }
            this.ctxes.clear();
        }
    }

    protected String getAdditionalStyleAttributes() {
        return null;
    }

    private void writeInlineStyles(StringBuffer stringBuffer, Iterator<String> iterator) {
        String string;
        CSSPreprocessor cSSPreprocessor = (CSSPreprocessor)this.handler.getPreProcessor();
        boolean bl = true;
        while (iterator.hasNext()) {
            StyleGroup styleGroup;
            if (bl) {
                bl = false;
            } else {
                stringBuffer.append("; ");
            }
            if ((styleGroup = cSSPreprocessor.getStyle(string = iterator.next())) == null) continue;
            stringBuffer.append(styleGroup.generateCSS(true));
        }
        if (null != this.getAdditionalStyleAttributes()) {
            stringBuffer.append(this.getAdditionalStyleAttributes());
        }
        if (!Utilities.isNullOrEmpty(string = stringBuffer.toString())) {
            this.handler.writeAttribute("style", string);
        }
    }

    private void writeStyleReference(StringBuffer stringBuffer, Iterator<String> iterator) {
        boolean bl = true;
        if (null != this.getAdditionalStyleAttributes()) {
            this.handler.writeAttribute("style", this.getAdditionalStyleAttributes());
        }
        while (iterator.hasNext()) {
            if (bl) {
                bl = false;
            } else {
                stringBuffer.append(" ");
            }
            stringBuffer.append(iterator.next());
        }
        String string = stringBuffer.toString();
        if (!Utilities.isNullOrEmpty(string)) {
            this.handler.writeAttribute(CLASS, stringBuffer.toString() + this.handler.getCssSuffix());
        }
    }

    protected void addSecondaryOps() {
        if (this.handler.getGlobal("NEXT") != null) {
            this.writeCustomOutput("canNext", "true");
        }
        if (this.handler.getGlobal("PREVIOUS") != null) {
            this.writeCustomOutput("canPrevious", "true");
        }
        if (this.handler.getGlobal("FIRST") != null) {
            this.writeCustomOutput("canFirst", "true");
        }
        if (this.handler.getGlobal("LAST") != null) {
            this.writeCustomOutput("canLast", "true");
        }
        if (this.handler.getGlobal("RELEASE") != null) {
            this.writeCustomOutput("canRelease", "true");
        }
    }

    private void writeCustomOutput(String string, String string2) {
        if (this.handler.getRequestVersion() == Constants.RequestVersion.V3) {
            this.handler.write("<");
            this.handler.write("div style=\"display:none\" ");
            this.handler.write("class=\"" + string + "\"");
            this.handler.write(CLOSE_TAG);
            this.handler.write(string2);
            this.handler.write("</div>");
        } else {
            this.handler.write(" ");
            this.handler.write(string);
            this.handler.write("=\"" + string2 + "\"");
        }
    }
}

