/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.ccs.formats.html;

import com.cognos.ccs.exceptions.CCSGeneralException;
import com.cognos.ccs.formats.html.AHTMLElement;
import com.cognos.ccs.formats.html.AHTMLImageBase64DataURI;
import com.cognos.ccs.formats.html.HTMLHandler;
import com.cognos.ccs.service.CCSLogger;
import com.cognos.ccs.service.Conversation;
import com.cognos.ccs.transports.IHTTPClientExecution;
import com.cognos.ccs.utility.Utilities;
import java.io.IOException;
import java.net.URI;
import java.util.regex.Pattern;
import org.apache.commons.httpclient.Cookie;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.HttpMethodBase;
import org.apache.commons.httpclient.methods.GetMethod;

public abstract class AHTMLImageElement
extends AHTMLElement {
    protected static final String SRC = "src";
    protected static final String VERSION_BASE = "versionBase";
    protected static final String PATH_SEPERATOR = "/";
    protected static final String IMG_BEGIN = "<img";
    protected static final String IMG_END = "/>";
    protected static final String IMG_ALT = "alt";
    protected String alternateText = null;
    private static final Pattern IMG_DIGIT_PATTERN = Pattern.compile("^img\\d+$");

    public AHTMLImageElement(HTMLHandler hTMLHandler) {
        super(hTMLHandler);
    }

    protected void generateImageURL() {
        String string = (String)this.handler.getGlobal(VERSION_BASE);
        StringBuffer stringBuffer = new StringBuffer();
        String string2 = this.handler.getTextNode();
        boolean bl = false;
        if (IMG_DIGIT_PATTERN.matcher(string2).find()) {
            bl = true;
        }
        if (string2.startsWith("..")) {
            string2 = string2.replace("..", this.handler.getWebcontentRoot());
        } else if (string2.startsWith("?") || string2.startsWith("graphic") || bl) {
            stringBuffer.append(this.handler.getGatewayURI());
            if (!string2.startsWith("?")) {
                stringBuffer.append(PATH_SEPERATOR);
            }
            if (!Utilities.isNullOrEmpty(string)) {
                stringBuffer.append(string);
                stringBuffer.append(PATH_SEPERATOR);
            }
            if (bl) {
                string2 = "graphic[@name=\"" + this.handler.escapeIfNeeded(string2) + "\"]";
            }
        }
        if (string2.contains("graphic[@name=\"")) {
            string2 = Utilities.IRIEncode(string2, true);
        }
        stringBuffer.append(string2);
        boolean bl2 = false;
        Conversation conversation = this.handler.getConversation();
        if (null != conversation) {
            bl2 = (Boolean)conversation.getProperty("embedImages");
        }
        String string3 = Utilities.escapeXML(stringBuffer.toString());
        if (bl2) {
            String string4 = stringBuffer.toString();
            Cookie[] cookieArray = Utilities.httpRequestCookies(conversation);
            string3 = this.imageValueDataURI(string4, cookieArray);
        }
        this.handler.writeAttribute(SRC, string3.replace("//gdi", "/gdi"));
    }

    private String imageValueDataURI(final String string, final Cookie[] cookieArray) {
        String string2 = null;
        try {
            IHTTPClientExecution iHTTPClientExecution = new IHTTPClientExecution(){

                @Override
                public String url() {
                    return string;
                }

                @Override
                public HttpMethodBase httpMethodBase(String string2) {
                    GetMethod getMethod = new GetMethod(string2);
                    return getMethod;
                }

                @Override
                public HttpClient httpClient(URI uRI) throws CCSGeneralException {
                    HttpClient httpClient = Utilities.createClientConnection(uRI);
                    return httpClient;
                }

                @Override
                public void execute(HttpClient httpClient, HttpMethodBase httpMethodBase) throws HttpException, IOException {
                    httpClient.executeMethod((HttpMethod)httpMethodBase);
                }

                @Override
                public Cookie[] cookies() {
                    return cookieArray;
                }
            };
            AHTMLImageBase64DataURI aHTMLImageBase64DataURI = new AHTMLImageBase64DataURI(iHTTPClientExecution);
            string2 = aHTMLImageBase64DataURI.encodeImage();
        }
        catch (Exception exception) {
            String string3 = exception.getMessage();
            CCSGeneralException cCSGeneralException = new CCSGeneralException(string3, new String[]{string}, 404);
            String string4 = cCSGeneralException.getMessage();
            String string5 = cCSGeneralException.getSourceTrace();
            CCSLogger cCSLogger = CCSLogger.getInstance();
            cCSLogger.logRuntimeWarning(string4, null, null, null, string5);
            string2 = Utilities.escapeXML(string);
        }
        return string2;
    }

    public void writeImageAlternateText() {
        this.handler.writeAttribute(IMG_ALT, this.alternateText != null ? Utilities.escapeXML(this.alternateText) : "");
    }

    @Override
    public void processEvent(int n) {
        super.processEvent(n);
        switch (n) {
            case 3200: {
                this.handler.RecordTextNodeOn();
                break;
            }
            case 3201: {
                this.generateImageURL();
                break;
            }
            case 150202: {
                this.handler.RecordTextNodeOn();
                break;
            }
            case 150203: {
                this.alternateText = this.handler.getTextNode();
                this.handler.RecordTextNodeOff();
                break;
            }
        }
    }
}

