/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.ccs.formats.html;

import com.cognos.ccs.formats.CCSFormatter;
import com.cognos.ccs.formats.css.CSSPreprocessor;
import com.cognos.ccs.formats.html.AHTMLElement;
import com.cognos.ccs.formats.html.HTMLHandler;
import com.cognos.ccs.utility.Utilities;
import com.ibm.cognos.ccs.internal.utility.Constants;
import com.ibm.json.java.JSONArray;

public class AHTMLSpanElement
extends AHTMLElement {
    private static final String CLOSE_BRACKET = ">";
    private static final String DIV_O = "<span";
    public static final String DIV = "span";
    private String id = null;
    private String drillURL = null;

    public AHTMLSpanElement(HTMLHandler hTMLHandler) {
        super(hTMLHandler);
    }

    protected void setID(String string) {
        this.id = string;
    }

    protected void writeSpan(String string) {
        if (this.canInline()) {
            this.handler.write(this.handler.escapeIfNeeded(string));
        } else {
            this.handler.write(DIV_O);
            if (null != this.id) {
                this.handler.writeAttribute("id", CCSFormatter.encodeName(this.id));
            }
            this.writeStyles();
            if (!this.drills.isEmpty()) {
                this.handler.writeAttribute("drills", this.drills.toString(), "'");
            }
            this.handler.write(CLOSE_BRACKET);
            this.writeCtxes();
            this.handler.write(this.handler.escapeIfNeeded(string));
            this.handler.writeClose(DIV);
        }
    }

    @Override
    public void processEvent(int n) {
        switch (n) {
            case 1010: {
                this.handler.RecordTextNodeOn();
                break;
            }
            case 1011: {
                this.setID(this.handler.getTextNode());
                this.handler.RecordTextNodeOff();
                break;
            }
            case 2400: {
                this.handler.RecordTextNodeOn();
                break;
            }
            case 2401: {
                this.addStyle();
                break;
            }
            case 130100: {
                this.handler.RecordTextNodeOn();
                break;
            }
            case 130101: {
                String string = Utilities.escapeXML(this.handler.getTextNode());
                if (string.contains("DOWN")) {
                    this.drills.put((Object)"down", (Object)string);
                    break;
                }
                this.drills.put((Object)"up", (Object)string);
                break;
            }
            case 110016: {
                this.handler.RecordTextNodeOn();
                break;
            }
            case 110017: {
                this.drillURL = this.getDrillURL(this.handler.getTextNode());
                break;
            }
            case 130102: {
                this.handler.RecordTextNodeOn();
                break;
            }
            case 130103: {
                Constants.RequestVersion requestVersion;
                String string = this.drillURL;
                String string2 = this.handler.getTextNode();
                if (!string2.isEmpty()) {
                    string = string + "?" + string2;
                }
                if ((requestVersion = this.handler.getRequestVersion()) == Constants.RequestVersion.V3) {
                    JSONArray jSONArray = (JSONArray)this.drills.get((Object)"drillthroughs");
                    if (jSONArray == null) {
                        jSONArray = new JSONArray();
                    }
                    jSONArray.add((Object)string);
                    this.drills.put((Object)"drillthroughs", (Object)jSONArray);
                    break;
                }
                this.drills.put((Object)"drillthroughs", (Object)string);
                break;
            }
        }
    }

    private boolean canInline() {
        return this.styles.size() == 0 && this.id == null;
    }

    private String getDrillURL(String string) {
        CSSPreprocessor cSSPreprocessor = (CSSPreprocessor)this.handler.getPreProcessor();
        return cSSPreprocessor.getDrillURL(string);
    }
}

