/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.ccs.formats.html;

import com.cognos.ccs.formats.html.AHTMLElement;
import com.cognos.ccs.formats.html.HTMLHandler;

public class AHTMLTableElement
extends AHTMLElement {
    protected static final String TABLE = "table";
    protected static final String TABLE_ROW = "tr";
    protected static final String TABLE_BEGIN = "<table cellspacing=\"0\" cellpadding=\"0\" border=\"0\"";
    boolean startTagClosed = false;
    protected boolean isLayoutTable = false;
    protected StringBuffer summaryText = null;
    protected String summaryId = "";

    public AHTMLTableElement(HTMLHandler hTMLHandler) {
        super(hTMLHandler);
    }

    protected void closeStartTag() {
        if (!this.startTagClosed) {
            this.startTagClosed = true;
            this.writeStyles();
            this.handler.write(">");
            this.writeCtxes();
        }
    }

    @Override
    public void processEvent(int n) {
        super.processEvent(n);
        if (this.handler.isGeneratingA11Y()) {
            switch (n) {
                case 150200: {
                    this.handler.RecordTextNodeOn();
                    break;
                }
                case 150201: {
                    this.summaryText = new StringBuffer();
                    this.summaryText.append(this.handler.getTextNode());
                    this.handler.RecordTextNodeOff();
                    break;
                }
                case 150052: {
                    this.handler.RecordTextNodeOn();
                    break;
                }
                case 150053: {
                    String string = this.handler.getTextNode();
                    this.handler.RecordTextNodeOff();
                    if (!"true".equals(string)) break;
                    this.isLayoutTable = true;
                }
            }
        }
    }

    @Override
    protected String getAdditionalStyleAttributes() {
        return "border-collapse:collapse; ";
    }

    protected void writeTableSummaryId() {
        this.summaryId = this.handler.generateUniqueID("ID_SUMMARYTEXT_");
        this.handler.writeAttribute("aria-describedby", this.summaryId);
    }

    protected void writeTableSummary() {
        if (this.summaryText == null) {
            this.summaryText = new StringBuffer();
        }
        String string = "<span id=\"%ID%\" style=\"position: absolute;margin-left: -9999px; margin-top: -9999px;\">%SUMMARY_TEXT%</span>".replace("%ID%", this.summaryId).replace("%SUMMARY_TEXT%", this.summaryText.toString());
        this.handler.write(string);
    }

    protected void handlePendingRoleAttributeWriting() {
        this.handler.stopPendingBuffer();
        if (this.isLayoutTable) {
            this.handler.writeAttribute("role", "presentation");
        } else {
            this.handler.writeAttribute("role", "grid");
        }
        this.writeTableSummaryId();
        this.handler.flushPendingBuffer();
        this.writeTableSummary();
    }

    @Override
    public void reset() {
        this.startTagClosed = false;
        this.isLayoutTable = false;
    }
}

