/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.ccs.formats.html;

import com.cognos.ccs.formats.html.AHTMLElement;
import com.cognos.ccs.formats.html.HTMLHandler;
import com.cognos.ccs.formats.html.HTMLObserver;

public class HTMLCell
extends AHTMLElement {
    private static final String COLSPAN = "colspan";
    private static final String ROWSPAN = "rowspan";
    private static final String TABLE_CELL = "td";
    private static final String TABLE_CELL_TH = "th";
    private static final String START_CELL = "<td";
    private static final String START_CELL_TH = "<th";
    protected int startEvent;
    protected int closeEvent;
    protected boolean startTagClosed;
    protected boolean pendingStartingCellTag;

    public HTMLCell(HTMLHandler hTMLHandler, int n, boolean bl) {
        super(hTMLHandler);
        this.startEvent = n;
        this.closeEvent = n + 1;
        this.startTagClosed = false;
        this.isHeader = bl;
        this.pendingStartingCellTag = false;
    }

    public HTMLCell(HTMLHandler hTMLHandler, int n) {
        this(hTMLHandler, n, false);
    }

    @Override
    public void processEvent(int n) {
        super.processEvent(n);
        if (n == this.startEvent) {
            if (this.handler.isGeneratingA11Y()) {
                this.pendingStartingCellTag = true;
                this.handler.startPendingBuffer();
            } else {
                this.handler.write(START_CELL);
            }
        } else if (n == this.closeEvent) {
            this.handleClose(n);
        } else if (n == 1600) {
            this.handler.RecordTextNodeOn();
        } else if (n == 1601) {
            this.handleRowspan();
        } else if (n == 1500) {
            this.handler.RecordTextNodeOn();
        } else if (n == 1501) {
            this.handleColumspan();
        } else if (n == 2300) {
            this.handleItem();
        }
    }

    @Override
    public void reset() {
        super.reset();
        this.startTagClosed = false;
        this.pendingStartingCellTag = false;
    }

    private void handleColumspan() {
        this.handler.writeAttribute(COLSPAN, this.handler.getTextNode());
        this.handler.RecordTextNodeOff();
    }

    private void handleRowspan() {
        this.handler.writeAttribute(ROWSPAN, this.handler.getTextNode());
        this.handler.RecordTextNodeOff();
    }

    private void handleClose(int n) {
        this.checkPendingCellTag();
        this.checkStartTagClosed();
        if (this.handler.isGeneratingA11Y()) {
            this.handler.writeClose(this.isHeader ? TABLE_CELL_TH : TABLE_CELL);
        } else {
            this.handler.writeClose(TABLE_CELL);
        }
        this.handler.popFsm();
        this.handler.injectEvent(n);
    }

    private void handleItem() {
        this.checkPendingCellTag();
        this.checkStartTagClosed();
        this.handler.pushFsm(new HTMLObserver(this.handler, 2301));
    }

    private void checkPendingCellTag() {
        if (this.handler.isGeneratingA11Y() && this.pendingStartingCellTag) {
            this.pendingStartingCellTag = false;
            this.handler.stopPendingBuffer();
            this.handler.write(this.isHeader ? START_CELL_TH : START_CELL);
            this.handler.flushPendingBuffer();
        }
    }

    private void checkStartTagClosed() {
        if (!this.startTagClosed) {
            this.writeStyles();
            this.handler.write(">");
            this.writeCtxes();
            this.startTagClosed = true;
        }
    }
}

