/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.ccs.formats.html;

import com.cognos.ccs.formats.html.AHTMLElement;
import com.cognos.ccs.formats.html.HTMLHandler;
import com.cognos.ccs.fsm.LdxHandler;
import com.cognos.ccs.utility.Utilities;

public class HTMLChartRegions
extends AHTMLElement {
    boolean firstX = true;
    String label;
    String alternateText = null;
    boolean writeClosingQuotesForCoords = false;

    public HTMLChartRegions(HTMLHandler hTMLHandler) {
        super(hTMLHandler);
    }

    @Override
    public void processEvent(int n) {
        switch (n) {
            case 110002: {
                this.handler.write("<area shape=\"poly\" nohref=\"nohref\" coords=\"");
                this.firstX = true;
                this.writeClosingQuotesForCoords = true;
                break;
            }
            case 110003: {
                this.writeClosingQuoteForCoord();
                String string = "";
                if (this.alternateText != null && !"".equals(this.alternateText)) {
                    string = Utilities.escapeXML(this.alternateText);
                } else if (this.label != null && !"".equals(this.label)) {
                    string = Utilities.escapeXML(this.label);
                }
                this.handler.writeAttribute("title", string);
                this.handler.writeAttribute("alt", string);
                if (this.handler.isGeneratingA11Y()) {
                    this.handler.writeAttribute("tabindex", "-1");
                }
                this.handler.write("/>");
                break;
            }
            case 110010: {
                this.handler.RecordTextNodeOn();
                break;
            }
            case 110011: {
                if (!this.firstX) {
                    this.handler.write(",");
                } else {
                    this.firstX = false;
                }
                this.handler.write(this.handler.getTextNode());
                this.handler.RecordTextNodeOff();
                break;
            }
            case 110012: {
                this.handler.RecordTextNodeOn();
                break;
            }
            case 110013: {
                this.handler.write(",");
                this.handler.write(this.handler.getTextNode());
                this.handler.RecordTextNodeOff();
                break;
            }
            case 4006: {
                this.writeClosingQuoteForCoord();
                this.handler.RecordTextNodeOn();
                break;
            }
            case 4007: {
                this.label = this.handler.getTextNode();
                break;
            }
            case 150202: {
                this.writeClosingQuoteForCoord();
                this.handler.RecordTextNodeOn();
                break;
            }
            case 150203: {
                this.alternateText = Utilities.escapeXML(this.handler.getTextNode());
                break;
            }
            case 1060: {
                this.handler.pushFsm(new MeasureFSM(this.handler));
                break;
            }
            case 150151: {
                this.handler.writeClose("map");
                this.handler.popFsm();
            }
        }
    }

    private void writeClosingQuoteForCoord() {
        if (this.writeClosingQuotesForCoords) {
            this.handler.write("\"");
            this.writeClosingQuotesForCoords = false;
        }
    }

    @Override
    public void reset() {
    }

    class MeasureFSM
    implements LdxHandler.FilterFSM {
        LdxHandler m_handler;

        public MeasureFSM(LdxHandler ldxHandler) {
            this.m_handler = ldxHandler;
        }

        @Override
        public void processEvent(int n) {
            if (n == 1061) {
                this.m_handler.popFsm();
            }
        }

        @Override
        public void reset() {
        }
    }
}

