/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.ccs.formats.html;

import com.cognos.ccs.exceptions.CCSException;
import com.cognos.ccs.exceptions.CCSGeneralException;
import com.cognos.ccs.formats.CCSFormatter;
import com.cognos.ccs.formats.html.AHTMLElement;
import com.cognos.ccs.formats.html.AHTMLTableElement;
import com.cognos.ccs.formats.html.HTMLCell;
import com.cognos.ccs.formats.html.HTMLDimensions;
import com.cognos.ccs.formats.html.HTMLHandler;
import com.cognos.ccs.formats.html.HTMLRow;
import com.cognos.ccs.fsm.LdxHandler;
import com.cognos.ccs.service.CCSLogger;
import com.cognos.ccs.utility.MemoryBufferStream;
import com.cognos.ccs.utility.SAXParserFactoryWrapper;
import java.io.StringReader;
import javax.xml.parsers.SAXParser;
import org.xml.sax.InputSource;
import org.xml.sax.helpers.DefaultHandler;

public class HTMLCrosstab
extends AHTMLTableElement {
    HTMLDimensions columnDims = null;
    HTMLDimensions rowDims = null;
    private int rowCount = 0;
    private boolean hasCorner = false;

    public HTMLCrosstab(HTMLHandler hTMLHandler) {
        super(hTMLHandler);
        this.initialize(hTMLHandler);
    }

    private void initialize(HTMLHandler hTMLHandler) {
        this.rowCount = 0;
        this.hasCorner = false;
        this.columnDims = new HTMLDimensions(hTMLHandler);
        this.rowDims = new HTMLDimensions(hTMLHandler);
    }

    @Override
    public void processEvent(int n) {
        super.processEvent(n);
        switch (n) {
            case 1400: {
                this.closeStartTag();
                this.handler.writeOpen("tr");
                this.hasCorner = true;
                this.handler.pushFsm(new HTMLCell(this.handler, n, true));
                this.handler.injectEvent(n);
                break;
            }
            case 1030: {
                this.handler.write("<table cellspacing=\"0\" cellpadding=\"0\" border=\"0\"");
                if (!this.handler.isGeneratingA11Y()) break;
                this.handler.startPendingBuffer();
                break;
            }
            case 1050: {
                this.closeStartTag();
                this.handler.pushFsm(this.columnDims);
                this.handler.injectEvent(n);
                break;
            }
            case 1040: {
                this.closeStartTag();
                this.handler.pushFsm(this.rowDims);
                this.handler.injectEvent(n);
                break;
            }
            case 1070: {
                this.closeStartTag();
                this.handler.pushFsm(new CrosstabDataTable(this.handler));
                this.handler.injectEvent(n);
                break;
            }
            case 1031: {
                this.handler.writeClose("table");
                if (this.handler.isGeneratingA11Y()) {
                    this.handlePendingRoleAttributeWriting();
                }
                this.handler.popFsm();
            }
        }
    }

    public void writeRowDim() {
        this.handler.writeOpen("tr");
        String[] stringArray = this.rowDims.getDimensionCells(this.rowCount);
        this.writeDimensionCells(stringArray);
        ++this.rowCount;
    }

    private void writeColumnDims() {
        for (int i = 0; i < this.columnDims.getNestedLevels(); ++i) {
            String[] stringArray = this.columnDims.getDimensionCells(i);
            if (0 != i || !this.hasCorner) {
                this.handler.writeOpen("tr");
            }
            this.writeDimensionCells(stringArray);
            this.handler.writeClose("tr");
        }
    }

    private void writeDimensionCells(String[] stringArray) {
        for (int i = 0; i < stringArray.length; ++i) {
            Object object;
            try {
                MemoryBufferStream memoryBufferStream = new MemoryBufferStream();
                object = (HTMLHandler)this.handler.getClass().newInstance();
                ((HTMLHandler)object).shareStates(this.handler);
                ((HTMLHandler)object).setConversation(this.handler.getConversation());
                ((CCSFormatter)object).setRequestVersion(this.handler.getRequestVersion());
                ((CCSFormatter)object).setProductLocale(this.handler.getProductLocale());
                ((CCSFormatter)object).setIsAccessibilityFeaturesEnabled(this.handler.getIsAccessibilityFeaturesEnabled());
                ((HTMLHandler)object).setPreProcessor(this.handler.getPreProcessor());
                ((LdxHandler)object).setOutStream(memoryBufferStream);
                ((LdxHandler)object).pushFsm(new HTMLCell((HTMLHandler)object, 1100, true));
                SAXParser sAXParser = SAXParserFactoryWrapper.getParser();
                sAXParser.parse(new InputSource(new StringReader(stringArray[i])), (DefaultHandler)object);
                this.handler.write(memoryBufferStream.getBuffer());
                continue;
            }
            catch (Exception exception) {
                object = new CCSGeneralException("PARSE_STREAM_ERROR", exception, 500);
                CCSLogger.getInstance().logRuntimeErrorMessage(((CCSException)object).getServerLocaleMessage(), null, null, null, ((CCSGeneralException)object).getSourceTrace());
                exception.printStackTrace();
            }
        }
    }

    @Override
    public void reset() {
        super.reset();
        this.initialize(this.handler);
    }

    private class CrosstabDataTable
    extends AHTMLElement {
        public CrosstabDataTable(HTMLHandler hTMLHandler) {
            super(hTMLHandler);
        }

        @Override
        public void processEvent(int n) {
            switch (n) {
                case 1070: {
                    HTMLCrosstab.this.writeColumnDims();
                    break;
                }
                case 1040: {
                    HTMLCrosstab.this.writeRowDim();
                    this.handler.pushFsm(new HTMLRow(this.handler));
                    break;
                }
                case 1071: {
                    this.handler.popFsm();
                }
            }
        }
    }
}

