/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.ccs.formats.html;

import com.cognos.ccs.formats.html.AHTMLElement;
import com.cognos.ccs.formats.html.HTMLHandler;
import java.util.Vector;

public class HTMLDimensions
extends AHTMLElement {
    Vector rowcols = new Vector();
    boolean firstChild = true;

    public HTMLDimensions(HTMLHandler hTMLHandler) {
        super(hTMLHandler);
    }

    @Override
    public void processEvent(int n) {
        switch (n) {
            case 1050: {
                this.handler.pushFsm(new HTMLDimension(this.handler, 0, true, this.firstChild));
                if (!this.firstChild) break;
                this.firstChild = false;
                break;
            }
            case 1040: {
                this.insertRowIfNeeded(0);
                this.handler.pushFsm(new HTMLDimension(this.handler, 0, false, this.firstChild));
                if (!this.firstChild) break;
                this.firstChild = false;
                break;
            }
            case 1041: 
            case 1051: {
                this.handler.popFsm();
            }
        }
    }

    private void AddDimension(HTMLDimension hTMLDimension, int n) {
        if (hTMLDimension.isColumn) {
            Vector vector = this.getRow(n);
            vector.add(hTMLDimension);
        } else if (hTMLDimension.isFirstCell) {
            Vector vector = this.getRow(this.rowcols.size() - 1);
            vector.add(hTMLDimension);
        } else {
            this.insertRowIfNeeded(this.rowcols.size());
            Vector vector = this.getRow(this.rowcols.size() - 1);
            vector.add(hTMLDimension);
        }
    }

    private void insertRowIfNeeded(int n) {
        if (this.rowcols.size() <= n) {
            this.rowcols.add(new Vector());
        }
    }

    private Vector getRow(int n) {
        if (this.rowcols == null || this.rowcols.size() <= n) {
            return null;
        }
        Vector vector = (Vector)this.rowcols.get(n);
        return vector;
    }

    public int getNestedLevels() {
        return this.rowcols.size();
    }

    public String[] getDimensionCells(int n) {
        Vector vector = this.getRow(n);
        if (vector == null) {
            return new String[0];
        }
        String[] stringArray = new String[vector.size()];
        for (int i = 0; i < vector.size(); ++i) {
            HTMLDimension hTMLDimension = (HTMLDimension)vector.get(i);
            stringArray[i] = hTMLDimension.dimensionCellXML;
        }
        return stringArray;
    }

    private class HTMLDimension
    extends AHTMLElement {
        int m_state;
        protected static final int DIM_START = 100;
        protected static final int DIM_DRILLS = 200;
        private String dimensionCellXML;
        private int position;
        private boolean isColumn;
        private boolean isFirstCell;
        private boolean isFirstChild;
        private int nestedNamesCount;

        public HTMLDimension(HTMLHandler hTMLHandler, int n, boolean bl, boolean bl2) {
            super(hTMLHandler);
            this.m_state = 100;
            this.dimensionCellXML = "";
            this.position = 0;
            this.isColumn = false;
            this.isFirstCell = false;
            this.isFirstChild = true;
            this.nestedNamesCount = 0;
            this.position = n;
            this.isColumn = bl;
            this.isFirstCell = bl2;
        }

        @Override
        public void processEvent(int n) {
            switch (this.m_state) {
                case 100: {
                    this.processDim(n);
                    break;
                }
                case 200: {
                    this.processDrill(n);
                }
            }
        }

        public void processDim(int n) {
            switch (n) {
                case 1100: {
                    if (++this.nestedNamesCount != 1) break;
                    if (this.isColumn) {
                        HTMLDimensions.this.insertRowIfNeeded(this.position);
                    }
                    this.handler.startRecording();
                    break;
                }
                case 1101: {
                    if (--this.nestedNamesCount != 0) break;
                    this.dimensionCellXML = this.handler.getRecordedText();
                    this.handler.stopRecording();
                    HTMLDimensions.this.AddDimension(this, this.position);
                    break;
                }
                case 10000: {
                    this.m_state = 200;
                    break;
                }
                case 1090: {
                    this.handler.pushFsm(new HTMLDimension(this.handler, this.position + 1, this.isColumn, this.isFirstChild));
                    if (!this.isFirstChild) break;
                    this.isFirstChild = false;
                    break;
                }
                case 1091: {
                    if (this.nestedNamesCount != 0) break;
                    this.handler.popFsm();
                    break;
                }
                case 1041: 
                case 1051: {
                    if (this.nestedNamesCount != 0) break;
                    this.handler.popFsm();
                    this.handler.injectEvent(n);
                }
            }
        }

        public void processDrill(int n) {
            switch (n) {
                case 10001: {
                    this.m_state = 100;
                }
            }
        }
    }
}

