/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.ccs.formats.html;

import com.cognos.ccs.content.StyleGroup;
import com.cognos.ccs.formats.css.CSSPreprocessor;
import com.cognos.ccs.formats.html.AHTMLElement;
import com.cognos.ccs.formats.html.HTMLHandler;
import com.cognos.ccs.formats.html.HTMLPage;
import com.cognos.ccs.service.CCLMessage;
import java.util.Iterator;

public class HTMLDocument
extends AHTMLElement {
    private static final String STYLE_HEAD_START = "<head><meta http-equiv=\"X-UA-Compatible\" content=\"IE=11\"/><title>%REPORT_TITLE%</title><style type=\"text/css\">";
    private static final String STYLE_HEAD_CLOSE = "</style></head>";
    private static final String HTML = "html";
    private static final String BODY = "body";
    private static final String BODY_START = "<body";
    private static final String HTML_START = "<html";
    private static final String HTML_DOCTYPE = "<!DOCTYPE HTML>";
    private static final String XML_DECLARATION = "";
    private static final String HTML_LANG = " lang";
    private static final String STYLE_SKIPTOMAIN = ".showOnFocus {position:absolute;top:-9999px;left:-9999px;} .showOnFocus:focus {background-color:#ffffff; border-bottom-left-radius:4px; border-bottom-right-radius: 4px;border-color: #999999;border-style: solid;border-width: 0 4px 4px;box-shadow: 2px 2px 3px #bababa;font-size: 70%;top: 0px;left: 0px;padding: 5px;position:absolute;}";
    private static final String ANCHOR_SKIPTOMAIN = "<a href=\"#maincontent\" tabindex=\"0\" class=\"showOnFocus\">%SKIPTOMAIN%</a>";

    public HTMLDocument(HTMLHandler hTMLHandler) {
        super(hTMLHandler);
    }

    @Override
    public void processEvent(int n) {
        switch (n) {
            case 3300: {
                this.startHTMLDocument();
                break;
            }
            case 3100: {
                this.handler.RecordTextNodeOn();
                break;
            }
            case 3101: {
                this.handler.setGlobal("versionBase", this.handler.getTextNode());
                break;
            }
            case 19010: {
                this.handler.RecordTextNodeOn();
                break;
            }
            case 19011: {
                this.handler.setGlobal(this.handler.getTextNode(), "true");
                this.handler.RecordTextNodeOff();
                break;
            }
            case 2800: {
                this.handler.pushFsm(new HTMLPage(this.handler));
                this.handler.injectEvent(n);
                break;
            }
            case 3301: {
                this.endHTMLDocument();
            }
        }
    }

    protected void endHTMLDocument() {
        if (this.handler.isGeneratingA11Y()) {
            this.handler.writeClose("div");
        }
        this.handler.writeClose(BODY);
        this.handler.writeClose(HTML);
        this.handler.popFsm();
    }

    protected void startHTMLDocument() {
        this.handler.write(XML_DECLARATION);
        this.handler.write(HTML_DOCTYPE);
        this.handler.write(HTML_START);
        if (this.handler.isGeneratingA11Y()) {
            this.writeLang();
        }
        this.handler.write(">");
        this.writePreProcessedStyles();
        this.handler.write(BODY_START);
        this.handler.write(">");
        if (this.handler.isGeneratingA11Y()) {
            this.handler.write("<div");
            this.handler.writeAttribute("role", "navigation");
            this.handler.write(">");
            String string = CCLMessage.getResMessage("SKIP_TO_MAIN", this.handler.getProductLocale());
            String string2 = ANCHOR_SKIPTOMAIN.replace("%SKIPTOMAIN%", string);
            this.handler.write(string2);
            this.handler.writeClose("div");
            this.handler.write("<div");
            this.handler.writeAttribute("id", "maincontent");
            this.handler.writeAttribute("role", "main");
            this.handler.write(">");
        }
    }

    private void writeLang() {
        CSSPreprocessor cSSPreprocessor = (CSSPreprocessor)this.handler.getPreProcessor();
        if (cSSPreprocessor != null) {
            String string = cSSPreprocessor.getLang();
            if (string == null || XML_DECLARATION.equals(string)) {
                if (this.handler.getProductLocale() != null) {
                    string = this.handler.getProductLocale().toString();
                }
                if (string == null) {
                    string = XML_DECLARATION;
                }
            }
            this.handler.writeAttribute(HTML_LANG, string);
        }
    }

    protected void writePreProcessedStyles() {
        CSSPreprocessor cSSPreprocessor = (CSSPreprocessor)this.handler.getPreProcessor();
        String string = STYLE_HEAD_START;
        String string2 = XML_DECLARATION;
        if (this.handler.isGeneratingA11Y()) {
            string2 = this.handler.getReportName() != null ? this.handler.getReportName() : XML_DECLARATION;
        }
        string = string.replace("%REPORT_TITLE%", string2);
        this.handler.write(string);
        this.writeCssStyles(cSSPreprocessor);
        if (this.handler.isGeneratingA11Y()) {
            this.handler.write(STYLE_SKIPTOMAIN);
        }
        this.handler.write(STYLE_HEAD_CLOSE);
    }

    protected void writeCssStyles(CSSPreprocessor cSSPreprocessor) {
        if (cSSPreprocessor.getStyleCount() > 0) {
            Iterator<StyleGroup> iterator = cSSPreprocessor.getStyleIterator();
            while (iterator.hasNext()) {
                StyleGroup styleGroup = iterator.next();
                this.handler.write(styleGroup.generateCSS(false));
            }
        }
    }
}

