/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.ccs.formats.html;

import com.cognos.ccs.formats.html.AHTMLElement;
import com.cognos.ccs.formats.html.HTMLCell;
import com.cognos.ccs.formats.html.HTMLHandler;
import com.cognos.ccs.formats.html.HTMLRow;

public class HTMLGroupSection
extends AHTMLElement {
    private static final String TABLE_ROW = "tr";
    boolean inColTitle = false;

    public HTMLGroupSection(HTMLHandler hTMLHandler) {
        super(hTMLHandler);
    }

    @Override
    public void processEvent(int n) {
        switch (n) {
            case 1040: {
                this.handleRowToken(n);
                break;
            }
            case 1700: {
                this.handleColTitleToken(n);
                break;
            }
            case 1801: 
            case 1901: 
            case 2001: {
                this.checkEndColTitle();
                this.handler.popFsm();
                break;
            }
            case 1900: {
                this.handleSubGroupToken();
                break;
            }
        }
    }

    private void handleSubGroupToken() {
        this.checkEndColTitle();
        this.handler.pushFsm(new HTMLGroupSection(this.handler));
    }

    private void handleColTitleToken(int n) {
        this.checkStartColTitle();
        this.handler.pushFsm(new HTMLCell(this.handler, n, true));
        this.handler.injectEvent(n);
    }

    private void handleRowToken(int n) {
        this.checkEndColTitle();
        this.handler.pushFsm(new HTMLRow(this.handler));
        this.handler.injectEvent(n);
    }

    private void checkStartColTitle() {
        if (!this.inColTitle) {
            this.handler.writeOpen(TABLE_ROW);
            this.inColTitle = true;
        }
    }

    private void checkEndColTitle() {
        if (this.inColTitle) {
            this.handler.writeClose(TABLE_ROW);
            this.inColTitle = false;
        }
    }
}

