/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.ccs.formats.html;

import com.cognos.ccs.formats.CCSFormatter;
import com.cognos.ccs.formats.css.CSSPreprocessor;
import com.cognos.ccs.formats.html.HTMLGenerationStates;
import com.cognos.ccs.formats.html.HTMLObserver;
import com.cognos.ccs.service.Conversation;
import com.cognos.ccs.utility.Utilities;
import com.ibm.cognos.ccs.internal.utility.Constants;

public class HTMLHandler
extends CCSFormatter {
    protected boolean m_inlineStyles = false;
    protected String m_cssSuffix = "";
    HTMLGenerationStates states = new HTMLGenerationStates();

    public HTMLHandler() {
        HTMLObserver hTMLObserver = new HTMLObserver(this);
        this.SetFsm(hTMLObserver);
        this.preprocessor = new CSSPreprocessor();
    }

    public void setPreProcessor(CCSFormatter cCSFormatter) {
        this.preprocessor = cCSFormatter;
    }

    @Override
    public void setConversation(Conversation conversation) {
        this.m_conversation = conversation;
        if (this.m_conversation != null) {
            this.m_inlineStyles = Utilities.parseOptionalObjectBoolean(this.m_conversation.getProperty("inlineStyles"), this.m_inlineStyles);
        }
    }

    public boolean useInlineStyles() {
        return this.m_inlineStyles;
    }

    protected boolean isHTMLFragment() {
        return false;
    }

    public boolean isGeneratingA11Y() {
        return this.getIsAccessibilityFeaturesEnabled() && this.getRequestVersion() == Constants.RequestVersion.V3;
    }

    public void shareStates(HTMLHandler hTMLHandler) {
        this.states = hTMLHandler.states;
    }

    public String generateUniqueID(String string) {
        return string + ++this.states.unique_html_id;
    }

    public String getCssSuffix() {
        return this.m_cssSuffix;
    }

    @Override
    public void setCssSuffix(String string) {
        if (string == null) {
            string = "";
        }
        this.m_cssSuffix = string;
        this.preprocessor.setCssSuffix(this.m_cssSuffix);
    }
}

