/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.ccs.formats.html;

import com.cognos.ccs.formats.html.AHTMLElement;
import com.cognos.ccs.formats.html.HTMLHandler;
import com.cognos.ccs.formats.html.HTMLObserver;
import com.ibm.cognos.ccs.internal.utility.Constants;

public class HTMLPage
extends AHTMLElement {
    private static final String DIV = "div";
    private static final String START_DIV = "<div";
    private boolean isStartTagClosed = false;
    private boolean isWriteSecondaryOps = false;

    public HTMLPage(HTMLHandler hTMLHandler) {
        super(hTMLHandler);
    }

    @Override
    public void processEvent(int n) {
        super.processEvent(n);
        switch (n) {
            case 2800: {
                this.handler.write(START_DIV);
                if (this.handler.getRequestVersion() == Constants.RequestVersion.V3) break;
                this.isWriteSecondaryOps = true;
                this.addSecondaryOps();
                break;
            }
            case 2000: 
            case 2100: 
            case 2900: {
                this.checkCloseStartTag();
                this.handler.writeOpen(DIV);
                break;
            }
            case 2001: 
            case 2101: 
            case 2901: {
                this.handler.writeClose(DIV);
                break;
            }
            case 2300: {
                this.handler.pushFsm(new HTMLObserver(this.handler, 2301));
                break;
            }
            case 2801: {
                this.checkCloseStartTag();
                this.handler.writeClose(DIV);
                this.handler.popFsm();
            }
        }
    }

    private void checkCloseStartTag() {
        if (!this.isStartTagClosed) {
            this.writeStyles();
            this.handler.write(">");
            this.writeCtxes();
            this.isStartTagClosed = true;
            if (!this.isWriteSecondaryOps) {
                this.isWriteSecondaryOps = true;
                this.addSecondaryOps();
            }
        }
    }
}

