/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.ccs.formats.html;

import com.cognos.ccs.formats.html.AHTMLElement;
import com.cognos.ccs.formats.html.HTMLHandler;
import com.cognos.ccs.formats.html.HTMLImage;
import com.cognos.ccs.utility.Utilities;

public class HTMLRichText
extends AHTMLElement {
    protected static final String DIV_START = "<div";
    protected static final String DIV = "div";
    protected static final String SPAN_START = "<span";
    protected static final String SPAN = "span";
    protected static final String UL_START = "<ul";
    protected static final String UL = "ul";
    protected static final String OL_START = "<ol";
    protected static final String OL = "ol";
    protected static final String LI = "li";
    protected boolean tagOpen = false;
    protected boolean isOrdered = false;
    protected boolean hasFmtVal = false;
    protected String rawVal = null;
    protected String tagBuffer = null;

    public HTMLRichText(HTMLHandler hTMLHandler) {
        super(hTMLHandler);
    }

    @Override
    public void processEvent(int n) {
        super.processEvent(n);
        switch (n) {
            case 7000: {
                this.handler.write(DIV_START);
                this.tagOpen = true;
                break;
            }
            case 7001: {
                this.closeTagIfNecessary();
                this.handler.writeClose(DIV);
                this.handler.popFsm();
                break;
            }
            case 7004: {
                this.closeTagIfNecessary();
                this.handler.write(DIV_START);
                this.tagOpen = true;
                break;
            }
            case 7005: {
                this.closeTagIfNecessary();
                this.handler.writeClose(DIV);
                break;
            }
            case 7010: {
                this.closeTagIfNecessary();
                break;
            }
            case 2500: 
            case 7002: {
                this.closeTagIfNecessary();
                this.handler.write(SPAN_START);
                this.tagOpen = true;
                break;
            }
            case 2501: 
            case 7003: {
                this.writeRawValIfNecessary();
                this.handler.writeClose(SPAN);
                break;
            }
            case 7006: {
                this.handler.RecordTextNodeOn();
                break;
            }
            case 7011: {
                if (this.isOrdered) {
                    this.handler.writeClose(OL);
                    break;
                }
                this.handler.writeClose(UL);
                break;
            }
            case 7007: {
                this.handleRTListOrder();
                break;
            }
            case 7008: {
                this.handler.writeOpen(LI);
                break;
            }
            case 7009: {
                this.writeRawValIfNecessary();
                this.handler.writeClose(LI);
                break;
            }
            case 1080: {
                this.handler.RecordTextNodeOn();
                break;
            }
            case 1081: {
                this.rawVal = this.handler.getTextNode();
                this.handler.RecordTextNodeOff();
                break;
            }
            case 3800: {
                this.hasFmtVal = true;
                this.closeTagIfNecessary();
                this.handler.RecordTextNodeOn();
                break;
            }
            case 3801: {
                this.handler.write(this.handler.escapeIfNeeded(this.handler.getTextNode()));
                this.handler.RecordTextNodeOff();
                break;
            }
            case 1070: {
                this.closeTagIfNecessary();
                this.handler.write("<table");
                this.tagOpen = true;
                break;
            }
            case 1071: {
                this.handler.writeClose("table");
                this.tagOpen = false;
                break;
            }
            case 7014: {
                this.closeTagIfNecessary();
                this.handler.write("<tr");
                this.tagOpen = true;
                break;
            }
            case 7015: {
                this.handler.writeClose("tr");
                this.tagOpen = false;
                break;
            }
            case 7016: {
                this.closeTagIfNecessary();
                this.handler.write("<td");
                this.tagOpen = true;
                break;
            }
            case 7017: {
                this.closeTagIfNecessary();
                this.handler.writeClose("td");
                this.tagOpen = false;
                break;
            }
            case 2600: {
                this.closeTagIfNecessary();
                this.handler.pushFsm(new HTMLImage(this.handler));
                this.handler.injectEvent(n);
            }
        }
    }

    private void handleRTListOrder() {
        this.closeTagIfNecessary();
        this.isOrdered = Utilities.parseXMLBoolean(this.handler.getTextNode());
        if (this.isOrdered) {
            this.handler.write(OL_START);
        } else {
            this.handler.write(UL_START);
        }
        this.writeStyles();
        this.handler.write(">");
        this.handler.RecordTextNodeOff();
    }

    private void writeRawValIfNecessary() {
        if (this.rawVal != null && !this.hasFmtVal) {
            this.closeTagIfNecessary();
            this.handler.write(this.handler.escapeIfNeeded(this.rawVal));
        }
        this.hasFmtVal = false;
        this.rawVal = null;
    }

    private void closeTagIfNecessary() {
        if (this.tagOpen) {
            this.writeStyles();
            this.handler.write(">");
            this.writeCtxes();
            this.tagOpen = false;
        }
    }
}

