/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.ccs.formats.html;

import com.cognos.ccs.formats.html.AHTMLElement;
import com.cognos.ccs.formats.html.HTMLHandler;
import com.cognos.ccs.formats.html.HTMLObserver;

public class HTMLTableOfContents
extends AHTMLElement {
    private static final String DIV_START = "<div ";
    private static final String DIV_TAG = "div";
    private boolean startTagClosed = false;

    public HTMLTableOfContents(HTMLHandler hTMLHandler) {
        super(hTMLHandler);
    }

    @Override
    public void processEvent(int n) {
        super.processEvent(n);
        switch (n) {
            case 6000: {
                this.handler.write(DIV_START);
                break;
            }
            case 6001: {
                this.handler.writeClose(DIV_TAG);
                this.handler.popFsm();
                break;
            }
            case 6006: {
                this.checkCloseStartTag();
                this.handler.pushFsm(new TOCEntry(this.handler));
                this.handler.injectEvent(n);
            }
        }
    }

    private void checkCloseStartTag() {
        if (!this.startTagClosed) {
            this.startTagClosed = true;
            this.writeStyles();
            this.handler.write(">");
        }
    }

    public class TOCEntry
    extends AHTMLElement {
        private static final String START_TOC_ENTRY_TABLE = "<table cellpadding=\"0\" style=\"border-collapse: collapse; width: 100%;\">";
        private static final String TABLE_ROW = "tr";
        private static final String TABLE_TAG = "table";
        private static final String TABLE_CELL = "td";
        private boolean startClosed;

        public TOCEntry(HTMLHandler hTMLHandler) {
            super(hTMLHandler);
        }

        @Override
        public void processEvent(int n) {
            super.processEvent(n);
            switch (n) {
                case 6006: {
                    this.handler.write(HTMLTableOfContents.DIV_START);
                    if (!this.handler.isGeneratingA11Y()) break;
                    this.handler.writeAttribute("role", "link");
                    break;
                }
                case 6007: {
                    this.handler.writeClose(TABLE_ROW);
                    this.handler.writeClose(TABLE_TAG);
                    this.handler.writeClose(HTMLTableOfContents.DIV_TAG);
                    this.handler.popFsm();
                    break;
                }
                case 6002: {
                    this.handler.RecordTextNodeOn();
                    break;
                }
                case 6003: {
                    String string = "document.location='#" + this.handler.getTextNode() + "';";
                    this.handler.writeAttribute("onclick", string);
                    if (this.handler.isGeneratingA11Y()) {
                        this.handler.writeAttribute("onkeypress", "if (event.keyCode==9) return true; else if (event.keyCode==13 || event.keyCode==32 || event.charCode==32)" + string + "return false;");
                    }
                    this.handler.RecordTextNodeOff();
                    break;
                }
                case 2300: {
                    this.checkNeedCloseStartTag();
                    this.handler.writeOpen(TABLE_CELL);
                    this.handler.pushFsm(new HTMLObserver(this.handler, 2301));
                    break;
                }
                case 2301: {
                    this.handler.writeClose(TABLE_CELL);
                }
            }
        }

        private void checkNeedCloseStartTag() {
            if (!this.startClosed) {
                this.startClosed = true;
                this.writeStyles();
                this.handler.write(">");
                this.writeCtxes();
                this.handler.write(START_TOC_ENTRY_TABLE);
                this.handler.writeOpen(TABLE_ROW);
            }
        }
    }
}

