/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.ccs.formats.image;

import com.cognos.accman.jcam.crypto.CAMCryptoException;
import com.cognos.accman.jcam.crypto.CAMFactory;
import com.cognos.ccs.exceptions.CCSGeneralException;
import com.cognos.ccs.service.CCSLogger;
import com.cognos.ccs.utility.CAMFactorySingleton;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.net.MalformedURLException;
import java.net.URL;
import javax.imageio.ImageIO;
import javax.swing.text.Element;
import javax.swing.text.html.HTML;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.ImageView;
import org.apache.commons.httpclient.Cookie;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.GetMethod;

public class CCSImageView
extends ImageView {
    Cookie[] cookies;

    public CCSImageView(Element element, Cookie[] cookieArray) {
        super(element);
        this.cookies = cookieArray;
    }

    @Override
    public URL getImageURL() {
        String string = (String)this.getElement().getAttributes().getAttribute(HTML.Attribute.SRC);
        if (string == null) {
            return null;
        }
        URL uRL = ((HTMLDocument)this.getDocument()).getBase();
        try {
            return new URL(uRL, string);
        }
        catch (MalformedURLException malformedURLException) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Image getImage() {
        BufferedImage bufferedImage = null;
        URL uRL = this.getImageURL();
        boolean bl = uRL.getProtocol().equalsIgnoreCase("https");
        GetMethod getMethod = new GetMethod(uRL.toString());
        try {
            HttpClient httpClient = this.createClientConnection(uRL, bl);
            int n = httpClient.executeMethod((HttpMethod)getMethod);
            if (n == 200) {
                byte[] byArray = getMethod.getResponseBody();
                bufferedImage = ImageIO.read(new ByteArrayInputStream(byArray));
            }
        }
        catch (Exception exception) {
            CCSGeneralException cCSGeneralException = new CCSGeneralException("FMT=IMAGE_ERROR", exception, 500);
            CCSLogger.getInstance().logRuntimeErrorMessage(cCSGeneralException.getServerLocaleMessage(), null, null, null, cCSGeneralException.getSourceTrace());
        }
        finally {
            getMethod.releaseConnection();
        }
        return bufferedImage;
    }

    private HttpClient createClientConnection(URL uRL, boolean bl) throws CAMCryptoException {
        CAMFactory cAMFactory = CAMFactorySingleton.INSTANCE.getCAMFactory();
        return cAMFactory.createHttpClient(uRL.getHost(), uRL.getPort(), bl);
    }
}

