/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.ccs.formats.json;

import com.cognos.ccs.exceptions.CCSGeneralException;
import com.cognos.ccs.formats.CCSFormatter;
import com.cognos.ccs.formats.json.MaxOccurs;
import com.cognos.ccs.service.CCSLogger;
import com.cognos.ccs.utility.Utilities;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.Stack;
import java.util.regex.Pattern;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class JSONHandler
extends CCSFormatter {
    private static final int OPEN = 1;
    private static final int CLOSE = 0;
    private int PrevTag = 1;
    private String PrevCloseTag = null;
    private int depth = 0;
    private Stack<Integer> depthStack = new Stack();
    private Stack<String> arrayTags = new Stack();
    private static final Pattern patternBSlash = Pattern.compile("\\\\");
    private static final Pattern patternBSlashQuote = Pattern.compile("\\\"");
    private static final Pattern patternNL = Pattern.compile("\n");
    private static final Pattern patternTAB = Pattern.compile("\t");
    private static final String JSON_NULL_Value = "null";
    private MaxOccurs.SourceType sourceType = MaxOccurs.SourceType.LDX;
    static Map<String, Boolean> dataSetArray = null;

    public JSONHandler() {
        this(MaxOccurs.SourceType.LDX);
    }

    public JSONHandler(MaxOccurs.SourceType sourceType) {
        this.sourceType = sourceType;
        try {
            if (this.sourceType == MaxOccurs.SourceType.LDX) {
                MaxOccurs.initializeLDXTagNames();
            } else {
                MaxOccurs.initializeDatasetTagNames();
            }
        }
        catch (Exception exception) {
            CCSGeneralException cCSGeneralException = new CCSGeneralException("PARSE_STREAM_ERROR", exception, 400);
            CCSLogger.getInstance().logRuntimeErrorMessage(cCSGeneralException.getServerLocaleMessage(), null, null, null, cCSGeneralException.getSourceTrace());
        }
    }

    public JSONHandler(InputStream inputStream) {
        try {
            MaxOccurs.initializeLDXTagNames(inputStream);
        }
        catch (Exception exception) {
            CCSGeneralException cCSGeneralException = new CCSGeneralException("PARSE_STREAM_ERROR", exception, 400);
            CCSLogger.getInstance().logRuntimeErrorMessage(cCSGeneralException.getServerLocaleMessage(), null, null, null, cCSGeneralException.getSourceTrace());
        }
    }

    private String quote(String string) throws IOException, NullPointerException {
        string = patternBSlash.matcher(string).replaceAll("\\\\\\\\");
        string = patternBSlashQuote.matcher(string).replaceAll("\\\\\"");
        string = patternNL.matcher(string).replaceAll("\\\\n");
        string = patternTAB.matcher(string).replaceAll("\\\\t");
        return "\"" + string + "\"";
    }

    @Override
    public void startDocument() throws SAXException {
    }

    @Override
    public void endDocument() throws SAXException {
        try {
            this.m_OutputWriter.write("}");
            this.m_OutputWriter.flush();
        }
        catch (IOException iOException) {
            CCSGeneralException cCSGeneralException = new CCSGeneralException("PARSE_STREAM_ERROR", iOException, 400);
            CCSLogger.getInstance().logRuntimeErrorMessage(cCSGeneralException.getServerLocaleMessage(), null, null, null, cCSGeneralException.getSourceTrace());
        }
    }

    @Override
    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        boolean bl = true;
        boolean bl2 = true;
        boolean bl3 = false;
        ++this.depth;
        try {
            String string4;
            if (this.PrevTag == 0 && !this.arrayTags.empty() && !string2.equals(string4 = this.arrayTags.peek()) && this.PrevCloseTag.equals(string4)) {
                this.m_OutputWriter.write("]");
                this.arrayTags.pop();
                this.depthStack.pop();
            }
            if (MaxOccurs.contains(string2, this.sourceType) && (this.arrayTags.empty() || !this.arrayTags.empty() && !string2.equals(this.arrayTags.peek()) || this.depth != this.depthStack.peek())) {
                if (this.PrevTag == 1) {
                    this.m_OutputWriter.write("{");
                } else {
                    this.m_OutputWriter.write(",");
                }
                this.m_OutputWriter.write(this.quote(string2));
                this.m_OutputWriter.write(":[");
                this.depthStack.push(new Integer(this.depth));
                this.arrayTags.push(string2);
                bl = false;
                bl2 = false;
                bl3 = true;
            }
            if (this.PrevTag == 0) {
                if (!this.arrayTags.empty()) {
                    string4 = this.arrayTags.peek();
                    if (!bl3 && string2.equals(string4)) {
                        bl2 = true;
                        bl = false;
                    }
                }
                if (bl2) {
                    this.m_OutputWriter.write(",");
                }
            } else if (bl) {
                this.m_OutputWriter.write("{");
            }
            if (bl) {
                this.m_OutputWriter.write(this.quote(string2));
                this.m_OutputWriter.write(":");
            }
            this.PrevTag = 1;
            this.RecordTextNodeOn();
        }
        catch (IOException iOException) {
            CCSGeneralException cCSGeneralException = new CCSGeneralException("PARSE_STREAM_ERROR", iOException, 500);
            CCSLogger.getInstance().logRuntimeErrorMessage(cCSGeneralException.getLocalizedMessage(), "startElement", null, null, cCSGeneralException.getSourceTrace());
            try {
                this.m_OutputWriter.write(iOException.toString());
            }
            catch (IOException iOException2) {
                cCSGeneralException = new CCSGeneralException("PARSE_STREAM_ERROR", iOException2, 500);
                CCSLogger.getInstance().logRuntimeErrorMessage(cCSGeneralException.getLocalizedMessage(), "startElement_2", null, null, cCSGeneralException.getSourceTrace());
            }
        }
    }

    @Override
    public void endElement(String string, String string2, String string3) throws SAXException {
        try {
            if (this.PrevTag == 0) {
                if (!this.arrayTags.empty() && !string2.equals(this.arrayTags.peek()) && this.depth < this.depthStack.peek()) {
                    this.m_OutputWriter.write("]");
                    this.arrayTags.pop();
                    this.depthStack.pop();
                }
                this.m_OutputWriter.write("}");
            } else {
                String string4 = this.getTextNode();
                if (!Utilities.isNullOrBlank(string4)) {
                    this.m_OutputWriter.write(this.quote(string4));
                } else {
                    this.m_OutputWriter.write(JSON_NULL_Value);
                }
                this.RecordTextNodeOff();
            }
            this.PrevCloseTag = string2;
            this.PrevTag = 0;
            --this.depth;
        }
        catch (IOException iOException) {
            CCSGeneralException cCSGeneralException = new CCSGeneralException("PARSE_STREAM_ERROR", iOException, 500);
            CCSLogger.getInstance().logRuntimeErrorMessage(cCSGeneralException.getLocalizedMessage(), "endElement", null, null, cCSGeneralException.getSourceTrace());
            try {
                this.m_OutputWriter.write(iOException.toString());
            }
            catch (IOException iOException2) {
                cCSGeneralException = new CCSGeneralException("PARSE_STREAM_ERROR", iOException2, 500);
                CCSLogger.getInstance().logRuntimeErrorMessage(cCSGeneralException.getLocalizedMessage(), "endElement_2", null, null, cCSGeneralException.getSourceTrace());
            }
        }
    }
}

