/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.ccs.formats.json;

import com.cognos.ccs.service.ConfigMgr;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.List;
import java.util.TreeSet;
import org.dom4j.Document;
import org.dom4j.Node;
import org.dom4j.io.SAXReader;

public class MaxOccurs {
    private static TreeSet<String> ldxTokens = null;
    static TreeSet<String> dataSetTokens = null;

    public static synchronized void initializeLDXTagNames() {
        if (System.getProperty("ccstestrun") != null) {
            try {
                String string = System.getProperty("ccstestpath");
                String string2 = (string != null ? string : "") + "prod/templates/ccs/wsdl/";
                FileInputStream fileInputStream = new FileInputStream(string2 + "LayoutDataXMLV2.xsd");
                MaxOccurs.loadTags(fileInputStream);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        } else {
            InputStream inputStream = ConfigMgr.getInstance().getFileStream("/wsdl/LayoutDataXMLV2.xsd");
            MaxOccurs.loadTags(inputStream);
        }
    }

    public static synchronized void initializeLDXTagNames(InputStream inputStream) {
        MaxOccurs.loadTags(inputStream);
    }

    public static synchronized void initializeDatasetTagNames() {
        if (dataSetTokens == null) {
            dataSetTokens = new TreeSet();
            dataSetTokens.add("row");
            dataSetTokens.add("dataTable");
        }
    }

    public static boolean contains(String string, SourceType sourceType) {
        if (sourceType == SourceType.LDX) {
            if (ldxTokens == null) {
                MaxOccurs.initializeLDXTagNames();
            }
            return ldxTokens.contains(string);
        }
        if (sourceType == SourceType.DATASET) {
            if (dataSetTokens == null) {
                MaxOccurs.initializeDatasetTagNames();
            }
            return dataSetTokens.contains(string);
        }
        return false;
    }

    private static void loadTags(InputStream inputStream) {
        if (ldxTokens != null) {
            return;
        }
        ldxTokens = new TreeSet();
        Document document = MaxOccurs.load(inputStream);
        List list = document.selectNodes("//*[@maxOccurs='unbounded']");
        for (int i = 0; i < list.size(); ++i) {
            String string;
            Node node = (Node)list.get(i);
            String string2 = node.valueOf("@ref");
            if (string2.length() > 0 && (node = document.selectSingleNode("//*[@name='" + string2 + "']")) == null) continue;
            String string3 = node.getName();
            if (string3.equalsIgnoreCase("choice")) {
                List list2 = node.selectNodes("*");
                list.addAll(list2);
            }
            if ((string = node.valueOf("@name")).length() == 0) {
                string = node.valueOf("@ref");
            }
            if (string.length() <= 0 || ldxTokens.contains(string)) continue;
            ldxTokens.add(string);
        }
    }

    public static Document load(InputStream inputStream) {
        Document document = null;
        try {
            SAXReader sAXReader = new SAXReader();
            document = sAXReader.read(inputStream);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return document;
    }

    public static enum SourceType {
        LDX,
        DATASET;

    }
}

