/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.ccs.formats.raas;

import com.cognos.ccs.formats.CCSFormatter;
import com.cognos.ccs.formats.raas.NameGenerator;
import com.cognos.ccs.formats.raas.RaasElement;
import com.cognos.ccs.formats.raas.RaasHandler;
import com.cognos.ccs.formats.raas.RaasIgnoreFSM;
import com.cognos.ccs.fsm.LdxHandler;
import java.util.Stack;

public class RaasCrosstabFSM
extends RaasElement {
    int m_state = 100;
    Stack m_nameStack;
    Stack m_nameGeneratorStack;
    int m_currentItemTag;
    protected static final int CTAB_START = 100;
    protected static final int CTAB_CORNER = 200;
    protected static final int CTAB_CORNER_TXT = 201;
    protected static final int CTAB_DIMENSION = 300;
    protected static final int CTAB_DIMENSION_NAME_ITEM = 301;
    protected static final int CTAB_DIMENSION_NAME_ITEM_NOREF = 302;
    protected static final int CTAB_TABLE = 400;

    public RaasCrosstabFSM(LdxHandler ldxHandler) {
        super(ldxHandler);
    }

    @Override
    public void reset() {
        this.m_state = 100;
        this.m_id = null;
        this.m_nameStack = new Stack();
        this.m_nameGeneratorStack = new Stack();
        this.m_nameGeneratorStack.push(new NameGenerator());
        this.m_currentItemTag = -1;
    }

    @Override
    public void processEvent(int n) {
        switch (this.m_state) {
            case 100: {
                switch (n) {
                    case 1010: {
                        this.m_handler.RecordTextNodeOn();
                        break;
                    }
                    case 1011: {
                        if (this.m_id != null) break;
                        this.m_id = RaasHandler.encodeNameForTag(this.m_handler.getTextNode());
                        break;
                    }
                    case 2200: {
                        if (this.m_id != null) {
                            this.m_handler.writeOpen(this.m_id);
                            break;
                        }
                        this.m_handler.pushFsm(new RaasIgnoreFSM(this.m_handler, 1031));
                        break;
                    }
                    case 2400: {
                        this.m_handler.setEchoMode(true);
                        break;
                    }
                    case 2401: {
                        this.m_handler.setEchoMode(false);
                        break;
                    }
                    case 1400: {
                        this.m_state = 200;
                        break;
                    }
                    case 1040: 
                    case 1050: {
                        this.m_state = 300;
                        break;
                    }
                    case 1070: {
                        this.m_state = 400;
                        this.m_handler.setEchoMode(true);
                        break;
                    }
                    case 1031: {
                        this.m_handler.skipLastElement();
                        this.m_handler.setEchoMode(false);
                        this.m_handler.writeClose(this.m_id);
                        this.m_handler.popFsm();
                    }
                }
                break;
            }
            case 200: {
                switch (n) {
                    case 2500: {
                        this.m_state = 201;
                        break;
                    }
                    case 1401: {
                        this.m_state = 100;
                    }
                }
                break;
            }
            case 201: {
                switch (n) {
                    case 2200: {
                        this.m_handler.writeOpen("corner");
                        this.m_handler.setEchoMode(true);
                        break;
                    }
                    case 2501: {
                        this.m_handler.writeClose("corner");
                        this.m_handler.skipLastElement();
                        this.m_handler.setEchoMode(false);
                        this.m_state = 200;
                    }
                }
                break;
            }
            case 300: {
                switch (n) {
                    case 1100: {
                        this.m_handler.startBuffer();
                        break;
                    }
                    case 1020: 
                    case 1030: 
                    case 2500: 
                    case 2600: 
                    case 2700: 
                    case 3900: 
                    case 5000: 
                    case 5006: 
                    case 7000: {
                        this.m_currentItemTag = n;
                        this.m_state = 301;
                        break;
                    }
                    case 1090: {
                        this.m_handler.setEchoMode(false);
                        this.m_handler.skipLastElement();
                        this.m_nameGeneratorStack.push(new NameGenerator());
                        break;
                    }
                    case 1091: {
                        this.m_handler.setEchoMode(false);
                        this.m_handler.skipLastElement();
                        this.m_handler.writeClose((String)this.m_nameStack.pop());
                        this.m_nameGeneratorStack.pop();
                        break;
                    }
                    case 1200: {
                        this.m_handler.setEchoMode(true);
                        break;
                    }
                    case 1041: 
                    case 1051: {
                        this.m_handler.setEchoMode(false);
                        this.m_handler.skipLastElement();
                        this.m_handler.writeClose((String)this.m_nameStack.pop());
                        this.m_state = 100;
                    }
                }
                break;
            }
            case 301: {
                switch (n) {
                    case 2200: {
                        this.m_handler.RecordTextNodeOn();
                        break;
                    }
                    case 2201: {
                        String string = this.m_handler.getTextNode();
                        this.m_handler.RecordTextNodeOff();
                        String string2 = this.m_handler.lookupDataItemByRef(string);
                        String string3 = "";
                        if (string2 != null) {
                            string3 = RaasHandler.encodeNameForTag(this.m_handler.lookupDataItemByRef(string));
                            this.m_nameStack.push(string3);
                            this.m_handler.writeOpen(string3);
                            break;
                        }
                        this.m_state = 302;
                    }
                }
                if (n != this.m_currentItemTag + 1) break;
                this.m_handler.writeBufferToOutput();
                this.m_handler.stopBuffer();
                this.m_handler.setEchoMode(true);
                this.m_state = 300;
                break;
            }
            case 302: {
                switch (n) {
                    case 1080: {
                        this.m_handler.RecordTextNodeOn();
                        break;
                    }
                    case 1081: {
                        String string = CCSFormatter.encodeNameForTag(this.m_handler.getTextNode());
                        this.m_handler.RecordTextNodeOff();
                        if (string == null) {
                            NameGenerator nameGenerator = (NameGenerator)this.m_nameGeneratorStack.peek();
                            string = nameGenerator.getUniqueName(this.m_currentItemTag);
                            break;
                        }
                        this.m_nameStack.push(string);
                        this.m_handler.writeOpen(string);
                    }
                }
                if (n != this.m_currentItemTag + 1) break;
                this.m_handler.writeBufferToOutput();
                this.m_handler.stopBuffer();
                this.m_handler.setEchoMode(true);
                this.m_state = 300;
                break;
            }
            case 400: {
                switch (n) {
                    case 1071: {
                        this.m_handler.setEchoMode(false);
                        this.m_state = 100;
                    }
                }
            }
        }
    }
}

