/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.ccs.formats.raas;

import com.cognos.ccs.exceptions.CCSGeneralException;
import com.cognos.ccs.formats.CCSFormatter;
import com.cognos.ccs.formats.raas.RaasObsFSM;
import com.cognos.ccs.service.CCSLogger;
import com.cognos.ccs.utility.SAXParserFactoryWrapper;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class RaasHandler
extends CCSFormatter {
    private HashMap m_dataitemHash;
    BufferedWriter buffer;
    ByteArrayOutputStream bufferStream;
    boolean bufferSkipLast;

    public RaasHandler() {
        RaasObsFSM raasObsFSM = new RaasObsFSM(this);
        this.m_dataitemHash = new HashMap();
        this.SetFsm(raasObsFSM);
        this.buffer = null;
        this.bufferSkipLast = false;
        this.setReportName("report");
    }

    public String nameElement(String string) {
        String string2 = string.substring(string.lastIndexOf(47) + 1);
        int n = string2.lastIndexOf(91);
        if (n > -1) {
            string2 = string2.substring(n + 1, string2.length() - 2);
        }
        return string2;
    }

    @Override
    public void startDocument() throws SAXException {
        super.startDocument();
    }

    @Override
    public void endDocument() throws SAXException {
        super.endDocument();
    }

    public void addReftoHash(String string, String string2) {
        this.m_dataitemHash.put(string, string2);
    }

    public String lookupDataItemByRef(String string) {
        return (String)this.m_dataitemHash.get(string);
    }

    @Override
    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        super.startElement(string, string2, string3, attributes);
        if (this.buffer != null && !this.bufferSkipLast) {
            try {
                this.buffer.write("<");
                this.buffer.write(string2);
                this.buffer.write(">");
            }
            catch (IOException iOException) {
                CCSGeneralException cCSGeneralException = new CCSGeneralException("PARSE_STREAM_ERROR", iOException, 500);
                CCSLogger.getInstance().logRuntimeErrorMessage(cCSGeneralException.getServerLocaleMessage(), null, null, null, cCSGeneralException.getSourceTrace());
            }
        }
        this.bufferSkipLast = false;
    }

    @Override
    public void characters(char[] cArray, int n, int n2) throws SAXException {
        super.characters(cArray, n, n2);
        try {
            if (this.buffer != null) {
                this.buffer.write(this.escapeIfNeeded(cArray, n, n2));
            }
        }
        catch (IOException iOException) {
            CCSGeneralException cCSGeneralException = new CCSGeneralException("PARSE_STREAM_ERROR", iOException, 500);
            CCSLogger.getInstance().logRuntimeErrorMessage(cCSGeneralException.getServerLocaleMessage(), null, null, null, cCSGeneralException.getSourceTrace());
        }
    }

    @Override
    public void endElement(String string, String string2, String string3) throws SAXException {
        super.endElement(string, string2, string3);
        try {
            if (this.buffer != null && !this.bufferSkipLast) {
                this.buffer.write("</");
                this.buffer.write(string2);
                this.buffer.write(">");
            }
            this.bufferSkipLast = false;
        }
        catch (IOException iOException) {
            CCSGeneralException cCSGeneralException = new CCSGeneralException("PARSE_STREAM_ERROR", iOException, 500);
            CCSLogger.getInstance().logRuntimeErrorMessage(cCSGeneralException.getServerLocaleMessage(), null, null, null, cCSGeneralException.getSourceTrace());
        }
    }

    public void startBuffer() {
        try {
            this.bufferStream = new ByteArrayOutputStream();
            this.buffer = new BufferedWriter(new OutputStreamWriter((OutputStream)this.bufferStream, "UTF-8"));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            unsupportedEncodingException.printStackTrace();
        }
    }

    public void writeBufferToOutput() {
        try {
            this.buffer.flush();
            this.m_OutputWriter.write(this.bufferStream.toString("UTF-8"));
            this.stopBuffer();
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            unsupportedEncodingException.printStackTrace();
        }
        catch (IOException iOException) {
            CCSGeneralException cCSGeneralException = new CCSGeneralException("PARSE_STREAM_ERROR", iOException, 500);
            CCSLogger.getInstance().logRuntimeErrorMessage(cCSGeneralException.getServerLocaleMessage(), null, null, null, cCSGeneralException.getSourceTrace());
        }
    }

    public void writeFormattedBufferOutput(RaasHandler raasHandler) {
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            raasHandler.setOutStream(byteArrayOutputStream);
            this.buffer.flush();
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(this.bufferStream.toByteArray());
            SAXParser sAXParser = SAXParserFactoryWrapper.getParser();
            sAXParser.parse(new InputSource(byteArrayInputStream), (DefaultHandler)raasHandler);
            this.m_OutputWriter.write(byteArrayOutputStream.toString("UTF-8"));
            this.stopBuffer();
        }
        catch (ParserConfigurationException parserConfigurationException) {
            CCSGeneralException cCSGeneralException = new CCSGeneralException("PARSE_STREAM_ERROR", parserConfigurationException, 500);
            CCSLogger.getInstance().logRuntimeErrorMessage(cCSGeneralException.getServerLocaleMessage(), null, null, null, cCSGeneralException.getSourceTrace());
        }
        catch (IOException iOException) {
            CCSGeneralException cCSGeneralException = new CCSGeneralException("PARSE_STREAM_ERROR", iOException, 500);
            CCSLogger.getInstance().logRuntimeErrorMessage(cCSGeneralException.getServerLocaleMessage(), null, null, null, cCSGeneralException.getSourceTrace());
        }
        catch (SAXException sAXException) {
            CCSGeneralException cCSGeneralException = new CCSGeneralException("PARSE_STREAM_ERROR", sAXException, 500);
            CCSLogger.getInstance().logRuntimeErrorMessage(cCSGeneralException.getServerLocaleMessage(), null, null, null, cCSGeneralException.getSourceTrace());
        }
    }

    public void stopBuffer() {
        try {
            if (this.buffer != null) {
                this.buffer.close();
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        this.buffer = null;
    }

    public void bufferSkipLast() {
        this.bufferSkipLast = true;
    }

    public void writeToBuffer(String string) {
        try {
            this.buffer.write(string);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public String getGeneratedNamespace() {
        String string = CCSFormatter.encodeName(this.getReportName());
        return "http://developer.cognos.com/schemas/raas/" + string;
    }
}

