/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.ccs.formats.raas;

import com.cognos.ccs.formats.raas.ColumnMap;
import com.cognos.ccs.formats.raas.NameGenerator;
import com.cognos.ccs.formats.raas.RaasElement;
import com.cognos.ccs.formats.raas.RaasHandler;
import com.cognos.ccs.formats.raas.RaasIgnoreFSM;
import com.cognos.ccs.formats.raas.RaasObsFSM;
import com.cognos.ccs.fsm.LdxHandler;
import java.util.Stack;
import java.util.Vector;

public class RaasListFSM
extends RaasElement {
    int m_state = 100;
    protected static final int LST_START = 100;
    protected static final int LST_GETCOLTITLES = 200;
    protected static final int LST_INGROUPS = 300;
    protected static final int LST_HF = 400;
    protected static final int LST_ROW = 500;
    protected static final int LST_CELL = 600;
    protected static final int LST_CELL_FIRST_PART = 800;
    protected static final int LST_CELL_ITEM = 900;
    protected static final int LST_COL_TITLE_TXT = 1000;
    protected static final int LST_IN_FIRST_ITEM = 1100;
    private Vector m_coltitles = new Vector();
    private Stack<String> m_groupDIs = new Stack();
    private String m_text = null;
    private int m_grpDepth = 0;
    private boolean m_firstRowDone = false;
    private int m_totalGroups;
    private boolean m_bInHF = false;
    private int m_currentHFRow = 1;
    private int m_colSpan = 1;
    private int m_rowSpan = 1;
    private int m_cellPos = 0;
    NameGenerator m_cellNameGenerator;
    NameGenerator m_collNameGenerator = new NameGenerator();
    private String m_firstCellName;
    private int m_startEvent;
    private ColumnMap m_columnMap;

    public RaasListFSM(LdxHandler ldxHandler) {
        super(ldxHandler);
    }

    @Override
    public void reset() {
        this.m_state = 100;
        this.m_coltitles = new Vector();
        this.m_text = null;
        this.m_id = null;
        this.m_grpDepth = 0;
        this.m_firstRowDone = false;
        this.m_totalGroups = 0;
        this.m_columnMap = new ColumnMap();
        this.m_currentHFRow = 1;
        this.m_cellNameGenerator = new NameGenerator();
        this.m_firstCellName = null;
        this.m_startEvent = -1;
    }

    @Override
    public void processEvent(int n) {
        switch (this.m_state) {
            case 100: {
                switch (n) {
                    case 1010: {
                        this.m_handler.RecordTextNodeOn();
                        break;
                    }
                    case 1011: {
                        if (this.m_id != null) break;
                        this.m_id = RaasHandler.encodeNameForTag(this.m_handler.getTextNode());
                        break;
                    }
                    case 1700: {
                        this.m_state = 200;
                        this.m_handler.writeOpen("columnTitle");
                        break;
                    }
                    case 1800: {
                        this.m_state = 300;
                        break;
                    }
                    case 2400: {
                        if (this.m_id == null) {
                            this.m_handler.pushFsm(new RaasIgnoreFSM(this.m_handler, 1021));
                            break;
                        }
                        this.m_handler.writeOpen(this.m_id);
                        this.m_handler.setEchoMode(true);
                        break;
                    }
                    case 2401: {
                        this.m_handler.setEchoMode(false);
                        break;
                    }
                    case 1021: {
                        this.m_handler.writeClose(this.m_id);
                        this.m_handler.popFsm();
                    }
                }
                break;
            }
            case 200: {
                switch (n) {
                    case 2200: {
                        this.m_handler.setEchoMode(true);
                        break;
                    }
                    case 2500: {
                        this.m_state = 1000;
                        break;
                    }
                    case 1701: {
                        if (this.m_text == null) {
                            this.m_text = this.m_collNameGenerator.getNextName("Column");
                        }
                        this.m_coltitles.add(RaasHandler.encodeNameForTag(this.m_text));
                        this.m_text = null;
                        this.m_state = 100;
                        this.m_handler.setEchoMode(false);
                        this.m_handler.skipLastElement();
                        this.m_handler.writeClose("columnTitle");
                    }
                }
                break;
            }
            case 1000: {
                switch (n) {
                    case 2200: {
                        this.m_handler.setEchoMode(true);
                        break;
                    }
                    case 1080: {
                        this.m_handler.RecordTextNodeOn();
                        break;
                    }
                    case 1081: {
                        if (this.m_text != null) break;
                        this.m_text = this.m_handler.getTextNode();
                        break;
                    }
                    case 2501: {
                        this.m_handler.skipLastElement();
                        this.m_state = 200;
                    }
                }
                break;
            }
            case 300: {
                switch (n) {
                    case 1900: {
                        if (!this.m_firstRowDone) {
                            ++this.m_totalGroups;
                        }
                        ++this.m_grpDepth;
                        break;
                    }
                    case 1901: {
                        this.m_handler.writeClose(this.m_groupDIs.pop());
                        break;
                    }
                    case 3600: {
                        this.m_handler.RecordTextNodeOn();
                        break;
                    }
                    case 3601: {
                        String string = RaasHandler.encodeNameForTag(this.m_handler.getTextNode());
                        this.m_handler.RecordTextNodeOff();
                        this.m_handler.writeOpen(string);
                        this.m_groupDIs.push(string);
                        break;
                    }
                    case 3700: {
                        this.m_handler.RecordTextNodeOn();
                        break;
                    }
                    case 3701: {
                        String string = this.m_handler.getTextNode();
                        this.m_handler.RecordTextNodeOff();
                        if (string == null) break;
                        this.m_handler.writeElement(this.m_groupDIs.peek(), string);
                        break;
                    }
                    case 2000: {
                        this.m_handler.writeOpen("footer");
                        this.m_state = 400;
                        break;
                    }
                    case 2100: {
                        this.m_handler.writeOpen("header");
                        this.m_state = 400;
                        break;
                    }
                    case 1040: {
                        this.m_columnMap.nextRow();
                        this.m_state = 800;
                        this.m_handler.writeOpen("row");
                        break;
                    }
                    case 1801: {
                        this.m_state = 100;
                    }
                }
                break;
            }
            case 500: {
                switch (n) {
                    case 1300: {
                        this.m_state = 800;
                        break;
                    }
                    case 1301: {
                        break;
                    }
                    case 1041: {
                        this.m_handler.writeClose("row");
                        this.m_state = 300;
                        this.m_firstRowDone = true;
                    }
                }
                break;
            }
            case 400: {
                switch (n) {
                    case 1040: {
                        this.m_columnMap.nextRow();
                        this.m_handler.writeOpen("row" + this.m_currentHFRow);
                        break;
                    }
                    case 1041: {
                        this.m_handler.writeClose("row" + this.m_currentHFRow);
                        ++this.m_currentHFRow;
                        break;
                    }
                    case 1300: {
                        this.m_bInHF = true;
                        this.m_state = 800;
                        break;
                    }
                    case 2001: {
                        this.m_bInHF = false;
                        this.m_handler.writeClose("footer");
                        this.m_state = 300;
                        this.m_currentHFRow = 1;
                        break;
                    }
                    case 2101: {
                        this.m_bInHF = false;
                        this.m_handler.writeClose("header");
                        this.m_state = 300;
                        this.m_currentHFRow = 1;
                    }
                }
                break;
            }
            case 800: {
                switch (n) {
                    case 1500: {
                        this.m_handler.RecordTextNodeOn();
                        break;
                    }
                    case 1501: {
                        this.m_colSpan = Integer.parseInt(this.m_handler.getTextNode());
                        break;
                    }
                    case 1600: {
                        this.m_handler.RecordTextNodeOn();
                        break;
                    }
                    case 1601: {
                        this.m_rowSpan = Integer.parseInt(this.m_handler.getTextNode());
                        break;
                    }
                    case 2300: {
                        this.m_handler.bufferSkipLast();
                        this.m_state = 900;
                        break;
                    }
                    case 2301: {
                        ++this.m_cellPos;
                        break;
                    }
                    case 1301: {
                        String string = this.getColumnTitle(this.m_columnMap.getCurrentColumn());
                        if (this.m_cellPos == 1) {
                            RaasHandler raasHandler = new RaasHandler();
                            raasHandler.SetFsm(new RaasObsFSM(raasHandler, -1, string));
                            this.m_handler.writeFormattedBufferOutput(raasHandler);
                        } else if (this.m_cellPos > 1) {
                            this.m_handler.writeClose(string);
                        }
                        this.m_cellNameGenerator = new NameGenerator();
                        this.m_cellPos = 0;
                        this.m_columnMap.addCell(this.m_colSpan, this.m_rowSpan);
                        this.m_colSpan = 1;
                        this.m_rowSpan = 1;
                        this.m_state = this.m_bInHF ? 400 : 500;
                    }
                }
                break;
            }
            case 900: {
                this.m_state = 800;
                int n2 = this.m_columnMap.getCurrentColumn();
                String string = this.getColumnTitle(n2);
                String string2 = this.m_cellNameGenerator.getUniqueName(n);
                if (this.m_cellPos == 1) {
                    this.m_handler.writeOpen(string);
                    RaasHandler raasHandler = new RaasHandler();
                    raasHandler.SetFsm(new RaasObsFSM(raasHandler, -1, this.m_firstCellName));
                    this.m_handler.writeFormattedBufferOutput(raasHandler);
                    this.m_handler.pushFsm(new RaasObsFSM(this.m_handler, 2301, string2));
                    this.m_handler.injectEvent(n);
                    break;
                }
                if (this.m_cellPos >= 1) {
                    this.m_handler.pushFsm(new RaasObsFSM(this.m_handler, 2301, string2));
                    this.m_handler.injectEvent(n);
                    break;
                }
                this.m_handler.startBuffer();
                this.m_handler.writeToBuffer("<item>");
                this.m_firstCellName = string2;
                this.m_startEvent = n;
                this.m_state = 1100;
                break;
            }
            case 1100: {
                if (n != this.m_startEvent + 1) break;
                this.m_startEvent = -1;
                this.m_state = 800;
            }
        }
    }

    private String getColumnTitle(int n) {
        String string = null;
        if (this.m_coltitles.size() > n) {
            string = (String)this.m_coltitles.get(n);
        }
        if (null == string) {
            for (int i = this.m_coltitles.size() - 1; i < n; ++i) {
                string = this.m_collNameGenerator.getNextName("Column");
                this.m_coltitles.add(string);
            }
        }
        return string;
    }
}

