/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.ccs.fsm;

import com.cognos.ccs.exceptions.CCSGeneralException;
import com.cognos.ccs.fsm.NullFSM;
import com.cognos.ccs.service.CCSLogger;
import com.cognos.ccs.service.Cognos8Connector;
import com.cognos.ccs.service.Conversation;
import com.cognos.ccs.utility.Utilities;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PipedOutputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayDeque;
import java.util.Collections;
import java.util.Deque;
import java.util.HashMap;
import java.util.Map;
import java.util.Stack;
import java.util.Vector;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class LdxHandler
extends DefaultHandler {
    public static final String OPEN_TAG = "<";
    public static final String CLOSE_TAG = ">";
    public static final String OPEN_ETAG = "</";
    public static final String NS = " xmlns=\"http://developer.cognos.com/schemas/rds/contentmodel/1\"";
    public static final int NULL_TOKEN = -1;
    public static final int TOKEN_NOTFOUND = -1;
    public static final int TOKEN_aaa_O = 1000;
    public static final int TOKEN_aaa_C = 1001;
    public static final int TOKEN_ID_O = 1010;
    public static final int TOKEN_ID_C = 1011;
    public static final int TOKEN_LST_O = 1020;
    public static final int TOKEN_LST_C = 1021;
    public static final int TOKEN_CTAB_O = 1030;
    public static final int TOKEN_CTAB_C = 1031;
    public static final int TOKEN_ROW_O = 1040;
    public static final int TOKEN_ROW_C = 1041;
    public static final int TOKEN_COLUMN_O = 1050;
    public static final int TOKEN_COLUMN_C = 1051;
    public static final int TOKEN_MEASURE_O = 1060;
    public static final int TOKEN_MEASURE_C = 1061;
    public static final int TOKEN_TABLE_O = 1070;
    public static final int TOKEN_TABLE_C = 1071;
    public static final int TOKEN_VAL_O = 1080;
    public static final int TOKEN_VAL_C = 1081;
    public static final int TOKEN_VALERRORSTATE_O = 1082;
    public static final int TOKEN_VALERRORSTATE_C = 1083;
    public static final int TOKEN_VALTYP_O = 1086;
    public static final int TOKEN_VALTYP_C = 1087;
    public static final int TOKEN_NDIM_O = 1090;
    public static final int TOKEN_NDIM_C = 1091;
    public static final int TOKEN_NAME_O = 1100;
    public static final int TOKEN_NAME_C = 1101;
    public static final int TOKEN_START_O = 1200;
    public static final int TOKEN_START_C = 1201;
    public static final int TOKEN_CELL_O = 1300;
    public static final int TOKEN_CELL_C = 1301;
    public static final int TOKEN_CELL_ISFIRSTCELL_O = 1310;
    public static final int TOKEN_CELL_ISFIRSTCELL_C = 1311;
    public static final int TOKEN_CELL_HDR_O = 1320;
    public static final int TOKEN_CELL_HDR_C = 1321;
    public static final int TOKEN_CELL_HDRS_O = 1330;
    public static final int TOKEN_CELL_HDRS_C = 1331;
    public static final int TOKEN_CORNER_O = 1400;
    public static final int TOKEN_CORNER_C = 1401;
    public static final int TOKEN_CSPAN_O = 1500;
    public static final int TOKEN_CSPAN_C = 1501;
    public static final int TOKEN_RSPAN_O = 1600;
    public static final int TOKEN_RSPAN_C = 1601;
    public static final int TOKEN_COLTITLE_O = 1700;
    public static final int TOKEN_COLTITLE_C = 1701;
    public static final int TOKEN_GROUP_O = 1800;
    public static final int TOKEN_GROUP_C = 1801;
    public static final int TOKEN_GRP_O = 1900;
    public static final int TOKEN_GRP_C = 1901;
    public static final int TOKEN_FOOTER_O = 2000;
    public static final int TOKEN_FOOTER_C = 2001;
    public static final int TOKEN_HEADER_O = 2100;
    public static final int TOKEN_HEADER_C = 2101;
    public static final int TOKEN_REF_O = 2200;
    public static final int TOKEN_REF_C = 2201;
    public static final int TOKEN_ITEM_O = 2300;
    public static final int TOKEN_ITEM_C = 2301;
    public static final int TOKEN_STYLE_O = 2400;
    public static final int TOKEN_STYLE_C = 2401;
    public static final int TOKEN_TXT_O = 2500;
    public static final int TOKEN_TXT_C = 2501;
    public static final int TOKEN_IMG_O = 2600;
    public static final int TOKEN_IMG_C = 2601;
    public static final int TOKEN_CHT_O = 2700;
    public static final int TOKEN_CHT_C = 2701;
    public static final int TOKEN_EM_O = 2750;
    public static final int TOKEN_EM_C = 2751;
    public static final int TOKEN_STRONG_O = 2752;
    public static final int TOKEN_STRONG_C = 2753;
    public static final int TOKEN_H1_O = 2754;
    public static final int TOKEN_H1_C = 2755;
    public static final int TOKEN_H2_O = 2756;
    public static final int TOKEN_H2_C = 2757;
    public static final int TOKEN_H3_O = 2758;
    public static final int TOKEN_H3_C = 2759;
    public static final int TOKEN_H4_O = 2760;
    public static final int TOKEN_H4_C = 2761;
    public static final int TOKEN_H5_O = 2762;
    public static final int TOKEN_H5_C = 2763;
    public static final int TOKEN_H6_O = 2764;
    public static final int TOKEN_H6_C = 2765;
    public static final int TOKEN_PTXTBOX_O = 2770;
    public static final int TOKEN_PTXTBOX_C = 2771;
    public static final int TOKEN_PVALUE_O = 2772;
    public static final int TOKEN_PVALUE_C = 2773;
    public static final int TOKEN_PDATE_O = 2774;
    public static final int TOKEN_PDATE_C = 2775;
    public static final int TOKEN_PTIME_O = 2776;
    public static final int TOKEN_PTIME_C = 2777;
    public static final int TOKEN_PDTIME_O = 2778;
    public static final int TOKEN_PDTIME_C = 2779;
    public static final int TOKEN_PINTRVL_O = 2780;
    public static final int TOKEN_PINTRVL_C = 2781;
    public static final int TOKEN_PDSRC_O = 2782;
    public static final int TOKEN_PDSRC_C = 2783;
    public static final int TOKEN_PSRCH_O = 2784;
    public static final int TOKEN_PSRCH_C = 2785;
    public static final int TOKEN_PTREE_O = 2786;
    public static final int TOKEN_PTREE_C = 2787;
    public static final int TOKEN_PBTN_O = 2788;
    public static final int TOKEN_PBTN_C = 2789;
    public static final int TOKEN_PAGE_O = 2800;
    public static final int TOKEN_PAGE_C = 2801;
    public static final int TOKEN_PAGES_O = 2802;
    public static final int TOKEN_PAGES_C = 2803;
    public static final int TOKEN_BOOKLET_O = 2812;
    public static final int TOKEN_BOOKLET_C = 2813;
    public static final int TOKEN_BODY_O = 2900;
    public static final int TOKEN_BODY_C = 2901;
    public static final int TOKEN_STYLEGROUP_O = 3000;
    public static final int TOKEN_STYLEGROUP_C = 3001;
    public static final int TOKEN_DISPLAY_O = 3003;
    public static final int TOKEN_DISPLAY_C = 3004;
    public static final int TOKEN_HIDDEN_O = 3005;
    public static final int TOKEN_HIDDEN_C = 3006;
    public static final int TOKEN_VERSBASE_O = 3100;
    public static final int TOKEN_VERSBASE_C = 3101;
    public static final int TOKEN_URL_O = 3200;
    public static final int TOKEN_URL_C = 3201;
    public static final int TOKEN_DOCUMENT_O = 3300;
    public static final int TOKEN_DOCUMENT_C = 3301;
    public static final int TOKEN_DOCUMENT_LANG_O = 3310;
    public static final int TOKEN_DOCUMENT_LANG_C = 3311;
    public static final int TOKEN_FILTERRESULTSET_O = 3400;
    public static final int TOKEN_FILTERRESULTSET_C = 3401;
    public static final int TOKEN_FILTERRESULT_O = 3402;
    public static final int TOKEN_FILTERRESULT_C = 3403;
    public static final int TOKEN_LOCATIONREFERENCE_O = 3500;
    public static final int TOKEN_LOCATIONREFERENCE_C = 3501;
    public static final int TOKEN_DI_O = 3600;
    public static final int TOKEN_DI_C = 3601;
    public static final int TOKEN_DV_O = 3700;
    public static final int TOKEN_DV_C = 3701;
    public static final int TOKEN_FMTVAL_O = 3800;
    public static final int TOKEN_FMTVAL_C = 3801;
    public static final int TOKEN_HTML_O = 3900;
    public static final int TOKEN_HTML_C = 3901;
    public static final int TOKEN_BMRK_O = 4002;
    public static final int TOKEN_BMRK_C = 4003;
    public static final int TOKEN_LBL_O = 4006;
    public static final int TOKEN_LBL_C = 4007;
    public static final int TOKEN_RPT_O = 5000;
    public static final int TOKEN_RPT_C = 5001;
    public static final int TOKEN_RPTTBL_O = 5006;
    public static final int TOKEN_RPTTBL_C = 5007;
    public static final int TOKEN_TOC_O = 6000;
    public static final int TOKEN_TOC_C = 6001;
    public static final int TOKEN_TOC_BMRK_O = 6002;
    public static final int TOKEN_TOC_BMRK_C = 6003;
    public static final int TOKEN_TOC_ENTRY_O = 6006;
    public static final int TOKEN_TOC_ENTRY_C = 6007;
    public static final int TOKEN_RTXT_O = 7000;
    public static final int TOKEN_RTXT_C = 7001;
    public static final int TOKEN_RTXT_SPAN_O = 7002;
    public static final int TOKEN_RTXT_SPAN_C = 7003;
    public static final int TOKEN_RTXT_DIV_O = 7004;
    public static final int TOKEN_RTXT_DIV_C = 7005;
    public static final int TOKEN_RTLST_ORDER_O = 7006;
    public static final int TOKEN_RTLST_ORDER_C = 7007;
    public static final int TOKEN_RTLST_ITEM_O = 7008;
    public static final int TOKEN_RTLST_ITEM_C = 7009;
    public static final int TOKEN_RTLST_O = 7010;
    public static final int TOKEN_RTLST_C = 7011;
    public static final int TOKEN_RTTBL_ROW_O = 7014;
    public static final int TOKEN_RTTBL_ROW_C = 7015;
    public static final int TOKEN_RTTBL_CELL_O = 7016;
    public static final int TOKEN_RTTBL_CELL_C = 7017;
    public static final int TOKEN_RTTBL_HEADER_O = 7018;
    public static final int TOKEN_RTTBL_HEADER_C = 7019;
    public static final int TOKEN_CTX_O = 8000;
    public static final int TOKEN_CTX_C = 8001;
    public static final int TOKEN_PAGEGROUP_O = 9000;
    public static final int TOKEN_PAGEGROUP_C = 9001;
    public static final int TOKEN_DRILLS_O = 10000;
    public static final int TOKEN_DRILLS_C = 10001;
    public static final int TOKEN_DEPTH_O = 11000;
    public static final int TOKEN_DEPTH_C = 11001;
    public static final int TOKEN_HLINK_O = 12000;
    public static final int TOKEN_HLINK_C = 12001;
    public static final int TOKEN_LCR_O = 13000;
    public static final int TOKEN_LCR_C = 13001;
    public static final int TOKEN_DRILLDEFS_O = 14000;
    public static final int TOKEN_DRILLDEFS_C = 14001;
    public static final int TOKEN_CANDRILLUP_O = 15000;
    public static final int TOKEN_CANDRILLUP_C = 15001;
    public static final int TOKEN_CANDRILLDN_O = 15002;
    public static final int TOKEN_CANDRILLDN_C = 15003;
    public static final int TOKEN_DRILL_TARGETPATH_O = 15006;
    public static final int TOKEN_DRILL_TARGETPATH_C = 15007;
    public static final int TOKEN_LAYOUTTABLE_O = 16000;
    public static final int TOKEN_LAYOUTTABLE_C = 16001;
    public static final int TOKEN_LAYOUTTABLECELL_O = 16100;
    public static final int TOKEN_LAYOUTTABLECELL_C = 16101;
    public static final int TOKEN_LAYOUTTABLEROW_O = 16200;
    public static final int TOKEN_LAYOUTTABLEROW_C = 16201;
    public static final int TOKEN_ITEMS_O = 16300;
    public static final int TOKEN_ITEMS_C = 16301;
    public static final int TOKEN_BLOCK_O = 16400;
    public static final int TOKEN_BLOCK_C = 16401;
    public static final int TOKEN_SIZE_O = 16500;
    public static final int TOKEN_SIZE_C = 16501;
    public static final int TOKEN_INDENT_O = 16600;
    public static final int TOKEN_INDENT_C = 16601;
    public static final int TOKEN_TARGET_O = 16700;
    public static final int TOKEN_TARGET_C = 16701;
    public static final int TOKEN_HRLAYOUT_O = 16800;
    public static final int TOKEN_HRLAYOUT_C = 16801;
    public static final int TOKEN_HRSIZE_O = 16900;
    public static final int TOKEN_HRSIZE_C = 16901;
    public static final int TOKEN_VRSIZE_O = 17000;
    public static final int TOKEN_VRSIZE_C = 17001;
    public static final int TOKEN_CONTENTS_O = 17100;
    public static final int TOKEN_CONTENTS_C = 17101;
    public static final int TOKEN_ANNURL_O = 17200;
    public static final int TOKEN_ANNURL_C = 17201;
    public static final int TOKEN_REPORTPATH_O = 17300;
    public static final int TOKEN_REPORTPATH_C = 17301;
    public static final int TOKEN_VALIGN_O = 17400;
    public static final int TOKEN_VALIGN_C = 17401;
    public static final int TOKEN_DRILLACTION_O = 17500;
    public static final int TOKEN_DRILLACTION_C = 17501;
    public static final int TOKEN_DIRECTION_O = 17600;
    public static final int TOKEN_DIRECTION_C = 17601;
    public static final int TOKEN_ISCMMMAP_O = 17700;
    public static final int TOKEN_ISCMMMAP_C = 17701;
    public static final int TOKEN_WIDGET_O = 17800;
    public static final int TOKEN_WIDGET_C = 17801;
    public static final int TOKEN_WIDGETURI_O = 17900;
    public static final int TOKEN_WIDGETURI_C = 17901;
    public static final int TOKEN_WIDGET_TITLE_O = 17912;
    public static final int TOKEN_WIDGET_TITLE_C = 17913;
    public static final int TOKEN_STOREID_O = 18000;
    public static final int TOKEN_STOREID_C = 18001;
    public static final int TOKEN_SECONDARY_OP_O = 19010;
    public static final int TOKEN_SECONDARY_OP_C = 19011;
    public static final int TOKEN_FMTPATRN_O = 20000;
    public static final int TOKEN_FMTPATRN_C = 20001;
    public static final int TOKEN_EXCLPATRN_O = 21000;
    public static final int TOKEN_EXCLPATRN_C = 21001;
    public static final int TOKEN_FMTLOC_O = 22000;
    public static final int TOKEN_FMTLOC_C = 22001;
    public static final int TOKEN_FMTSCALE_O = 23000;
    public static final int TOKEN_FMTSCALE_C = 23001;
    public static final int TOKEN_X_O = 110010;
    public static final int TOKEN_X_C = 110011;
    public static final int TOKEN_Y_O = 110012;
    public static final int TOKEN_Y_C = 110013;
    public static final int TOKEN_TYPE_O = 110004;
    public static final int TOKEN_TYPE_C = 110005;
    public static final int TOKEN_VALUE_O = 110028;
    public static final int TOKEN_VALUE_C = 110029;
    public static final int TOKEN_DRILLREF_O = 110016;
    public static final int TOKEN_DRILLREF_C = 110017;
    public static final int TOKEN_AREA_O = 110002;
    public static final int TOKEN_AREA_C = 110003;
    public static final int TOKEN_ACTIONURL_O = 130100;
    public static final int TOKEN_ACTIONURL_C = 130101;
    public static final int TOKEN_DRILL_O = 110018;
    public static final int TOKEN_DRILL_C = 110019;
    public static final int TOKEN_SNGL_O = 120008;
    public static final int TOKEN_SNGL_C = 120009;
    public static final int TOKEN_URLPARAMETERS_O = 130102;
    public static final int TOKEN_URLPARAMETERS_C = 130103;
    public static final int TOKEN_SCHEMA_VERSION_O = 140000;
    public static final int TOKEN_SCHEMA_VERSION_C = 140001;
    public static final int TOKEN_MUN_O = 150000;
    public static final int TOKEN_MUN_C = 150001;
    public static final int TOKEN_ISFIRSTELEMENT_O = 150050;
    public static final int TOKEN_ISFIRSTELEMENT_C = 150051;
    public static final int TOKEN_ISLAYOUTTABLE_O = 150052;
    public static final int TOKEN_ISLAYOUTTABLE_C = 150053;
    public static final int TOKEN_LABELFOR_O = 150060;
    public static final int TOKEN_LABELFOR_C = 150061;
    public static final int TOKEN_CNAME_O = 150062;
    public static final int TOKEN_CNAME_C = 150063;
    public static final int TOKEN_EXTENSION_O = 150066;
    public static final int TOKEN_EXTENSION_C = 150067;
    public static final int TOKEN_CHART_DETAILS_CGSWIDGET_O = 150100;
    public static final int TOKEN_CHART_DETAILS_CGSWIDGET_C = 150101;
    public static final int TOKEN_CHART_DETAILS_CGSPROPCANVAS_O = 150110;
    public static final int TOKEN_CHART_DETAILS_CGSPROPCANVAS_C = 150111;
    public static final int TOKEN_CHART_DETAILS_CGSDATA_O = 150120;
    public static final int TOKEN_CHART_DETAILS_CGSDATA_C = 150121;
    public static final int TOKEN_CHART_DETAILS_CGSDATAINFO_O = 150130;
    public static final int TOKEN_CHART_DETAILS_CGSDATAINFO_C = 150131;
    public static final int TOKEN_CHART_DETAILS_CGSPROPERTIES_O = 150140;
    public static final int TOKEN_CHART_DETAILS_CGSPROPERTIES_C = 150141;
    public static final int TOKEN_CHART_REGIONS_O = 150150;
    public static final int TOKEN_CHART_REGIONS_C = 150151;
    public static final int TOKEN_CHART_DETAILS_O = 150152;
    public static final int TOKEN_CHART_DETAILS_C = 150153;
    public static final int TOKEN_SUMMARYTEXT_O = 150200;
    public static final int TOKEN_SUMMARYTEXT_C = 150201;
    public static final int TOKEN_ALTERNATETEXT_O = 150202;
    public static final int TOKEN_ALTERNATETEXT_C = 150203;
    protected BufferedWriter m_OutputWriter = null;
    protected FilterFSM m_fsm = NullFSM.getNullFsmRef();
    protected Stack m_fsmStack = new Stack();
    protected Vector m_XpathLoc = new Vector();
    protected int m_XpathCursor = 0;
    protected HashMap m_globalValues = new HashMap();
    protected StringBuffer m_textnodeBuff = null;
    protected boolean m_bEcho = false;
    protected boolean m_bEraseLastTag = false;
    protected boolean m_bEchoOnUnknownTags = false;
    protected int m_pendingEvent = -1;
    protected boolean m_skipNext = false;
    protected boolean m_sourceIsV1 = false;
    protected boolean m_sourceIsV2 = false;
    protected boolean m_sourceIsV3 = false;
    protected String m_documentNS = null;
    protected OutputStream out;
    private String recordNode;
    protected Conversation m_conversation;
    protected Cognos8Connector m_connect;
    private Deque<PendingBuffer> m_pendingBufferStack = new ArrayDeque<PendingBuffer>();
    public static final Map<String, Integer> m_TokenMap;

    public boolean IsSourceV1() {
        return this.m_sourceIsV1;
    }

    public void setEchoOnUnknownTags(boolean bl) {
        this.m_bEchoOnUnknownTags = bl;
    }

    public boolean IsSourceV2() {
        return this.m_sourceIsV2;
    }

    public boolean IsSourceV3() {
        return this.m_sourceIsV3;
    }

    public String getDocumentNamespace() {
        return this.m_documentNS;
    }

    public void setOutStream(OutputStream outputStream) {
        this.out = outputStream;
        try {
            this.m_OutputWriter = new BufferedWriter(new OutputStreamWriter(outputStream, "UTF-8"));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            unsupportedEncodingException.printStackTrace();
        }
    }

    public void setGlobal(String string, Object object) {
        this.m_globalValues.put(string, object);
    }

    public Object getGlobal(String string) {
        return this.m_globalValues.get(string);
    }

    public void injectEvent(int n) {
        this.m_pendingEvent = n;
    }

    public void SetFsm(FilterFSM filterFSM) {
        this.m_fsm = filterFSM;
    }

    public void pushFsm(FilterFSM filterFSM) {
        this.m_fsmStack.push(this.m_fsm);
        this.m_fsm = filterFSM;
    }

    public void popFsm() {
        this.m_fsm = (FilterFSM)this.m_fsmStack.pop();
        if (this.m_fsm == null) {
            this.m_fsm = NullFSM.getNullFsmRef();
        }
    }

    public int getXpathDepth() {
        return this.m_XpathCursor;
    }

    public String getXpathLoc(int n) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = n; i < this.m_XpathCursor; ++i) {
            stringBuffer.append("/");
            stringBuffer.append(this.m_XpathLoc.get(i));
        }
        return stringBuffer.toString();
    }

    public void RecordTextNodeOn() {
        this.m_textnodeBuff = new StringBuffer();
    }

    public void RecordTextNodeOff() {
        this.m_textnodeBuff = null;
        this.recordNode = null;
    }

    public String getTextNode() {
        return this.m_textnodeBuff.toString();
    }

    public boolean getEchoMode() {
        return this.m_bEcho;
    }

    public void setEchoMode(boolean bl) {
        this.m_bEcho = bl;
    }

    public void skipNextElement() {
        this.m_skipNext = true;
    }

    public void skipLastElement() {
        this.m_bEraseLastTag = true;
    }

    public void startPendingBuffer() {
        PendingBuffer pendingBuffer = new PendingBuffer();
        this.m_pendingBufferStack.addFirst(pendingBuffer);
    }

    public void stopPendingBuffer() {
        PendingBuffer pendingBuffer = this.m_pendingBufferStack.peekFirst();
        if (pendingBuffer != null) {
            pendingBuffer.canWrite = false;
        }
    }

    public void flushPendingBuffer() {
        if (this.m_pendingBufferStack.peekFirst() != null) {
            PendingBuffer pendingBuffer = this.m_pendingBufferStack.removeFirst();
            StringBuffer stringBuffer = pendingBuffer.buffer;
            PendingBuffer pendingBuffer2 = this.m_pendingBufferStack.peekFirst();
            if (pendingBuffer2 != null && pendingBuffer2.canWrite) {
                pendingBuffer2.write(stringBuffer.toString());
            } else {
                this.write(stringBuffer.toString());
            }
        }
    }

    private void write(String string, boolean bl) throws IOException {
        try {
            for (PendingBuffer pendingBuffer : this.m_pendingBufferStack) {
                if (!pendingBuffer.canWrite) continue;
                pendingBuffer.write(string);
                return;
            }
            this.m_OutputWriter.write(string);
        }
        catch (IOException iOException) {
            if (!bl) {
                throw iOException;
            }
            CCSGeneralException cCSGeneralException = new CCSGeneralException("PARSE_STREAM_ERROR", iOException, 500);
            CCSLogger.getInstance().logRuntimeErrorMessage(cCSGeneralException.getServerLocaleMessage(), null, null, null, cCSGeneralException.getSourceTrace());
        }
    }

    public void write(String string) {
        try {
            this.write(string, true);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void writeOpen(String string) {
        this.write(OPEN_TAG);
        this.write(string);
        this.write(CLOSE_TAG);
    }

    public void writeClose(String string) {
        this.write(OPEN_ETAG);
        this.write(string);
        this.write(CLOSE_TAG);
    }

    public void writeElement(String string, String string2) {
        this.writeOpen(string);
        this.write(this.escapeIfNeeded(string2));
        this.writeClose(string);
    }

    @Override
    public void characters(char[] cArray, int n, int n2) throws SAXException {
        try {
            if (this.m_textnodeBuff != null) {
                this.m_textnodeBuff.append(cArray, n, n2);
            }
            if (this.m_bEcho) {
                this.write(this.escapeIfNeeded(cArray, n, n2), false);
            }
        }
        catch (IOException iOException) {
            CCSGeneralException cCSGeneralException = new CCSGeneralException("PARSE_STREAM_ERROR", iOException, 500);
            CCSLogger.getInstance().logRuntimeErrorMessage(cCSGeneralException.getServerLocaleMessage(), null, null, null, cCSGeneralException.getSourceTrace());
            throw new SAXException(iOException);
        }
    }

    @Override
    public void endDocument() throws SAXException {
        try {
            this.m_OutputWriter.flush();
            if (this.out instanceof PipedOutputStream) {
                this.out.flush();
                this.m_OutputWriter.close();
            }
            if (this.m_fsmStack.size() > 0) {
                throw new SAXException("STACK NOT EMPTY");
            }
        }
        catch (IOException iOException) {
            CCSGeneralException cCSGeneralException = new CCSGeneralException("PARSE_STREAM_ERROR", iOException, 500);
            CCSLogger.getInstance().logRuntimeErrorMessage(cCSGeneralException.getServerLocaleMessage(), null, null, null, cCSGeneralException.getSourceTrace());
            throw new SAXException(iOException);
        }
    }

    @Override
    public void endElement(String string, String string2, String string3) throws SAXException {
        try {
            int n = this.getToken(string2, false);
            this.m_XpathLoc.removeElementAt(--this.m_XpathCursor);
            boolean bl = this.m_bEcho;
            if (n != -1) {
                this.m_fsm.processEvent(n);
                if (this.m_pendingEvent != -1) {
                    int n2 = this.m_pendingEvent;
                    this.m_pendingEvent = -1;
                    this.m_fsm.processEvent(n2);
                }
            } else if (this.m_fsm instanceof UnknownTagHandler) {
                ((UnknownTagHandler)this.m_fsm).processUnknownEvent(string2, false);
            }
            if (this.m_bEcho && !this.m_skipNext || bl && !this.m_bEraseLastTag) {
                this.write(OPEN_ETAG, false);
                this.write(string2, false);
                this.write(CLOSE_TAG, false);
            } else if (this.m_skipNext) {
                this.m_skipNext = false;
            }
            this.m_bEraseLastTag = false;
        }
        catch (IOException iOException) {
            CCSGeneralException cCSGeneralException = new CCSGeneralException("PARSE_STREAM_ERROR", iOException, 500);
            CCSLogger.getInstance().logRuntimeErrorMessage(cCSGeneralException.getServerLocaleMessage(), null, null, null, cCSGeneralException.getSourceTrace());
            throw new SAXException(iOException);
        }
    }

    @Override
    public void startDocument() throws SAXException {
    }

    public int getToken(String string, boolean bl) {
        return LdxHandler.lookupToken(string, bl);
    }

    public static int lookupToken(String string, boolean bl) {
        Integer n;
        int n2 = 0;
        if (!bl) {
            ++n2;
        }
        if ((n = m_TokenMap.get(string)) == null) {
            return -1;
        }
        return n2 + n;
    }

    public void skipElement(int n) {
        if (n % 2 == 0) {
            this.pushFsm(new SkipElementHandler(this, n));
        }
    }

    public void echoElement(int n) {
        if (n % 2 == 0) {
            this.pushFsm(new EchoElementHandler(this, n));
        }
    }

    @Override
    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        int n;
        this.m_XpathLoc.add(string2);
        ++this.m_XpathCursor;
        if (string.equals("http://developer.cognos.com/schemas/rds/contentmodel/1")) {
            this.m_sourceIsV1 = true;
        }
        if (string.equals("http://www.ibm.com/xmlns/prod/cognos/layoutData/200904")) {
            this.m_sourceIsV2 = true;
        }
        if (string.equals("http://www.ibm.com/xmlns/prod/cognos/layoutData/201310")) {
            this.m_sourceIsV3 = true;
        }
        if (this.m_documentNS == null) {
            this.m_documentNS = string;
        }
        if ((n = this.getToken(string2, true)) != -1) {
            this.m_fsm.processEvent(n);
            if (this.m_pendingEvent != -1) {
                int n2 = this.m_pendingEvent;
                this.m_pendingEvent = -1;
                this.m_fsm.processEvent(n2);
            }
        } else if (this.m_bEchoOnUnknownTags && !(this.m_fsm instanceof SkipElementHandler) && !(this.m_fsm instanceof EchoElementHandler)) {
            UnknownTagHandler unknownTagHandler = this.m_fsm instanceof UnknownTagHandler ? (UnknownTagHandler)this.m_fsm : new UnknownTagHandler(this, string2);
            unknownTagHandler.processUnknownEvent(string2, true);
        }
        if (this.m_bEcho && !this.m_skipNext) {
            try {
                this.write(OPEN_TAG, false);
                this.write(string2, false);
                this.write(CLOSE_TAG, false);
            }
            catch (IOException iOException) {
                CCSGeneralException cCSGeneralException = new CCSGeneralException("PARSE_STREAM_ERROR", iOException, 500);
                CCSLogger.getInstance().logRuntimeErrorMessage(cCSGeneralException.getServerLocaleMessage(), null, null, null, cCSGeneralException.getSourceTrace());
                throw new SAXException(iOException);
            }
        } else if (this.m_skipNext) {
            this.m_skipNext = false;
        }
    }

    public void writeAttribute(String string, String string2, String string3) {
        try {
            this.write(" ", false);
            this.write(string, false);
            this.write("=" + string3, false);
            this.write(string2, false);
            this.write(string3, false);
        }
        catch (IOException iOException) {
            CCSGeneralException cCSGeneralException = new CCSGeneralException("PARSE_STREAM_ERROR", iOException, 500);
            CCSLogger.getInstance().logRuntimeErrorMessage(cCSGeneralException.getServerLocaleMessage(), null, null, null, cCSGeneralException.getSourceTrace());
        }
    }

    public void writeAttribute(String string, String string2) {
        this.writeAttribute(string, string2, "\"");
    }

    public String escapeIfNeeded(char[] cArray, int n, int n2) {
        String string = new String(cArray, n, n2);
        return this.escapeIfNeeded(string);
    }

    public String escapeIfNeeded(String string) {
        boolean bl = false;
        if (string.indexOf(62) > -1) {
            bl = true;
        } else if (string.indexOf(38) > -1) {
            bl = true;
        } else if (string.indexOf(60) > -1) {
            bl = true;
        } else if (string.indexOf(34) > -1) {
            bl = true;
        } else if (string.indexOf(39) > -1) {
            bl = true;
        }
        if (bl) {
            string = Utilities.escapeXML(string);
        }
        return string;
    }

    public OutputStream getOutputStream() {
        return this.out;
    }

    public void flushOutput() {
        try {
            this.m_OutputWriter.flush();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public String getRecordNode() {
        return this.recordNode;
    }

    public void setRecordNode(String string) {
        this.recordNode = string;
    }

    public void setConversation(Conversation conversation) {
        this.m_conversation = conversation;
    }

    public Conversation getConversation() {
        return this.m_conversation;
    }

    public void setConnector(Cognos8Connector cognos8Connector) {
        this.m_connect = cognos8Connector;
    }

    public Cognos8Connector getConnector() {
        return this.m_connect;
    }

    static {
        HashMap<String, Integer> hashMap = new HashMap<String, Integer>();
        hashMap.put("lst", new Integer(1020));
        hashMap.put("ctab", new Integer(1030));
        hashMap.put("id", new Integer(1010));
        hashMap.put("row", new Integer(1040));
        hashMap.put("column", new Integer(1050));
        hashMap.put("measure", new Integer(1060));
        hashMap.put("table", new Integer(1070));
        hashMap.put("val", new Integer(1080));
        hashMap.put("valErrorState", new Integer(1082));
        hashMap.put("valTyp", new Integer(1086));
        hashMap.put("nestedDimension", new Integer(1090));
        hashMap.put("name", new Integer(1100));
        hashMap.put("start", new Integer(1200));
        hashMap.put("cell", new Integer(1300));
        hashMap.put("isFirstCell", new Integer(1310));
        hashMap.put("hdr", new Integer(1320));
        hashMap.put("hdrs", new Integer(1330));
        hashMap.put("corner", new Integer(1400));
        hashMap.put("cspan", new Integer(1500));
        hashMap.put("rspan", new Integer(1600));
        hashMap.put("colTitle", new Integer(1700));
        hashMap.put("group", new Integer(1800));
        hashMap.put("grp", new Integer(1900));
        hashMap.put("header", new Integer(2100));
        hashMap.put("footer", new Integer(2000));
        hashMap.put("ref", new Integer(2200));
        hashMap.put("item", new Integer(2300));
        hashMap.put("style", new Integer(2400));
        hashMap.put("txt", new Integer(2500));
        hashMap.put("img", new Integer(2600));
        hashMap.put("cht", new Integer(2700));
        hashMap.put("em", new Integer(2750));
        hashMap.put("stg", new Integer(2752));
        hashMap.put("h1", new Integer(2754));
        hashMap.put("h2", new Integer(2756));
        hashMap.put("h3", new Integer(2758));
        hashMap.put("h4", new Integer(2760));
        hashMap.put("h5", new Integer(2762));
        hashMap.put("h6", new Integer(2764));
        hashMap.put("p_txtbox", new Integer(2770));
        hashMap.put("p_value", new Integer(2772));
        hashMap.put("p_date", new Integer(2774));
        hashMap.put("p_time", new Integer(2776));
        hashMap.put("p_dtime", new Integer(2778));
        hashMap.put("p_intrvl", new Integer(2780));
        hashMap.put("p_dsrc", new Integer(2782));
        hashMap.put("p_srch", new Integer(2784));
        hashMap.put("p_tree", new Integer(2786));
        hashMap.put("p_btn", new Integer(2788));
        hashMap.put("page", new Integer(2800));
        hashMap.put("pages", new Integer(2802));
        hashMap.put("booklet", new Integer(2812));
        hashMap.put("body", new Integer(2900));
        hashMap.put("styleGroup", new Integer(3000));
        hashMap.put("versionBase", new Integer(3100));
        hashMap.put("url", new Integer(3200));
        hashMap.put("document", new Integer(3300));
        hashMap.put("lang", new Integer(3310));
        hashMap.put("filterResultSet", new Integer(3400));
        hashMap.put("filterResult", new Integer(3402));
        hashMap.put("locationReference", new Integer(3500));
        hashMap.put("di", new Integer(3600));
        hashMap.put("dv", new Integer(3700));
        hashMap.put("fmtVal", new Integer(3800));
        hashMap.put("html", new Integer(3900));
        hashMap.put("bmrk", new Integer(4002));
        hashMap.put("label", new Integer(4006));
        hashMap.put("rept", new Integer(5000));
        hashMap.put("reptbl", new Integer(5006));
        hashMap.put("toc", new Integer(6000));
        hashMap.put("entry", new Integer(6006));
        hashMap.put("bookmark", new Integer(6002));
        hashMap.put("rtxt", new Integer(7000));
        hashMap.put("span", new Integer(7002));
        hashMap.put("div", new Integer(7004));
        hashMap.put("ordered", new Integer(7006));
        hashMap.put("rtList", new Integer(7010));
        hashMap.put("table", new Integer(1070));
        hashMap.put("listItem", new Integer(7008));
        hashMap.put("details", new Integer(150152));
        hashMap.put("cgsWidget", new Integer(150100));
        hashMap.put("cgsData", new Integer(150120));
        hashMap.put("cgsDataInfo", new Integer(150130));
        hashMap.put("cgsProperties", new Integer(150140));
        hashMap.put("cgsPropCanvas", new Integer(150110));
        hashMap.put("regions", new Integer(150150));
        hashMap.put("ctx", new Integer(8000));
        hashMap.put("pageGroup", new Integer(9000));
        hashMap.put("drills", new Integer(10000));
        hashMap.put("depth", new Integer(11000));
        hashMap.put("hlink", new Integer(12000));
        hashMap.put("lcr", new Integer(13000));
        hashMap.put("drillDefinitions", new Integer(14000));
        hashMap.put("canDrillUp", new Integer(15000));
        hashMap.put("canDrilLDown", new Integer(15002));
        hashMap.put("targetPath", new Integer(15006));
        hashMap.put("tbl", new Integer(16000));
        hashMap.put("tcell", new Integer(16100));
        hashMap.put("trow", new Integer(16200));
        hashMap.put("items", new Integer(16300));
        hashMap.put("blk", new Integer(16400));
        hashMap.put("size", new Integer(16500));
        hashMap.put("indent", new Integer(16600));
        hashMap.put("target", new Integer(16700));
        hashMap.put("horizontalLayout", new Integer(16800));
        hashMap.put("horizontalSize", new Integer(16900));
        hashMap.put("verticalSize", new Integer(17000));
        hashMap.put("contents", new Integer(17100));
        hashMap.put("annURL", new Integer(17200));
        hashMap.put("reportPath", new Integer(17300));
        hashMap.put("vAlign", new Integer(17400));
        hashMap.put("drillAction", new Integer(17500));
        hashMap.put("direction", new Integer(17600));
        hashMap.put("isCMMMap", new Integer(17700));
        hashMap.put("isFirstElement", new Integer(150050));
        hashMap.put("isLayoutTable", new Integer(150052));
        hashMap.put("labelFor", new Integer(150060));
        hashMap.put("cname", new Integer(150062));
        hashMap.put("extension", new Integer(150066));
        hashMap.put("widget", new Integer(17800));
        hashMap.put("widgetURI", new Integer(17900));
        hashMap.put("title", new Integer(17912));
        hashMap.put("storeID", new Integer(18000));
        hashMap.put("hidden", new Integer(3005));
        hashMap.put("display", new Integer(3003));
        hashMap.put("x", new Integer(110010));
        hashMap.put("y", new Integer(110012));
        hashMap.put("type", new Integer(110004));
        hashMap.put("actionURL", new Integer(130100));
        hashMap.put("URLParameters", new Integer(130102));
        hashMap.put("fmtPatrn", new Integer(20000));
        hashMap.put("exclPatrn", new Integer(21000));
        hashMap.put("fmtLoc", new Integer(22000));
        hashMap.put("fmtScale", new Integer(23000));
        hashMap.put("drill", new Integer(110018));
        hashMap.put("value", new Integer(110028));
        hashMap.put("sngl", new Integer(120008));
        hashMap.put("drillRef", new Integer(110016));
        hashMap.put("area", new Integer(110002));
        hashMap.put("secondaryOperations", new Integer(19010));
        hashMap.put("tr", new Integer(7014));
        hashMap.put("td", new Integer(7016));
        hashMap.put("th", new Integer(7018));
        hashMap.put("mun", new Integer(150000));
        hashMap.put("schemaSubversion", new Integer(140000));
        hashMap.put("summaryText", 150200);
        hashMap.put("alternateText", 150202);
        m_TokenMap = Collections.unmodifiableMap(hashMap);
    }

    public static class RecordHandler
    implements FilterFSM {
        final int STARTEVENT;
        final int ENDEVENT;
        private String nodeString = null;
        LdxHandler handler;

        public RecordHandler(LdxHandler ldxHandler, String string, int n) {
            this.handler = ldxHandler;
            if (n % 2 != 0) {
                throw new RuntimeException("Expected a starting element");
            }
            this.STARTEVENT = n;
            this.ENDEVENT = n + 1;
            ldxHandler.setRecordNode(string);
            ldxHandler.injectEvent(n);
        }

        public void write() {
            if (this.nodeString != null && !"".equals(this.nodeString)) {
                this.handler.write(this.nodeString);
                this.nodeString = null;
            }
        }

        @Override
        public void processEvent(int n) {
            if (n == this.STARTEVENT) {
                this.handler.RecordTextNodeOn();
            } else if (n == this.ENDEVENT) {
                String string = this.handler.getRecordNode();
                this.nodeString = LdxHandler.OPEN_TAG + string + LdxHandler.CLOSE_TAG + this.handler.getTextNode() + LdxHandler.OPEN_ETAG + string + LdxHandler.CLOSE_TAG;
                this.handler.popFsm();
            }
        }

        @Override
        public void reset() {
        }
    }

    private static class PendingBuffer {
        public boolean canWrite = true;
        public StringBuffer buffer = new StringBuffer();

        public void write(String string) {
            this.buffer.append(string);
        }
    }

    static class UnknownTagHandler
    implements FilterFSM {
        final String UNTILTAG;
        int depth;
        LdxHandler handler;
        boolean prev_echoMode;

        UnknownTagHandler(LdxHandler ldxHandler, String string) {
            this.handler = ldxHandler;
            this.UNTILTAG = string;
            this.depth = 0;
            this.prev_echoMode = ldxHandler.getEchoMode();
            ldxHandler.setEchoMode(true);
            ldxHandler.pushFsm(this);
        }

        @Override
        public void processEvent(int n) {
        }

        public void processUnknownEvent(String string, boolean bl) {
            if (this.UNTILTAG.equals(string)) {
                this.depth += bl ? 1 : -1;
                if (this.depth <= 0) {
                    this.handler.popFsm();
                    this.handler.setEchoMode(this.prev_echoMode);
                }
            }
        }

        @Override
        public void reset() {
        }
    }

    static class SkipElementHandler
    implements FilterFSM {
        final int ENDEVENT;
        int depth;
        boolean save_echoMode;
        LdxHandler handler;

        public SkipElementHandler(LdxHandler ldxHandler, int n) {
            if (n % 2 != 0) {
                throw new RuntimeException("Expected a starting element");
            }
            this.ENDEVENT = n + 1;
            this.depth = 1;
            this.save_echoMode = ldxHandler.getEchoMode();
            ldxHandler.setEchoMode(false);
            this.handler = ldxHandler;
        }

        @Override
        public void processEvent(int n) {
            if (n == this.ENDEVENT && --this.depth <= 0) {
                this.handler.popFsm();
                this.handler.setEchoMode(this.save_echoMode);
            }
        }

        @Override
        public void reset() {
        }
    }

    static class EchoElementHandler
    implements FilterFSM {
        final int STARTEVENT;
        final int ENDEVENT;
        int depth;
        LdxHandler handler;

        public EchoElementHandler(LdxHandler ldxHandler, int n) {
            if (n % 2 != 0) {
                throw new RuntimeException("Expected a starting element");
            }
            this.STARTEVENT = n;
            this.ENDEVENT = n + 1;
            this.depth = 1;
            this.handler = ldxHandler;
            ldxHandler.setEchoMode(true);
        }

        @Override
        public void processEvent(int n) {
            if (n == this.STARTEVENT) {
                ++this.depth;
            } else if (n == this.ENDEVENT && --this.depth <= 0) {
                this.handler.setEchoMode(false);
                this.handler.popFsm();
            }
        }

        @Override
        public void reset() {
        }
    }

    public static interface FilterFSM {
        public void processEvent(int var1);

        public void reset();
    }
}

