/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.ccs.service;

import com.cognos.ccs.cache.ConversationCache;
import com.cognos.ccs.content.ContentProvider;
import com.cognos.ccs.content.PromptValue;
import com.cognos.ccs.content.RDSSchema;
import com.cognos.ccs.exceptions.CCSAuthenticationException;
import com.cognos.ccs.exceptions.CCSException;
import com.cognos.ccs.exceptions.CCSGeneralException;
import com.cognos.ccs.exceptions.CCSPromptException;
import com.cognos.ccs.filter.ContextFilter;
import com.cognos.ccs.filter.Filter;
import com.cognos.ccs.service.CCLMessage;
import com.cognos.ccs.service.CCSDataResult;
import com.cognos.ccs.service.CCSLogger;
import com.cognos.ccs.service.CCSResponder;
import com.cognos.ccs.service.CCSSession;
import com.cognos.ccs.service.Cognos8Connector;
import com.cognos.ccs.service.ConfigMgr;
import com.cognos.ccs.service.Conversation;
import com.cognos.ccs.service.SoapParms;
import com.cognos.ccs.transports.SOAPTransport;
import com.cognos.ccs.utility.Utilities;
import com.cognos.developer.schemas.bibus._3.AsynchRequest;
import com.cognos.pogo.pdk.BIBusEnvelope;
import com.cognos.pogo.pdk.Fault;
import com.cognos.pogo.pdk.MessageContext;
import com.ibm.cognos.ccs.internal.utility.Constants;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.mail.internet.InternetHeaders;
import org.apache.commons.httpclient.Cookie;
import org.dom4j.Element;
import org.dom4j.Namespace;
import org.dom4j.QName;

public class BaseRDSSession
extends CCSSession {
    protected RDSSchema m_Schema = RDSSchema.getInstance(Constants.NamespaceVersion.V1);
    private Cognos8Connector m_Connection = new Cognos8Connector();
    protected Locale m_UserLocale = Locale.ENGLISH;
    protected CCSLogger m_Logger = CCSLogger.getInstance();
    protected String m_ContentLocale = "en-us";
    protected CCSResponder m_Responder = null;
    protected SOAPTransport m_Transport = new SOAPTransport();
    private Cookie[] m_Cookies = null;
    protected String m_SessionID = null;
    protected String m_RequestId = null;
    protected String m_ConversationId = null;

    public BaseRDSSession() {
        try {
            this.m_Connection.connectToReportServer();
        }
        catch (CCSGeneralException cCSGeneralException) {
            this.m_Logger.logRuntimeErrorMessage(cCSGeneralException.getServerLocaleMessage(), null, null, null, cCSGeneralException.getSourceTrace());
        }
    }

    protected void describePrompts(Element element, BIBusEnvelope bIBusEnvelope) {
        Element element2 = bIBusEnvelope.getBody().addElement(this.m_Schema.getOutputResponseQN());
        Element element3 = element2.addElement(this.m_Schema.getOutputQN());
        try {
            ConversationCache conversationCache;
            Object object;
            String string = SoapParms.getStringParm(element, "searchPath", null, false);
            PromptValue[] promptValueArray = SoapParms.getPromptParms(element, "promptValues", false);
            String string2 = SoapParms.getStringParm(element, "conversationID", null, true);
            if (this.m_Logger.isUserRequestLogging()) {
                object = new HashMap<String, String>();
                ((HashMap)object).put("searchPath", string);
                for (int i = 0; i < promptValueArray.length; ++i) {
                    ((HashMap)object).put("promptValue[" + i + "]", Utilities.escapeXML(promptValueArray[i].toXML().asXML()));
                }
                ((HashMap)object).put("conversationID", string2);
                this.m_Logger.logUserRequest("describePrompts", (Map)object, this.m_SessionID, this.m_RequestId);
            }
            object = ContentProvider.getProvider(string, this.m_Connection, this.m_Cookies, this);
            Conversation conversation = null;
            if (null != string2) {
                conversationCache = this.m_Connection.conversationCache();
                conversation = conversationCache.getConversation(string2);
            }
            if (conversation != null) {
                conversation.setProperty("USE_CCS_PROMPT_URL", false);
            }
            ((ContentProvider)object).retrievePromptDescription(promptValueArray, null, conversation);
            conversationCache = element3.addElement(this.m_Schema.getDescribePromptsResponseQN());
            conversationCache.addElement("ccsdatamarker");
            CCSDataResult cCSDataResult = new CCSDataResult(this.m_Transport, (ContentProvider)object);
            this.m_Responder.setData(cCSDataResult);
            this.generateResponseStatus(element2, this.m_Schema.getEnumNoError(), null);
        }
        catch (CCSGeneralException cCSGeneralException) {
            this.m_Logger.logRuntimeErrorMessage(cCSGeneralException.getServerLocaleMessage(), "describePrompts", this.m_SessionID, this.m_RequestId, cCSGeneralException.getSourceTrace());
            this.generateResponseStatus(element2, this.m_Schema.getEnumServerError(), cCSGeneralException.getUserLocaleMessage(this.m_UserLocale));
        }
        catch (CCSAuthenticationException cCSAuthenticationException) {
            this.generateResponseStatus(element2, this.m_Schema.getEnumAuthError(), CCLMessage.getResMessage("AUTH_ERROR", this.m_UserLocale));
        }
        this.generateAsyncStatus(element2, this.m_Schema.getEnumComplete());
    }

    protected void downloadFile(Element element, BIBusEnvelope bIBusEnvelope) {
        Element element2 = bIBusEnvelope.getBody().addElement(this.m_Schema.getDownloadFileResponseQN());
        try {
            Element element3;
            String string = SoapParms.getStringParm(element, "searchPath", null, false);
            String string2 = this.m_Connection.getFile(string);
            if (this.m_Logger.isUserRequestLogging()) {
                element3 = new HashMap();
                element3.put("folder", string);
                this.m_Logger.logUserRequest("downloadFile", (Map)element3, this.m_SessionID, this.m_RequestId);
            }
            if (string2 != null) {
                element3 = element2.addElement(this.m_Schema.getFileDataQN());
                element3.setText(string2);
            }
            this.generateResponseStatus(element2, this.m_Schema.getEnumNoError(), null);
        }
        catch (CCSGeneralException cCSGeneralException) {
            this.m_Logger.logRuntimeErrorMessage(cCSGeneralException.getServerLocaleMessage(), "downloadFile", this.m_SessionID, this.m_RequestId, cCSGeneralException.getSourceTrace());
            this.generateResponseStatus(element2, this.m_Schema.getEnumServerError(), cCSGeneralException.getUserLocaleMessage(this.m_UserLocale));
        }
        catch (CCSAuthenticationException cCSAuthenticationException) {
            this.generateResponseStatus(element2, this.m_Schema.getEnumAuthError(), null);
        }
    }

    protected void generateAsyncStatus(Element element, String string) {
        Element element2 = element.addElement(this.m_Schema.getAsyncStatusQN());
        element2.setText(string);
    }

    protected void generatePromptingResponseStatus(Element element, String string, CCSPromptException cCSPromptException, boolean bl, boolean bl2) {
        Element element2;
        String string2 = cCSPromptException.getUserLocaleMessage(this.m_UserLocale);
        String string3 = this.m_Schema.getEnumPromptErr();
        Element element3 = element.addElement(this.m_Schema.getResponseStatusQN());
        Element element4 = element3.addElement(this.m_Schema.getResponseCodeQN());
        try {
            element2 = element3.addElement(this.m_Schema.getPromptURLQN());
            String string4 = this.getGatewayURL(bl, bl2);
            element2.setText(this.m_Connection.formPromptURL(string4, string, null, false));
        }
        catch (CCSGeneralException cCSGeneralException) {
            element4.setText(this.m_Schema.getEnumServerError());
            Element element5 = element3.addElement(this.m_Schema.getResponseMessageQN());
            element5.setText(cCSGeneralException.getUserLocaleMessage(this.m_UserLocale));
            this.m_Logger.logRuntimeErrorMessage(cCSGeneralException.getServerLocaleMessage(), "generatePromptResponse", this.m_SessionID, this.m_RequestId, cCSGeneralException.getSourceTrace());
        }
        if (string2 != null) {
            element2 = element3.addElement(this.m_Schema.getResponseMessageQN());
            element2.setText(string2);
        }
        element4.setText(string3);
    }

    protected void generateResponseStatus(Element element, String string, String string2) {
        Element element2 = element.addElement(this.m_Schema.getResponseStatusQN());
        Element element3 = element2.addElement(this.m_Schema.getResponseCodeQN());
        if (string2 != null) {
            Element element4 = element2.addElement(this.m_Schema.getResponseMessageQN());
            element4.setText(string2);
        }
        element3.setText(string);
    }

    public Cognos8Connector getC8Connector() {
        return this.m_Connection;
    }

    public Cookie[] getCookies() {
        return this.m_Cookies;
    }

    public String getLocale() {
        return this.m_ContentLocale;
    }

    public void getPrompts(Element element, BIBusEnvelope bIBusEnvelope) {
        Element element2 = bIBusEnvelope.getBody().addElement(this.m_Schema.getGetPromptsResponseQN());
        try {
            PromptValue[] promptValueArray;
            String string = SoapParms.getStringParm(element, "promptId", null, false);
            if (this.m_Logger.isUserRequestLogging()) {
                promptValueArray = new HashMap();
                promptValueArray.put("promptID", string);
                this.m_Logger.logUserRequest("getPrompts", (Map)promptValueArray, this.m_SessionID, this.m_RequestId);
            }
            if (null != (promptValueArray = this.m_Connection.getPrompts(string))) {
                for (int i = 0; i < promptValueArray.length; ++i) {
                    element2.add(promptValueArray[i].toXML());
                }
            }
            this.generateResponseStatus(element2, this.m_Schema.getEnumNoError(), null);
        }
        catch (CCSGeneralException cCSGeneralException) {
            this.m_Logger.logRuntimeErrorMessage(cCSGeneralException.getServerLocaleMessage(), "getPrompts", this.m_SessionID, this.m_RequestId, cCSGeneralException.getSourceTrace());
            this.generateResponseStatus(element2, this.m_Schema.getEnumServerError(), cCSGeneralException.getUserLocaleMessage(this.m_UserLocale));
        }
        catch (CCSAuthenticationException cCSAuthenticationException) {
            this.generateResponseStatus(element2, this.m_Schema.getEnumAuthError(), null);
        }
    }

    public void getPromptsAndContent(Element element, BIBusEnvelope bIBusEnvelope) {
        Element element2 = bIBusEnvelope.getBody().addElement(this.m_Schema.getOutputResponseQN());
        Element element3 = element2.addElement(this.m_Schema.getOutputQN());
        ContentProvider contentProvider = null;
        String string = null;
        String string2 = null;
        String string3 = null;
        String string4 = null;
        String string5 = null;
        int n = 0;
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        try {
            Object object;
            string = SoapParms.getStringParm(element, "searchPath", null, false);
            Filter[] filterArray = SoapParms.getFilterParm(element, "filters", true);
            String string6 = SoapParms.getStringParm(element, "promptId", null, false);
            Element element4 = element3.addElement(this.m_Schema.getPromptscontentOutputQN());
            PromptValue[] promptValueArray = this.m_Connection.getPrompts(string6);
            string2 = SoapParms.getContainedStringParm(element, "version", "versionType", null, true);
            string3 = SoapParms.getContainedStringParm(element, "version", "versionName", null, true);
            string4 = SoapParms.getContainedStringParm(element, "burstInfo", "burstKey", null, true);
            string5 = SoapParms.getContainedStringParm(element, "burstInfo", "burstId", null, true);
            n = SoapParms.getIntParm(element, "rowLimit", 0, Integer.MAX_VALUE, true);
            String string7 = SoapParms.getStringParm(element, "paged", null, true);
            if (string7 != null && (string7.equalsIgnoreCase("true") || string7.equals("1"))) {
                bl = true;
            }
            boolean bl4 = SoapParms.getBooleanParm(element, "excludePage", false, true);
            boolean bl5 = SoapParms.getBooleanParm(element, "includePageBreaks", false, true);
            bl2 = SoapParms.getBooleanParm(element, "generateRelativeUrl", false, true);
            bl3 = SoapParms.getBooleanParm(element, "useGatewayURI", false, true);
            if (Integer.MIN_VALUE == n) {
                n = 0;
            }
            if (this.m_Logger.isUserRequestLogging()) {
                object = new HashMap<String, String>();
                ((HashMap)object).put("searchPath", string);
                if (filterArray != null) {
                    for (int i = 0; i < filterArray.length; ++i) {
                        ((HashMap)object).put("filters[" + i + "]", Utilities.escapeXML(filterArray[i].getFilterValue()));
                    }
                }
                ((HashMap)object).put("filters", string);
                ((HashMap)object).put("promptID", string6);
                ((HashMap)object).put("versionType", string2);
                ((HashMap)object).put("versionName", string3);
                ((HashMap)object).put("burstKey", string4);
                ((HashMap)object).put("burstId", string5);
                ((HashMap)object).put("rowLimit", Integer.toString(n));
                this.m_Logger.logUserRequest("getPromptsAndContent", (Map)object, this.m_SessionID, this.m_RequestId);
            }
            contentProvider = ContentProvider.getProvider(string, this.m_Connection, this.m_Cookies, this);
            contentProvider.setDowngrade(Constants.Compatibility.C8_4_OEM);
            contentProvider.retrieveDataContent(string2, null, string3, string4, string5, promptValueArray, bl, true, null, bl2, bl3, false);
            object = new CCSDataResult(this.m_Transport, contentProvider, filterArray, n, null);
            ((CCSDataResult)object).setDowngrade(Constants.Compatibility.C8_4_OEM);
            Conversation conversation = new Conversation(this.m_Connection.getRSBus());
            conversation.setProperty("excludePage", bl4);
            conversation.setProperty("includePageBreaks", new Boolean(bl5));
            ((CCSDataResult)object).setConversation(this.m_Connection, conversation);
            Element element5 = element4.addElement(this.m_Schema.getContentOutputQN());
            element5.addElement("ccsdatamarker");
            this.getResponder().setData((CCSDataResult)object);
            if (null != promptValueArray) {
                for (int i = 0; i < promptValueArray.length; ++i) {
                    element4.add(promptValueArray[i].toXML());
                }
            }
            this.generateResponseStatus(element2, this.m_Schema.getEnumNoError(), null);
            this.generateAsyncStatus(element2, this.m_Schema.getEnumComplete());
        }
        catch (CCSGeneralException cCSGeneralException) {
            this.m_Logger.logRuntimeErrorMessage(cCSGeneralException.getServerLocaleMessage(), "getPromptsAndContent", this.m_SessionID, this.m_RequestId, cCSGeneralException.getSourceTrace());
            this.generateResponseStatus(element2, this.m_Schema.getEnumServerError(), cCSGeneralException.getUserLocaleMessage(this.m_UserLocale));
            this.generateAsyncStatus(element2, this.m_Schema.getEnumComplete());
        }
        catch (CCSPromptException cCSPromptException) {
            this.generatePromptingResponseStatus(element2, string, cCSPromptException, bl2, bl3);
            this.generateAsyncStatus(element2, this.m_Schema.getEnumComplete());
        }
        catch (CCSAuthenticationException cCSAuthenticationException) {
            this.generateResponseStatus(element2, this.m_Schema.getEnumAuthError(), null);
            this.generateAsyncStatus(element2, this.m_Schema.getEnumComplete());
        }
        bIBusEnvelope.setConversationContextStatus("conversationComplete");
    }

    public void getReportContent(Element element, BIBusEnvelope bIBusEnvelope) {
        Element element2 = bIBusEnvelope.getBody().addElement(this.m_Schema.getOutputResponseQN());
        Element element3 = element2.addElement(this.m_Schema.getOutputQN());
        ContentProvider contentProvider = null;
        String string = null;
        String string2 = null;
        String string3 = null;
        String string4 = null;
        String string5 = null;
        Object object = null;
        int n = 0;
        boolean bl = false;
        boolean bl2 = false;
        try {
            Object object2;
            string = SoapParms.getStringParm(element, "searchPath", null, false);
            Filter[] filterArray = SoapParms.getFilterParm(element, "filters", true);
            PromptValue[] promptValueArray = SoapParms.getPromptParms(element, "promptValues", true);
            string2 = SoapParms.getContainedStringParm(element, "version", "versionType", null, true);
            string3 = SoapParms.getContainedStringParm(element, "version", "versionName", null, true);
            string4 = SoapParms.getContainedStringParm(element, "version", "searchPath", null, true);
            string5 = SoapParms.getContainedStringParm(element, "burstInfo", "burstKey", null, true);
            object = SoapParms.getContainedStringParm(element, "burstInfo", "burstId", null, true);
            n = SoapParms.getIntParm(element, "rowLimit", 0, Integer.MAX_VALUE, true);
            String string6 = SoapParms.getStringParm(element, "paged", null, true);
            String string7 = SoapParms.getStringParm(element, "sourceType", null, true);
            boolean bl3 = false;
            if (string6 != null && (string6.equalsIgnoreCase("true") || string6.equals("1"))) {
                bl3 = true;
            }
            boolean bl4 = SoapParms.getBooleanParm(element, "excludePage", false, true);
            boolean bl5 = SoapParms.getBooleanParm(element, "includePageBreaks", false, true);
            bl = SoapParms.getBooleanParm(element, "generateRelativeUrl", false, true);
            bl2 = SoapParms.getBooleanParm(element, "useGatewayURI", false, true);
            if (Integer.MIN_VALUE == n) {
                n = 0;
            }
            if (this.m_Logger.isUserRequestLogging()) {
                object2 = new HashMap<String, String>();
                ((HashMap)object2).put("searchPath", string);
                if (filterArray != null) {
                    for (int i = 0; i < filterArray.length; ++i) {
                        ((HashMap)object2).put("filters[" + i + "]", Utilities.escapeXML(filterArray[i].getFilterValue()));
                    }
                }
                ((HashMap)object2).put("searchPath", string);
                ((HashMap)object2).put("versionType", string2);
                ((HashMap)object2).put("versionName", string3);
                ((HashMap)object2).put("versionSearchPath", string4);
                ((HashMap)object2).put("burstKey", string5);
                ((HashMap)object2).put("burstId", object);
                ((HashMap)object2).put("rowLimit", Integer.toString(n));
                this.m_Logger.logUserRequest("getReportContent", (Map)object2, this.m_SessionID, this.m_RequestId);
            }
            if (string7 != null && string7.equals("metrics")) {
                string = "metrics(\"" + string + "\")";
            }
            contentProvider = ContentProvider.getProvider(string, this.m_Connection, this.m_Cookies, this);
            if (filterArray != null && filterArray.length > 0 && filterArray[0].getFilterType().equals("CONTEXT_SPEC") && (object2 = ((ContextFilter)filterArray[0]).getBurstId()) != null && !((String)object2).equals("")) {
                object = object2;
            }
            if (n == Integer.MIN_VALUE) {
                n = 0;
            }
            contentProvider.setDowngrade(Constants.Compatibility.C8_4_OEM);
            object2 = contentProvider.retrieveDataContent(string2, string4, string3, string5, (String)object, promptValueArray, bl3, true, null, bl, bl2, false);
            if (filterArray != null && filterArray.length > 0 && filterArray[0].getFilterType().equals("CONTEXT_SPEC")) {
                ((ContextFilter)filterArray[0]).setConverstion((Conversation)object2, this.m_Connection);
            }
            CCSDataResult cCSDataResult = new CCSDataResult(this.m_Transport, contentProvider, filterArray, n, null);
            cCSDataResult.setDowngrade(Constants.Compatibility.C8_4_OEM);
            Element element4 = element3.addElement(this.m_Schema.getContentOutputQN());
            element4.addElement("ccsdatamarker");
            if (object2 != null) {
                ((Conversation)object2).setProperty("filters", filterArray);
                ((Conversation)object2).setProperty("rowLimit", new Integer(n));
                ((Conversation)object2).setProperty("excludePage", bl4);
                ((Conversation)object2).setProperty("includePageBreaks", new Boolean(bl5));
                Element element5 = element2.addElement(new QName("conversationID", this.m_Schema.getRdsNamespace()));
                ConversationCache conversationCache = this.m_Connection.conversationCache();
                String string8 = conversationCache.addConversation((Conversation)object2);
                element5.setText(string8);
                cCSDataResult.setConversation(this.m_Connection, (Conversation)object2);
            }
            this.getResponder().setData(cCSDataResult);
            this.generateResponseStatus(element2, this.m_Schema.getEnumNoError(), null);
            this.generateAsyncStatus(element2, this.m_Schema.getEnumComplete());
        }
        catch (CCSGeneralException cCSGeneralException) {
            this.m_Logger.logRuntimeErrorMessage(cCSGeneralException.getServerLocaleMessage(), "getContent", this.m_SessionID, this.m_RequestId, cCSGeneralException.getSourceTrace());
            this.generateResponseStatus(element2, this.m_Schema.getEnumServerError(), cCSGeneralException.getUserLocaleMessage(this.m_UserLocale));
            this.generateAsyncStatus(element2, this.m_Schema.getEnumComplete());
        }
        catch (CCSPromptException cCSPromptException) {
            this.generatePromptingResponseStatus(element2, string, cCSPromptException, bl, bl2);
            this.generateAsyncStatus(element2, this.m_Schema.getEnumComplete());
        }
        catch (CCSAuthenticationException cCSAuthenticationException) {
            this.generateResponseStatus(element2, this.m_Schema.getEnumAuthError(), null);
            this.generateAsyncStatus(element2, this.m_Schema.getEnumComplete());
        }
        bIBusEnvelope.setConversationContextStatus("conversationComplete");
    }

    public void getReportInfo(Element element, BIBusEnvelope bIBusEnvelope) {
        Element element2 = bIBusEnvelope.getBody().addElement(this.m_Schema.getOutputResponseQN());
        Element element3 = element2.addElement(this.m_Schema.getOutputQN());
        ContentProvider contentProvider = null;
        String string = null;
        boolean bl = false;
        boolean bl2 = false;
        try {
            Element element4;
            string = SoapParms.getStringParm(element, "searchPath", null, false);
            bl = SoapParms.getBooleanParm(element, "generateRelativeUrl", false, true);
            bl2 = SoapParms.getBooleanParm(element, "useGatewayURI", false, true);
            if (this.m_Logger.isUserRequestLogging()) {
                element4 = new HashMap();
                element4.put("searchPath", string);
                this.m_Logger.logUserRequest("getReportInfo", (Map)element4, this.m_SessionID, this.m_RequestId);
            }
            contentProvider = ContentProvider.getProvider(string, this.m_Connection, this.m_Cookies, this);
            contentProvider.retrieveV1MetaContent(null, bl, bl2);
            element4 = element3.addElement(this.m_Schema.getReportInfoOutputQN());
            element4.addElement("ccsdatamarker");
            CCSDataResult cCSDataResult = new CCSDataResult(this.m_Transport, contentProvider);
            this.getResponder().setData(cCSDataResult);
            this.generateResponseStatus(element2, this.m_Schema.getEnumNoError(), null);
            this.generateAsyncStatus(element2, this.m_Schema.getEnumComplete());
        }
        catch (CCSGeneralException cCSGeneralException) {
            this.m_Logger.logRuntimeErrorMessage(cCSGeneralException.getUserLocaleMessage(this.m_UserLocale), "getReportInfo", this.m_SessionID, this.m_RequestId, cCSGeneralException.getSourceTrace());
            this.generateResponseStatus(element2, this.m_Schema.getEnumServerError(), cCSGeneralException.getServerLocaleMessage());
            this.generateAsyncStatus(element2, this.m_Schema.getEnumComplete());
        }
        catch (CCSAuthenticationException cCSAuthenticationException) {
            this.generateResponseStatus(element2, this.m_Schema.getEnumAuthError(), null);
            this.generateAsyncStatus(element2, this.m_Schema.getEnumComplete());
        }
        catch (CCSPromptException cCSPromptException) {
            this.generatePromptingResponseStatus(element2, string, cCSPromptException, bl, bl2);
            this.generateAsyncStatus(element2, this.m_Schema.getEnumComplete());
        }
        bIBusEnvelope.setConversationContextStatus("conversationComplete");
    }

    public String getRequestID() {
        return this.m_RequestId;
    }

    public CCSResponder getResponder() {
        return this.m_Responder;
    }

    public String getSessionID() {
        return this.m_SessionID;
    }

    public boolean isAsyncRDSRequest(MessageContext messageContext) {
        RDSSchema rDSSchema;
        Object object;
        BIBusEnvelope bIBusEnvelope = (BIBusEnvelope)messageContext.getProperty("request.envelope");
        List list = bIBusEnvelope.getBody().elements();
        if (list.size() <= 0) {
            object = new CCSGeneralException("REQUEST_ERROR", 400);
            CCSLogger.getInstance().logRuntimeErrorMessage(((CCSException)object).getServerLocaleMessage(), "unknown", null, null, null);
            rDSSchema = new Fault("", (Exception)object);
            rDSSchema.setClientFault(true);
            messageContext.setFault((Fault)rDSSchema);
        }
        if (null == (object = (Element)list.get(0))) {
            return false;
        }
        rDSSchema = RDSSchema.getInstance(Constants.NamespaceVersion.V1);
        QName qName = object.getQName();
        return qName.equals((Object)rDSSchema.getReportContentRequestQN()) || qName.equals((Object)rDSSchema.getReportInfoRequestQN()) || qName.equals((Object)rDSSchema.getGetPromptsContentQN()) || qName.equals((Object)rDSSchema.getDescribePromptsQN()) || qName.equals((Object)rDSSchema.getDrillQN()) || qName.equals((Object)rDSSchema.getUpdateIDsQN());
    }

    protected void logout(Element element, BIBusEnvelope bIBusEnvelope) {
        Element element2 = bIBusEnvelope.getBody().addElement(this.m_Schema.getLogoutResponseQN());
        try {
            if (this.m_Logger.isUserRequestLogging()) {
                this.m_Logger.logUserRequest("logout", null, this.m_SessionID, this.m_RequestId);
            }
            this.m_Connection.logoffAll();
            this.m_Connection.populateCCSBiBusFromRS(bIBusEnvelope);
            bIBusEnvelope.getSetCookieVars().detach();
            bIBusEnvelope.setSetCookie("cam_passport", "none", -1);
            this.generateResponseStatus(element2, this.m_Schema.getEnumNoError(), null);
        }
        catch (CCSGeneralException cCSGeneralException) {
            this.m_Logger.logRuntimeErrorMessage(cCSGeneralException.getServerLocaleMessage(), "logout", this.m_SessionID, this.m_RequestId, cCSGeneralException.getSourceTrace());
            this.generateResponseStatus(element2, this.m_Schema.getEnumServerError(), cCSGeneralException.getUserLocaleMessage(this.m_UserLocale));
        }
    }

    public BIBusEnvelope prepareResponse(BIBusEnvelope bIBusEnvelope, MessageContext messageContext) {
        Element element;
        Element element2 = bIBusEnvelope.getHeader().createCopy();
        Element element3 = element2.element(BIBusEnvelope.BUS_ENVIRONMENT_VARS);
        if (element3 != null) {
            element3.detach();
        }
        if ((element = element2.element(BIBusEnvelope.BUS_FORM_FIELD_VARS)) != null) {
            element.detach();
        }
        BIBusEnvelope bIBusEnvelope2 = new BIBusEnvelope(element2);
        messageContext.setResponseName("response");
        messageContext.setProperty("response.status_code", (Object)"200");
        messageContext.setProperty("response.envelope", (Object)bIBusEnvelope2);
        InternetHeaders internetHeaders = new InternetHeaders();
        internetHeaders.setHeader("Content-Type", "text/xml; charset=utf-8");
        messageContext.setProperty("response.headers", (Object)internetHeaders);
        messageContext.setProperty("response.boundary", null);
        messageContext.setProperty("response.attachments", null);
        return bIBusEnvelope2;
    }

    public BIBusEnvelope processCancel(BIBusEnvelope bIBusEnvelope, MessageContext messageContext, String string) {
        BIBusEnvelope bIBusEnvelope2 = this.prepareResponse(bIBusEnvelope, messageContext);
        Element element = bIBusEnvelope2.getBody().addElement(this.m_Schema.getCancelOuputResponseQN());
        if (BaseRDSSession.abortConversation(string)) {
            this.generateResponseStatus(element, this.m_Schema.getEnumNoError(), null);
        } else {
            this.generateResponseStatus(element, this.m_Schema.getEnumServerError(), CCLMessage.getResMessage("CANCEL_ERROR", ConfigMgr.getInstance().getServerLocale()));
            this.m_Logger.logRuntimeErrorMessage(CCLMessage.getResMessage("CANCEL_ERROR", ConfigMgr.getInstance().getServerLocale()), null, null, null, null);
        }
        bIBusEnvelope2.setConversationContextStatus("conversationComplete");
        return bIBusEnvelope2;
    }

    public BIBusEnvelope processSOAPMessage(BIBusEnvelope bIBusEnvelope, MessageContext messageContext, String string) {
        QName qName;
        Object object;
        this.m_Responder = new CCSResponder();
        messageContext.setProperty("pogo.responder", (Object)this.m_Responder);
        this.m_Cookies = BaseRDSSession.populateCookies(bIBusEnvelope, messageContext);
        this.m_SessionID = bIBusEnvelope.getPassportID();
        this.m_RequestId = bIBusEnvelope.getTrackingRequestContext();
        this.buildGatewayURL(bIBusEnvelope, messageContext);
        this.m_Responder.setTransport(this.m_Transport);
        boolean bl = false;
        if (messageContext.getFault() != null) {
            bl = true;
        }
        this.m_ContentLocale = bIBusEnvelope.getUserPreferenceValue("contentLocale");
        this.m_UserLocale = ConfigMgr.getJavaLocale(bIBusEnvelope.getUserPreferenceValue("productLocale"));
        this.startConversation(string);
        this.m_Connection.populateSDKBiBus(bIBusEnvelope);
        BIBusEnvelope bIBusEnvelope2 = this.m_Transport.prepareResponse(bIBusEnvelope, messageContext, new Namespace[]{this.m_Schema.getRdsNamespace(), this.m_Schema.getRdsContentNamespace()});
        List list = bIBusEnvelope.getBody().elements();
        if (list.size() <= 0) {
            object = new CCSGeneralException("REQUEST_ERROR", 400);
            CCSLogger.getInstance().logRuntimeErrorMessage(((CCSException)object).getServerLocaleMessage(), "unknown", null, null, null);
            qName = new Fault("", (Exception)object);
            bl = true;
            qName.setClientFault(true);
            messageContext.setFault((Fault)qName);
        }
        object = (Element)list.get(0);
        qName = object.getQName();
        if (!bl) {
            if (qName.equals((Object)this.m_Schema.getReportContentRequestQN())) {
                this.getReportContent((Element)object, bIBusEnvelope2);
            } else if (qName.equals((Object)this.m_Schema.getReportInfoRequestQN())) {
                this.getReportInfo((Element)object, bIBusEnvelope2);
            } else if (qName.equals((Object)this.m_Schema.getGetPromptsContentQN())) {
                this.getPromptsAndContent((Element)object, bIBusEnvelope2);
            } else if (qName.equals((Object)this.m_Schema.getGetPromptsQN())) {
                this.getPrompts((Element)object, bIBusEnvelope2);
            } else if (qName.equals((Object)this.m_Schema.getSetPromptsQN())) {
                this.setPrompts((Element)object, bIBusEnvelope2);
            } else if (qName.equals((Object)this.m_Schema.getDownloadFileQN())) {
                this.downloadFile((Element)object, bIBusEnvelope2);
            } else if (qName.equals((Object)this.m_Schema.getUploadFileQN())) {
                this.uploadFile((Element)object, bIBusEnvelope2);
            } else if (qName.equals((Object)this.m_Schema.getLogoutQN())) {
                this.logout((Element)object, bIBusEnvelope2);
            } else if (qName.equals((Object)this.m_Schema.getDescribePromptsQN())) {
                this.describePrompts((Element)object, bIBusEnvelope2);
            } else if (qName.equals((Object)this.m_Schema.getUpdateIDsQN())) {
                this.updateIDs((Element)object, bIBusEnvelope2);
            } else if (qName.equals((Object)this.m_Schema.getDrillQN())) {
                this.drill((Element)object, bIBusEnvelope2);
            } else if (qName.equals((Object)this.m_Schema.getReleaseRequestQN())) {
                this.release(bIBusEnvelope2, (Element)object);
            } else {
                CCSGeneralException cCSGeneralException = new CCSGeneralException("REQUEST_ERROR", 400);
                CCSLogger.getInstance().logRuntimeErrorMessage(cCSGeneralException.getServerLocaleMessage(), "unknown", null, null, null);
                Fault fault = new Fault("", (Exception)cCSGeneralException);
                fault.setClientFault(true);
                messageContext.setFault(fault);
            }
        }
        if (this.m_Logger.isSystemRequestLogging()) {
            try {
                this.m_Logger.logSystemResponse(bIBusEnvelope2.getAsString(), this.m_SessionID, this.m_RequestId);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        this.endConversation();
        return bIBusEnvelope2;
    }

    private void release(BIBusEnvelope bIBusEnvelope, Element element) {
        Element element2 = bIBusEnvelope.getBody().addElement(this.m_Schema.getReleaseOutputResponseQN());
        try {
            String string = SoapParms.getStringParm(element, "conversationID", null, false);
            ConversationCache conversationCache = this.m_Connection.conversationCache();
            Conversation conversation = conversationCache.getConversation(string);
            String string2 = (String)conversation.getProperty("searchPath");
            ContentProvider contentProvider = ContentProvider.getProvider(string2, this.m_Connection, this.m_Cookies, this);
            contentProvider.releaseConversation(conversation);
            this.generateResponseStatus(element2, this.m_Schema.getEnumNoError(), null);
        }
        catch (CCSGeneralException cCSGeneralException) {
            this.m_Logger.logRuntimeErrorMessage(cCSGeneralException.getServerLocaleMessage(), "release", this.m_SessionID, this.m_RequestId, cCSGeneralException.getSourceTrace());
            this.generateResponseStatus(element2, this.m_Schema.getEnumServerError(), cCSGeneralException.getUserLocaleMessage(this.m_UserLocale));
        }
        catch (CCSAuthenticationException cCSAuthenticationException) {
            this.generateResponseStatus(element2, this.m_Schema.getEnumAuthError(), CCLMessage.getResMessage("AUTH_ERROR", this.m_UserLocale));
        }
    }

    public BIBusEnvelope processWait(BIBusEnvelope bIBusEnvelope, MessageContext messageContext) {
        BIBusEnvelope bIBusEnvelope2 = this.prepareResponse(bIBusEnvelope, messageContext);
        Element element = bIBusEnvelope2.getBody().addElement(this.m_Schema.getOutputResponseQN());
        this.generateResponseStatus(element, this.m_Schema.getEnumNoError(), null);
        this.generateAsyncStatus(element, this.m_Schema.getEnumWorking());
        return bIBusEnvelope2;
    }

    protected void setPrompts(Element element, BIBusEnvelope bIBusEnvelope) {
        Element element2 = bIBusEnvelope.getBody().addElement(this.m_Schema.getSetPromptsResponseQN());
        try {
            Object object;
            PromptValue[] promptValueArray = SoapParms.getPromptParms(element, "promptValues", false);
            if (this.m_Logger.isUserRequestLogging()) {
                object = new HashMap();
                if (promptValueArray != null) {
                    for (int i = 0; i < promptValueArray.length; ++i) {
                        ((HashMap)object).put("promptValues[" + i + "]", Utilities.escapeXML(promptValueArray[i].toXML().asXML()));
                    }
                }
                this.m_Logger.logUserRequest("getPromptsAndContent", (Map)object, this.m_SessionID, this.m_RequestId);
            }
            object = this.m_Connection.storePromptValues(promptValueArray);
            Element element3 = element2.addElement(this.m_Schema.getPromptIDQN());
            element3.setText((String)object);
            this.generateResponseStatus(element2, this.m_Schema.getEnumNoError(), null);
        }
        catch (CCSException cCSException) {
            CCSGeneralException cCSGeneralException = new CCSGeneralException("SERVER_ERROR", cCSException, 500);
            this.m_Logger.logRuntimeErrorMessage(cCSGeneralException.getServerLocaleMessage(), "setPrompts", this.m_SessionID, this.m_RequestId, cCSGeneralException.getSourceTrace());
            this.generateResponseStatus(element2, this.m_Schema.getEnumServerError(), cCSGeneralException.getUserLocaleMessage(this.m_UserLocale));
        }
    }

    protected void updateIDs(Element element, BIBusEnvelope bIBusEnvelope) {
        Element element2 = bIBusEnvelope.getBody().addElement(this.m_Schema.getOutputResponseQN());
        Element element3 = element2.addElement(this.m_Schema.getOutputQN());
        ContentProvider contentProvider = null;
        String string = null;
        boolean bl = false;
        boolean bl2 = false;
        try {
            Object object;
            string = SoapParms.getStringParm(element, "searchPath", null, false);
            bl = SoapParms.getBooleanParm(element, "generateRelativeUrl", false, true);
            bl2 = SoapParms.getBooleanParm(element, "useGatewayURI", false, true);
            String[] stringArray = SoapParms.getStringArrayParm(element, "id", null, false);
            if (this.m_Logger.isUserRequestLogging()) {
                object = new HashMap();
                object.put("searchPath", string);
                for (int i = 0; i < stringArray.length; ++i) {
                    object.put("id[" + i + "]", stringArray[i]);
                }
                this.m_Logger.logUserRequest("updateIDs", (Map)object, this.m_SessionID, this.m_RequestId);
            }
            if (string.startsWith("http")) {
                object = string.split("\\?");
                string = this.m_Connection.lookupPPSearchPath(object[0]);
            }
            contentProvider = ContentProvider.getProvider(string, this.m_Connection, this.m_Cookies, this);
            contentProvider.upgradeIDs(string, stringArray, this, bl, bl2);
            object = new CCSDataResult(this.m_Transport, contentProvider);
            Element element4 = element3.addElement(this.m_Schema.getUpdateIDsOutputQN());
            element4.addElement("ccsdatamarker");
            this.getResponder().setData((CCSDataResult)object);
            this.generateResponseStatus(element2, this.m_Schema.getEnumNoError(), null);
        }
        catch (CCSGeneralException cCSGeneralException) {
            this.m_Logger.logRuntimeErrorMessage(cCSGeneralException.getServerLocaleMessage(), "updateIDs", this.m_SessionID, this.m_RequestId, cCSGeneralException.getSourceTrace());
            this.generateResponseStatus(element2, this.m_Schema.getEnumServerError(), cCSGeneralException.getUserLocaleMessage(this.m_UserLocale));
        }
        catch (CCSAuthenticationException cCSAuthenticationException) {
            this.generateResponseStatus(element2, this.m_Schema.getEnumAuthError(), CCLMessage.getResMessage("AUTH_ERROR", this.m_UserLocale));
        }
        catch (CCSPromptException cCSPromptException) {
            this.generatePromptingResponseStatus(element2, string, cCSPromptException, bl, bl2);
        }
        this.generateAsyncStatus(element2, this.m_Schema.getEnumComplete());
        bIBusEnvelope.setConversationContextStatus("conversationComplete");
    }

    public void drill(Element element, BIBusEnvelope bIBusEnvelope) {
        Element element2 = bIBusEnvelope.getBody().addElement(this.m_Schema.getOutputResponseQN());
        Element element3 = element2.addElement(this.m_Schema.getOutputQN());
        ContentProvider contentProvider = null;
        try {
            String string = SoapParms.getStringParm(element, "conversationId", null, false);
            String string2 = SoapParms.getStringParm(element, "contextId", null, false);
            String string3 = SoapParms.getStringParm(element, "direction", new String[]{"UP", "DOWN"}, false);
            ConversationCache conversationCache = this.m_Connection.conversationCache();
            Conversation conversation = conversationCache.getConversation(string);
            conversation.setProperty("USE_CCS_PROMPT_URL", false);
            AsynchRequest asynchRequest = Conversation.deserializeAsyncRequest(conversation, "primary");
            Filter[] filterArray = (Filter[])conversation.getProperty("filters");
            Integer n = (Integer)conversation.getProperty("rowLimit");
            String string4 = asynchRequest.getObjectPath().get_value();
            contentProvider = ContentProvider.getProvider(string4, this.m_Connection, this.m_Cookies, this);
            contentProvider.drill(string2, string, string3);
            CCSDataResult cCSDataResult = new CCSDataResult(this.m_Transport, contentProvider, filterArray, n, null);
            Element element4 = element3.addElement(this.m_Schema.getContentOutputQN());
            element4.addElement("ccsdatamarker");
            this.getResponder().setData(cCSDataResult);
            this.generateAsyncStatus(element2, this.m_Schema.getEnumComplete());
            bIBusEnvelope.setConversationContextStatus("conversationComplete");
        }
        catch (CCSGeneralException cCSGeneralException) {
            this.m_Logger.logRuntimeErrorMessage(cCSGeneralException.getServerLocaleMessage(), "drill", this.m_SessionID, this.m_RequestId, cCSGeneralException.getSourceTrace());
            this.generateResponseStatus(element2, this.m_Schema.getEnumServerError(), cCSGeneralException.getUserLocaleMessage(this.m_UserLocale));
        }
        catch (CCSAuthenticationException cCSAuthenticationException) {
            this.generateResponseStatus(element2, this.m_Schema.getEnumAuthError(), CCLMessage.getResMessage("AUTH_ERROR", this.m_UserLocale));
        }
    }

    protected void uploadFile(Element element, BIBusEnvelope bIBusEnvelope) {
        Element element2 = bIBusEnvelope.getBody().addElement(this.m_Schema.getUploadFileResponseQN());
        try {
            String string = SoapParms.getStringParm(element, "folder", null, false);
            String string2 = SoapParms.getStringParm(element, "name", null, false);
            String string3 = SoapParms.getStringParm(element, "description", null, true);
            String string4 = SoapParms.getStringParm(element, "screenTip", null, true);
            String string5 = SoapParms.getStringParm(element, "fileType", new String[]{"XLWB", "PPDeck", "WordDoc"}, false);
            byte[] byArray = SoapParms.getB64Parm(element, "fileData", false);
            if (this.m_Logger.isUserRequestLogging()) {
                HashMap<String, String> hashMap = new HashMap<String, String>();
                hashMap.put("folder", string);
                hashMap.put("name", string2);
                hashMap.put("description", string3);
                hashMap.put("screenTip", string4);
                hashMap.put("fileType", string5);
                hashMap.put("fileData", "<Base64 encoded data>");
                this.m_Logger.logUserRequest("uploadFile", hashMap, this.m_SessionID, this.m_RequestId);
            }
            this.m_Connection.uploadFile(string, string2, byArray, string3, string4, string5);
            this.generateResponseStatus(element2, this.m_Schema.getEnumNoError(), null);
        }
        catch (CCSGeneralException cCSGeneralException) {
            this.m_Logger.logRuntimeErrorMessage(cCSGeneralException.getServerLocaleMessage(), "uploadFile", this.m_SessionID, this.m_RequestId, cCSGeneralException.getSourceTrace());
            this.generateResponseStatus(element2, this.m_Schema.getEnumServerError(), cCSGeneralException.getUserLocaleMessage(this.m_UserLocale));
        }
        catch (CCSAuthenticationException cCSAuthenticationException) {
            this.generateResponseStatus(element2, this.m_Schema.getEnumAuthError(), null);
        }
    }

    @Override
    protected Cognos8Connector getConnect() {
        return this.m_Connection;
    }

    void setConnect(Cognos8Connector cognos8Connector) {
        this.m_Connection = cognos8Connector;
    }
}

