/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.ccs.service;

import com.cognos.ccs.content.ContentProvider;
import com.cognos.ccs.conversion.ldxv1.LDXV2ToV1Converter;
import com.cognos.ccs.conversion.ldxv2.LDXV3ToV2Converter;
import com.cognos.ccs.conversion.upgrade.ldxv3.LDXV2ToV3Converter;
import com.cognos.ccs.exceptions.CCSGeneralException;
import com.cognos.ccs.filter.ContextFilter;
import com.cognos.ccs.filter.Filter;
import com.cognos.ccs.filter.XPathFilter;
import com.cognos.ccs.filter.appenders.AppenderList;
import com.cognos.ccs.filter.ldx.LDXFilterHandler;
import com.cognos.ccs.formats.APostProcessor;
import com.cognos.ccs.formats.CCSFormatter;
import com.cognos.ccs.fsm.LdxHandler;
import com.cognos.ccs.service.CCSLogger;
import com.cognos.ccs.service.Cognos8Connector;
import com.cognos.ccs.service.ConfigMgr;
import com.cognos.ccs.service.Conversation;
import com.cognos.ccs.service.GovernedInputStream;
import com.cognos.ccs.service.ManagedAttachment;
import com.cognos.ccs.transports.Transport;
import com.cognos.ccs.utility.SAXParserFactoryWrapper;
import com.ibm.cognos.ccs.internal.utility.Constants;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import org.apache.commons.io.ByteOrderMark;
import org.apache.commons.io.input.BOMInputStream;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class CCSDataResult {
    protected Filter[] m_Filters;
    protected ContentProvider m_Content;
    protected Transport m_Transport;
    protected int m_RowLimit = 0;
    protected boolean m_NonLDX;
    private boolean m_isCSV;
    protected CCSFormatter m_Format;
    public Cognos8Connector connect;
    public Conversation conv;
    protected boolean m_RequiresDowngrade = false;
    protected Constants.Compatibility m_Compatability = Constants.Compatibility.C8_4_1;
    protected AppenderList m_appenders;
    protected ArrayList<String> m_secondaryCommands = null;
    protected String m_simpleNamespace = null;
    protected Constants.Compatibility m_UpgradeCompatability = null;
    private String m_charset = null;
    private static final List<String> m_UTFcharsets = Arrays.asList("UTF-16BE", "UTF-16LE", "UTF-32BE", "UTF-32LE");

    public void setContentProvider(ContentProvider contentProvider) {
        this.m_Content = contentProvider;
    }

    public void setTransport(Transport transport) {
        this.m_Transport = transport;
    }

    public void setFilters(Filter[] filterArray) {
        this.m_Filters = filterArray;
    }

    public void setRowLimit(int n) {
        this.m_RowLimit = n;
    }

    public void setNotLDXStream() {
        this.m_NonLDX = true;
    }

    public void setIsCSV() {
        this.m_isCSV = true;
    }

    public void setDowngrade(Constants.Compatibility compatibility) {
        if (compatibility != Constants.Compatibility.C10_3) {
            this.m_RequiresDowngrade = true;
            this.m_Compatability = compatibility;
        }
    }

    public void setUpgrade(Constants.Compatibility compatibility) {
        this.m_UpgradeCompatability = Constants.Compatibility.C10_3;
    }

    public void setSimpleNamespace(String string) {
        this.m_simpleNamespace = string;
    }

    public void setCharset(String string) {
        this.m_charset = string;
    }

    public void setSecondaryCommands(ArrayList<String> arrayList) {
        this.m_secondaryCommands = arrayList;
    }

    public CCSDataResult(Transport transport, ContentProvider contentProvider) {
        this.m_Transport = transport;
        this.m_Content = contentProvider;
        this.m_Filters = null;
        this.m_RowLimit = 0;
        this.m_NonLDX = true;
        this.m_appenders = new AppenderList();
    }

    public CCSDataResult(Transport transport, ContentProvider contentProvider, Filter[] filterArray, int n, CCSFormatter cCSFormatter) {
        this(transport, contentProvider, filterArray, n, cCSFormatter, new AppenderList());
    }

    public CCSDataResult(Transport transport, ContentProvider contentProvider, Filter[] filterArray, int n, CCSFormatter cCSFormatter, AppenderList appenderList) {
        this.m_Transport = transport;
        this.m_Content = contentProvider;
        this.m_Filters = filterArray;
        this.m_RowLimit = n;
        this.m_NonLDX = false;
        this.m_Format = cCSFormatter;
        this.m_appenders = appenderList;
    }

    public Transport getTransport() {
        return this.m_Transport;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeResultToStream(OutputStream outputStream) throws IOException {
        Object object = CCSLogger.getInstance().startTimer(0, "execute", "CCSDataResult:writeResultToStream - post-processing/transformation, output to dispatcher", null);
        try {
            this.preprocess();
            InputStream[] inputStreamArray = this.m_Content.getInputStreams();
            for (int i = 0; i < inputStreamArray.length; ++i) {
                InputStream inputStream = inputStreamArray[0];
                long l = ConfigMgr.getInstance().getDataLimit();
                if (this.m_isCSV) {
                    this.handleCSV(outputStream, inputStream);
                } else if (this.m_NonLDX) {
                    inputStream = new GovernedInputStream(null, l, inputStream);
                    this.copyStreamToOutput(outputStream, inputStream);
                } else {
                    inputStream = new GovernedInputStream(null, l, inputStream);
                    this.processLDX(outputStream, inputStream);
                }
                inputStream.close();
            }
        }
        catch (CCSGeneralException cCSGeneralException) {
            CCSLogger.getInstance().logRuntimeErrorMessage(cCSGeneralException.getServerLocaleMessage(), null, null, null, cCSGeneralException.getSourceTrace());
            cCSGeneralException.printStackTrace();
        }
        finally {
            ManagedAttachment managedAttachment = this.m_Content.getAttachment();
            if (managedAttachment != null) {
                managedAttachment.delete();
            }
            CCSLogger.getInstance().stopTimer(object);
        }
    }

    private void processLDX(OutputStream outputStream, InputStream inputStream) throws IOException {
        Object object;
        OutputStream outputStream2;
        Object object2;
        Object object3;
        Object object4;
        Object object5 = CCSLogger.getInstance().startTimer(0, "execute", "CCSDataResult:processLDX - post-processing/transformation, output to dispatcher", null);
        if (this.m_Format != null) {
            if (this.m_Format.getConversation() == null) {
                this.m_Format.setConversation(this.conv);
            }
            if (this.m_Format.getConnector() == null) {
                this.m_Format.setConnector(this.connect);
            }
        }
        if (this.m_Format == null && !this.m_RequiresDowngrade && this.m_UpgradeCompatability == null) {
            ContentHandler contentHandler = null;
            contentHandler = this.getFilterHandler(outputStream, "http://www.ibm.com/xmlns/prod/cognos/layoutData/201310");
            try {
                SAXParser sAXParser = SAXParserFactoryWrapper.getParser();
                sAXParser.parse(new InputSource(inputStream), (DefaultHandler)contentHandler);
            }
            catch (ParserConfigurationException parserConfigurationException) {
                CCSGeneralException cCSGeneralException = new CCSGeneralException("PARSE_STREAM_ERROR", parserConfigurationException, 500);
                CCSLogger.getInstance().logRuntimeErrorMessage(cCSGeneralException.getServerLocaleMessage(), null, null, null, cCSGeneralException.getSourceTrace());
            }
            catch (SAXException sAXException) {
                CCSGeneralException cCSGeneralException = new CCSGeneralException("PARSE_STREAM_ERROR", sAXException, 500);
                CCSLogger.getInstance().logRuntimeErrorMessage(cCSGeneralException.getServerLocaleMessage(), null, null, null, cCSGeneralException.getSourceTrace());
            }
            return;
        }
        ProcessingThread processingThread = null;
        PipedOutputStream pipedOutputStream = null;
        if (this.m_UpgradeCompatability != null) {
            pipedOutputStream = new PipedOutputStream();
            object4 = new LDXV2ToV3Converter(this.m_UpgradeCompatability);
            ((LdxHandler)object4).setOutStream(pipedOutputStream);
            processingThread = new ProcessingThread((ContentHandler)object4, inputStream);
        }
        object4 = null;
        PipedOutputStream pipedOutputStream2 = null;
        if (this.m_RequiresDowngrade) {
            pipedOutputStream2 = new PipedOutputStream();
            object3 = new LDXV3ToV2Converter(Constants.Compatibility.C10_1);
            ((LdxHandler)object3).setOutStream(pipedOutputStream2);
            object4 = new ProcessingThread((ContentHandler)object3, pipedOutputStream != null ? new PipedInputStream(pipedOutputStream) : inputStream);
        }
        object3 = null;
        PipedOutputStream pipedOutputStream3 = null;
        if (this.m_RequiresDowngrade && this.m_Compatability != Constants.Compatibility.C10_1) {
            pipedOutputStream3 = new PipedOutputStream();
            object2 = new LDXV2ToV1Converter(this.m_Compatability);
            ((LdxHandler)object2).setOutStream(pipedOutputStream3);
            object3 = new ProcessingThread((ContentHandler)object2, pipedOutputStream2 != null ? new PipedInputStream(pipedOutputStream2) : inputStream);
        }
        object2 = pipedOutputStream3 != null ? new PipedInputStream(pipedOutputStream3) : (pipedOutputStream2 != null ? new PipedInputStream(pipedOutputStream2) : (pipedOutputStream != null ? new PipedInputStream(pipedOutputStream) : inputStream));
        ContentHandler contentHandler = null;
        PipedOutputStream pipedOutputStream4 = this.m_Format != null ? new PipedOutputStream() : null;
        OutputStream outputStream3 = outputStream2 = this.m_Format != null ? pipedOutputStream4 : outputStream;
        contentHandler = this.m_simpleNamespace != null ? this.getFilterHandler(outputStream2, this.m_simpleNamespace) : (!this.m_RequiresDowngrade ? this.getFilterHandler(outputStream2, "http://www.ibm.com/xmlns/prod/cognos/layoutData/201310") : (this.m_Compatability == Constants.Compatibility.C8_4_OEM ? this.getFilterHandler(outputStream2, "http://developer.cognos.com/schemas/rds/contentmodel/1") : this.getFilterHandler(outputStream2, "http://www.ibm.com/xmlns/prod/cognos/layoutData/200904")));
        ProcessingThread processingThread2 = new ProcessingThread(contentHandler, (InputStream)object2);
        Thread thread = null;
        PipedOutputStream pipedOutputStream5 = null;
        if (this.m_Format != null) {
            object = new PipedInputStream(pipedOutputStream4);
            if (this.m_Format.getPostProcessor() != null) {
                pipedOutputStream5 = new PipedOutputStream();
                this.m_Format.setOutStream(pipedOutputStream5);
            } else {
                this.m_Format.setOutStream(outputStream);
            }
            thread = new ProcessingThread(this.m_Format, (InputStream)object);
        }
        if (processingThread != null) {
            processingThread.start();
        }
        if (object4 != null) {
            ((Thread)object4).start();
        }
        if (object3 != null) {
            ((Thread)object3).start();
        }
        processingThread2.start();
        if (thread != null) {
            thread.start();
        }
        if (this.m_Format != null && this.m_Format.getPostProcessor() != null) {
            object = this.m_Format.getPostProcessor();
            ((APostProcessor)object).setInputStream(new PipedInputStream(pipedOutputStream5));
            ((APostProcessor)object).setOutputStream(outputStream);
            ((APostProcessor)object).process(this.m_Format.getWidth(), this.m_Format.getHeight(), this.m_Format.getSOAPEncode(), this.m_Format.getConversation());
            outputStream.flush();
        } else {
            Object object6 = object = thread != null ? thread : processingThread2;
            while (((Thread)object).isAlive()) {
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException interruptedException) {
                    interruptedException.printStackTrace();
                }
            }
        }
        CCSLogger.getInstance().stopTimer(object5);
    }

    private ContentHandler getFilterHandler(OutputStream outputStream, String string) {
        if (this.m_Filters != null && this.m_Filters.length > 0 && this.m_Filters.length > 0) {
            if (this.m_Filters[0] instanceof ContextFilter) {
                ContextFilter contextFilter = (ContextFilter)this.m_Filters[0];
                return contextFilter.buildFilterHandler(this.m_Filters, outputStream, false, this.m_RowLimit, this.m_Content.getVersionBase(), string);
            }
            if (this.m_Filters[0] instanceof XPathFilter) {
                XPathFilter xPathFilter = (XPathFilter)this.m_Filters[0];
                return xPathFilter.buildFilterHandler(this.m_Filters, outputStream, false, this.m_RowLimit, this.m_Content.getVersionBase(), string);
            }
        }
        LDXFilterHandler lDXFilterHandler = new LDXFilterHandler(string);
        lDXFilterHandler.setupFilters(this.m_Filters);
        lDXFilterHandler.setOutStream(outputStream);
        lDXFilterHandler.setRowLimit(this.m_RowLimit);
        lDXFilterHandler.setVersionBase(this.m_Content.getVersionBase());
        lDXFilterHandler.setAppenders(this.m_appenders);
        if (this.m_Compatability != Constants.Compatibility.C8_4_OEM) {
            lDXFilterHandler.setSecondaryCommands(this.m_secondaryCommands);
        }
        lDXFilterHandler.setConversation(this.conv);
        return lDXFilterHandler;
    }

    public Cognos8Connector getConnector() {
        return this.connect;
    }

    public Conversation getConversation() {
        return this.conv;
    }

    public void setConversation(Cognos8Connector cognos8Connector, Conversation conversation) {
        this.connect = cognos8Connector;
        this.conv = conversation;
    }

    private void preprocess() {
        try {
            if (this.m_Format == null) {
                return;
            }
            CCSFormatter cCSFormatter = this.m_Format.getPreProcessor();
            if (cCSFormatter != null) {
                InputStream[] inputStreamArray = this.m_Content.getInputStreams();
                SAXParser sAXParser = SAXParserFactoryWrapper.getParser();
                for (int i = 0; i < inputStreamArray.length; ++i) {
                    sAXParser.parse(new InputSource(inputStreamArray[i]), (DefaultHandler)cCSFormatter);
                }
            }
        }
        catch (Exception exception) {
            CCSGeneralException cCSGeneralException = new CCSGeneralException("PARSE_STREAM_ERROR", exception, 500);
            CCSLogger.getInstance().logRuntimeErrorMessage(cCSGeneralException.getServerLocaleMessage(), null, null, null, cCSGeneralException.getSourceTrace());
            exception.printStackTrace();
        }
    }

    private void handleCSV(OutputStream outputStream, InputStream inputStream) throws IOException {
        if (this.m_charset == null || "UTF-8".equalsIgnoreCase(this.m_charset)) {
            this.copyStreamToOutput(outputStream, inputStream);
        } else {
            this.convertToUTF8AndCopyToOutput(outputStream, inputStream);
        }
    }

    private void copyStreamToOutput(OutputStream outputStream, InputStream inputStream) throws IOException {
        byte[] byArray = new byte[4096];
        BufferedInputStream bufferedInputStream = new BufferedInputStream(inputStream);
        BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(outputStream);
        int n = 0;
        while ((n = bufferedInputStream.read(byArray, 0, 4096)) != -1) {
            bufferedOutputStream.write(byArray, 0, n);
        }
        bufferedOutputStream.flush();
    }

    private void convertToUTF8AndCopyToOutput(OutputStream outputStream, InputStream inputStream) throws IOException {
        InputStreamReader inputStreamReader;
        char[] cArray = new char[4096];
        BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(outputStream);
        if (this.m_charset != null && m_UTFcharsets.contains(this.m_charset)) {
            inputStream = new BOMInputStream(inputStream, false, new ByteOrderMark[]{ByteOrderMark.UTF_8, ByteOrderMark.UTF_16BE, ByteOrderMark.UTF_16LE, ByteOrderMark.UTF_32BE, ByteOrderMark.UTF_32LE});
        }
        try {
            inputStreamReader = new InputStreamReader(inputStream, this.m_charset);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            CCSGeneralException cCSGeneralException = new CCSGeneralException("PARSE_STREAM_ERROR", unsupportedEncodingException, 500);
            CCSLogger.getInstance().logRuntimeErrorMessage(cCSGeneralException.getServerLocaleMessage(), null, null, null, cCSGeneralException.getSourceTrace());
            unsupportedEncodingException.printStackTrace();
            throw unsupportedEncodingException;
        }
        BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
        int n = 0;
        while ((n = bufferedReader.read(cArray, 0, 4096)) != -1) {
            byte[] byArray = new String(cArray, 0, n).getBytes("UTF-8");
            bufferedOutputStream.write(byArray, 0, byArray.length);
        }
        bufferedOutputStream.flush();
    }

    public class ProcessingThread
    extends Thread {
        ContentHandler m_SAXHandler;
        InputStream m_Input;

        ProcessingThread(ContentHandler contentHandler, InputStream inputStream) {
            this.m_Input = inputStream;
            this.m_SAXHandler = contentHandler;
        }

        @Override
        public void run() {
            try {
                SAXParser sAXParser = SAXParserFactoryWrapper.getParser();
                sAXParser.parse(new InputSource(this.m_Input), (DefaultHandler)this.m_SAXHandler);
            }
            catch (Exception exception) {
                CCSGeneralException cCSGeneralException = new CCSGeneralException("PARSE_STREAM_ERROR", exception, 500);
                CCSLogger.getInstance().logRuntimeErrorMessage(cCSGeneralException.getServerLocaleMessage(), null, null, null, cCSGeneralException.getSourceTrace());
                exception.printStackTrace();
            }
        }
    }
}

