/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.ccs.service;

import com.cognos.cclcfgapi.ICCLConfiguration;
import com.cognos.ccs.service.ThreadLocalPropertyManager;
import com.cognos.ccs.utility.LogUtilities;
import com.cognos.indications.LogAuditAccessIndication;
import com.cognos.indications.LogAuditIndication;
import com.cognos.indications.LogPerfIndication;
import com.cognos.indications.LogResourceCounterSet;
import com.cognos.indications.LogTypedLogger;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.ResourceBundle;
import java.util.StringTokenizer;

public class CCSLogger {
    public static final int LEVEL1 = 0;
    public static final int LEVEL2 = 1;
    public static final int LEVEL3 = 2;
    public static final int LEVEL4 = 3;
    public static final int LEVEL5 = 4;
    static CCSLogger m_Logger;
    private LogTypedLogger ccsAuditLog = LogTypedLogger.getInstanceBe((String)"Audit.CCS", LogAuditIndication.class);
    private LogTypedLogger ccsAuditRequestLog = LogTypedLogger.getInstanceBe((String)"Audit.CCS.Request", LogAuditIndication.class);
    private LogTypedLogger ccsPerfLogger = LogTypedLogger.getInstance((String)"Perf.CCS", LogPerfIndication.class);
    public static final String SUCCESS = "Success";
    public static final String FAILURE = "Failure";
    public static final String WARNING = "Warning";
    public static final String INFO = "Info";
    private int m_iMajorVersion = 0;
    protected static final String COMPONENT = "CCS";
    public static final String REQUEST_ID = "requestId";
    public static final String SESSION_ID = "sessionId";

    private CCSLogger() {
        try {
            String string = ResourceBundle.getBundle("version").getString("Version");
            if (string != null) {
                try {
                    StringTokenizer stringTokenizer = new StringTokenizer(string, ".");
                    stringTokenizer.nextToken();
                    stringTokenizer.nextToken();
                    String string2 = stringTokenizer.nextToken();
                    this.m_iMajorVersion = Integer.parseInt(string2);
                }
                catch (NoSuchElementException noSuchElementException) {
                }
                catch (NumberFormatException numberFormatException) {}
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void logRuntimeErrorMessage(String string, String string2, String string3, String string4, String string5) {
        LogAuditAccessIndication logAuditAccessIndication = new LogAuditAccessIndication(COMPONENT, this.m_iMajorVersion);
        if (this.ccsAuditLog != null && this.ccsAuditLog.isEnabled(50000)) {
            logAuditAccessIndication.setLevel(50000);
            logAuditAccessIndication.setStatus(FAILURE);
            logAuditAccessIndication.setObjectType("reportDataService");
            if (string3 != null) {
                logAuditAccessIndication.setSessionID(string3);
            }
            if (string4 != null) {
                logAuditAccessIndication.setRequestID(string4);
            }
            logAuditAccessIndication.setOperation(string2);
            logAuditAccessIndication.setErrorMessage(this.formatErrorMessage(string));
            logAuditAccessIndication.setLogData(this.formatStackTrace(string5));
            this.ccsAuditLog.log((Object)logAuditAccessIndication);
        }
    }

    public void logRuntimeWarning(String string, String string2, String string3, String string4, String string5) {
        LogAuditAccessIndication logAuditAccessIndication = new LogAuditAccessIndication(COMPONENT, this.m_iMajorVersion);
        if (this.ccsAuditLog != null && this.ccsAuditLog.isEnabled(40000)) {
            logAuditAccessIndication.setLevel(40000);
            logAuditAccessIndication.setStatus(FAILURE);
            logAuditAccessIndication.setObjectType("reportDataService");
            if (string3 != null) {
                logAuditAccessIndication.setSessionID(string3);
            }
            if (string4 != null) {
                logAuditAccessIndication.setRequestID(string4);
            }
            logAuditAccessIndication.setOperation(string2);
            logAuditAccessIndication.setErrorMessage(this.formatErrorMessage(string));
            logAuditAccessIndication.setLogData(this.formatStackTrace(string5));
            this.ccsAuditLog.log((Object)logAuditAccessIndication);
        }
    }

    public boolean isUserRequestLogging() {
        return this.ccsAuditLog != null && this.ccsAuditLog.isEnabled(30000);
    }

    public void logUserRequest(String string, Map map, String string2, String string3) {
        LogAuditAccessIndication logAuditAccessIndication = new LogAuditAccessIndication(COMPONENT, this.m_iMajorVersion);
        if (this.isUserRequestLogging()) {
            logAuditAccessIndication.setLevel(30000);
            logAuditAccessIndication.setStatus(SUCCESS);
            logAuditAccessIndication.setObjectType("reportDataService");
            if (string2 != null) {
                logAuditAccessIndication.setSessionID(string2);
            }
            if (string3 != null) {
                logAuditAccessIndication.setRequestID(string3);
            }
            logAuditAccessIndication.setOperation(string);
            if (map != null) {
                logAuditAccessIndication.setLogData(this.formatParameters(map));
            }
            this.ccsAuditLog.log((Object)logAuditAccessIndication);
        }
    }

    public boolean isSystemRequestLogging() {
        return this.ccsAuditRequestLog != null && this.ccsAuditRequestLog.isEnabled(20000);
    }

    public void logSystemRequest(String string, String string2, String string3) {
        if (this.isSystemRequestLogging()) {
            LogAuditIndication logAuditIndication = new LogAuditIndication(COMPONENT, this.m_iMajorVersion);
            logAuditIndication.setLevel(20000);
            logAuditIndication.setOperation("Request");
            logAuditIndication.setSessionID(string2);
            logAuditIndication.setRequestID(string3);
            StringBuffer stringBuffer = new StringBuffer(string);
            stringBuffer.insert(0, "<request>");
            stringBuffer.append("</request>");
            int n = stringBuffer.toString().indexOf("<?");
            int n2 = stringBuffer.toString().indexOf("?>");
            if (n > -1 && n2 > -1) {
                stringBuffer.delete(n, n2 + 2);
            }
            logAuditIndication.setLogData(stringBuffer.toString());
            this.ccsAuditRequestLog.log((Object)logAuditIndication);
        }
    }

    public void logSystemResponse(String string, String string2, String string3) {
        if (this.isSystemRequestLogging()) {
            LogAuditIndication logAuditIndication = new LogAuditIndication(COMPONENT, this.m_iMajorVersion);
            logAuditIndication.setLevel(20000);
            logAuditIndication.setOperation("Response");
            logAuditIndication.setSessionID(string2);
            logAuditIndication.setRequestID(string3);
            logAuditIndication.setLogData(string);
            StringBuffer stringBuffer = new StringBuffer(string);
            stringBuffer.insert(0, "<response>");
            stringBuffer.append("</response>");
            int n = stringBuffer.toString().indexOf("<?");
            int n2 = stringBuffer.toString().indexOf("?>");
            stringBuffer.delete(n, n2 + 2);
            logAuditIndication.setLogData(stringBuffer.toString());
            this.ccsAuditRequestLog.log((Object)logAuditIndication);
        }
    }

    private String formatParameters(Map map) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<parameters>");
        for (String string : map.keySet()) {
            String string2 = (String)map.get(string);
            if (string == null || string2 == null) continue;
            stringBuffer.append("<item name=\"");
            stringBuffer.append(string);
            stringBuffer.append("\">");
            stringBuffer.append("<![CDATA[");
            stringBuffer.append(string2);
            stringBuffer.append("]]></item>");
        }
        stringBuffer.append("</parameters>");
        return stringBuffer.toString();
    }

    private String formatErrorMessage(String string) {
        if (string == null) {
            return "";
        }
        String string2 = "<messages><message><messageString>" + string + "</messageString></message>";
        return string2;
    }

    private String formatStackTrace(String string) {
        String string2 = "<trace>" + string + "</trace>";
        string2 = string2.replace('\n', ' ');
        return string2;
    }

    public static CCSLogger getInstance() {
        if (m_Logger == null) {
            m_Logger = new CCSLogger();
        }
        return m_Logger;
    }

    public void logMobileUserRequest(String string, ICCLConfiguration iCCLConfiguration, Object ... objectArray) {
        LogAuditAccessIndication logAuditAccessIndication = new LogAuditAccessIndication(COMPONENT, this.m_iMajorVersion);
        if (this.isUserRequestLogging()) {
            logAuditAccessIndication.setLevel(30000);
            logAuditAccessIndication.setStatus(SUCCESS);
            logAuditAccessIndication.setObjectType("reportDataService");
            logAuditAccessIndication.setOperation(string);
            String string2 = "<parameters>\n";
            string2 = iCCLConfiguration != null ? string2 + LogUtilities.objectAsXML(iCCLConfiguration) : string2 + "<configuration type=\"ICCLConfiguration\" value=\"null\" />\n";
            string2 = string2 + this.argsAsXML(objectArray) + "</parameters>\n";
            logAuditAccessIndication.setLogData(string2);
            this.ccsAuditLog.log((Object)logAuditAccessIndication);
        }
    }

    protected String argsAsXML(Object ... objectArray) {
        String string = "";
        for (Object object : objectArray) {
            string = string + LogUtilities.objectAsXML(object);
        }
        return string;
    }

    public void setRequestId(String string) {
        ThreadLocalPropertyManager.set(REQUEST_ID, string);
    }

    public void setSessionId(String string) {
        ThreadLocalPropertyManager.set(SESSION_ID, string);
    }

    public String getRequestId() {
        return (String)ThreadLocalPropertyManager.get(REQUEST_ID);
    }

    public String getSessionId() {
        return (String)ThreadLocalPropertyManager.get(SESSION_ID);
    }

    public boolean isPerfLevelEnabled(int n) {
        return this.ccsPerfLogger != null && this.ccsPerfLogger.isEnabled(this.getIPFLevel(n));
    }

    public Object startTimer(int n, String string, String string2, Object object) {
        if (this.ccsPerfLogger == null) {
            return null;
        }
        if (!this.isPerfLevelEnabled(n)) {
            return null;
        }
        LogResourceCounterSet logResourceCounterSet = new LogResourceCounterSet("Execution", null);
        LogPerfIndication logPerfIndication = new LogPerfIndication(COMPONENT, 0, logResourceCounterSet);
        logPerfIndication.setLevel(this.getIPFLevel(n));
        logPerfIndication.setClassId(COMPONENT);
        logPerfIndication.setMethodId(string);
        logPerfIndication.setLogData(string2);
        logPerfIndication.setStatus("START");
        logPerfIndication.setTime(System.currentTimeMillis());
        logPerfIndication.setRequestID((String)ThreadLocalPropertyManager.get(REQUEST_ID));
        logPerfIndication.setSessionID((String)ThreadLocalPropertyManager.get(SESSION_ID));
        this.ccsPerfLogger.log((Object)logPerfIndication);
        logResourceCounterSet.enableResourceCounter();
        return logPerfIndication;
    }

    public void stopTimer(Object object) {
        if (this.ccsPerfLogger != null && object != null && object instanceof LogPerfIndication) {
            LogPerfIndication logPerfIndication = (LogPerfIndication)object;
            logPerfIndication.getRCS().disableResourceCounter();
            logPerfIndication.setStatus("FINISH");
            logPerfIndication.setTime(System.currentTimeMillis());
            this.ccsPerfLogger.log((Object)logPerfIndication);
        }
    }

    private int getIPFLevel(int n) {
        switch (n) {
            case 0: {
                return 50000;
            }
            case 1: {
                return 40000;
            }
            case 2: {
                return 30000;
            }
            case 3: {
                return 20000;
            }
            case 4: {
                return 10000;
            }
        }
        return 10000;
    }
}

