/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.ccs.service;

import com.cognos.ccs.service.CCSDataResult;
import com.cognos.ccs.transports.SOAPTransport;
import com.cognos.ccs.transports.Transport;
import com.cognos.pogo.bibus.CryptoFacility;
import com.cognos.pogo.pdk.BIBusEnvelope;
import com.cognos.pogo.pdk.SOAPXMLSource;
import com.cognos.pogo.util.Check;
import com.cognos.pogo.util.StringUtils;
import java.io.BufferedOutputStream;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.util.Enumeration;
import java.util.Iterator;
import javax.mail.MessagingException;
import javax.mail.internet.InternetHeaders;
import org.apache.log.Hierarchy;
import org.apache.log.Logger;

public class CCSOutputter {
    protected CCSDataResult m_Result = null;
    protected String m_Buffer = null;
    protected Transport m_Transport = null;
    protected static final String START_CDATA = "<![CDATA[";
    protected static final String END_CDATA = "]]>";
    private String mimeBoundary;
    private String mimeStartPartContentID = null;
    private static final String CONTENT_TYPE = "Content-Type: ";
    private static final String CONTENT_LENGTH = "Content-Length: ";
    private static final String LOCATION = "Location:";
    private static final String UTF8 = "utf-8";
    private static final String TEXT_XML = "text/xml";
    private static final String TEXT_XML_CONTENT_TYPE = "text/xml; charset=utf-8";
    private static final String MULTI_PART_RELATED_TEXT_XML = "multipart/related; type=\"text/xml\"";
    private static final String MULTI_PART_CONTENT_TYPE = "multipart/related; type=\"text/xml\"; boundary=\"";
    private static final String MULTI_PART_CONTENT_TYPE_P1 = "multipart/related; type=\"text/xml\"; start=\"";
    private static final String MULTI_PART_CONTENT_TYPE_P2 = "; boundary=\"";
    private static final String MULTI_PART_BYTERANGES_CONTENT_TYPE = "multipart/byteranges; boundary=";
    private static final String MULTI_PART_BYTERANGES_CONTENT_TYPE_P1 = "multipart/byteranges; start=";
    private static final String MULTI_PART_BYTERANGES_CONTENT_TYPE_P2 = "; boundary=";
    private static final byte[] baCONTENT_TYPE_TEXTXML = "Content-Type: text/xml; charset=utf-8\r\n".getBytes();
    private static final byte[] baCONTENTID_SP = "Content-ID: ".getBytes();
    private static final byte[] CRLF = "\r\n".getBytes();
    private boolean doTrustedRequest = false;
    private String locationHeader = null;
    private static final Logger cat = Hierarchy.getDefaultHierarchy().getLoggerFor(CCSOutputter.class.getName());
    private SOAPXMLSource anEnvelope;
    private Iterator soapAttachments;
    private OutputStream outStream;
    private Outputter myOutputter;
    private String serviceID;

    public CCSOutputter(SOAPXMLSource sOAPXMLSource, CCSDataResult cCSDataResult, OutputStream outputStream, Transport transport, String string, boolean bl) {
        this.anEnvelope = sOAPXMLSource;
        this.m_Result = cCSDataResult;
        this.setOutputStream(outputStream);
        this.myOutputter = bl ? new MultipartOutputter() : new SimpleOutputter();
        this.m_Buffer = string;
        this.m_Transport = transport;
    }

    public void setLocation(String string) {
        this.locationHeader = string;
    }

    public void setOutputStream(OutputStream outputStream) {
        this.outStream = outputStream != null ? new BufferedOutputStream(outputStream, 8192) : null;
    }

    public void write() throws IOException {
        Check.notNull((Object)this.outStream);
        try {
            this.myOutputter.write();
            this.outStream.flush();
        }
        catch (IOException iOException) {
            if (this.soapAttachments != null) {
                while (this.soapAttachments.hasNext()) {
                    InputStream inputStream = (InputStream)this.soapAttachments.next();
                    try {
                        inputStream.close();
                    }
                    catch (IOException iOException2) {}
                }
            }
            throw iOException;
        }
    }

    public String getContentType() {
        return this.myOutputter.getContentType();
    }

    public boolean canResend() {
        return this.myOutputter.canResend();
    }

    private String getMimeBoundary() {
        if (this.mimeBoundary == null) {
            this.mimeBoundary = StringUtils.getUniqueValue();
        }
        return this.mimeBoundary;
    }

    private void writeRESTOutput() throws UnsupportedEncodingException, IOException {
        if (this.m_Buffer != null) {
            BufferedWriter bufferedWriter = new BufferedWriter(new OutputStreamWriter(this.outStream, "UTF-8"));
            bufferedWriter.write(this.m_Buffer.toString());
            bufferedWriter.flush();
        } else {
            BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(this.outStream, 8096);
            this.m_Result.writeResultToStream(bufferedOutputStream);
            bufferedOutputStream.flush();
        }
    }

    public class MultipartByterangeOutputter
    extends MultipartOutputter {
        @Override
        protected String getContentType() {
            if (CCSOutputter.this.mimeStartPartContentID == null) {
                return CCSOutputter.MULTI_PART_BYTERANGES_CONTENT_TYPE + CCSOutputter.this.getMimeBoundary();
            }
            return CCSOutputter.MULTI_PART_BYTERANGES_CONTENT_TYPE_P1 + CCSOutputter.this.mimeStartPartContentID + CCSOutputter.MULTI_PART_BYTERANGES_CONTENT_TYPE_P2 + CCSOutputter.this.getMimeBoundary();
        }

        @Override
        protected void writeAttachments(byte[] byArray) throws IOException {
            byte[] byArray2 = new byte[8192];
            int n = 0;
            while (CCSOutputter.this.soapAttachments.hasNext()) {
                int n2 = 0;
                if (cat.isDebugEnabled()) {
                    cat.debug("Writing attachment number " + ++n);
                }
                InputStream inputStream = (InputStream)CCSOutputter.this.soapAttachments.next();
                try {
                    CCSOutputter.this.outStream.write(byArray);
                    InternetHeaders internetHeaders = new InternetHeaders(inputStream);
                    this.removeAcrobatReaderBarfHeaders(internetHeaders);
                    Enumeration enumeration = internetHeaders.getAllHeaderLines();
                    while (enumeration.hasMoreElements()) {
                        String string = (String)enumeration.nextElement();
                        CCSOutputter.this.outStream.write(string.getBytes());
                        CCSOutputter.this.outStream.write("\r\n".getBytes());
                    }
                    CCSOutputter.this.outStream.write("\r\n".getBytes());
                }
                catch (MessagingException messagingException) {
                    cat.error("Trouble removing headers from multipart byterange part");
                }
                catch (IOException iOException) {
                    inputStream.close();
                    throw iOException;
                }
                try {
                    int n3 = inputStream.read(byArray2, 0, 8192);
                    while (n3 > 0) {
                        CCSOutputter.this.outStream.write(byArray2, 0, n3);
                        n2 += n3;
                        n3 = inputStream.read(byArray2, 0, 8192);
                    }
                }
                catch (IOException iOException) {
                    inputStream.close();
                    throw iOException;
                }
                if (!cat.isDebugEnabled()) continue;
                cat.debug("Wrote attachment " + n + " of size: " + n2);
            }
        }

        private void removeAcrobatReaderBarfHeaders(InternetHeaders internetHeaders) {
            internetHeaders.removeHeader("Content-Length");
            internetHeaders.removeHeader("Content-Transfer-Encoding");
            internetHeaders.removeHeader("Content-ID");
            internetHeaders.removeHeader("Accept-Ranges");
        }
    }

    private class MultipartOutputter
    extends Outputter {
        public String messageContentType;

        private MultipartOutputter() {
            this.messageContentType = "text/xml; charset=UTF-8";
        }

        private void writeSOAPPart(byte[] byArray) throws IOException, UnsupportedEncodingException {
            CCSOutputter.this.outStream.write(byArray);
            CCSOutputter.this.outStream.write(baCONTENT_TYPE_TEXTXML);
            if (CCSOutputter.this.mimeStartPartContentID != null) {
                CCSOutputter.this.outStream.write(baCONTENTID_SP);
                CCSOutputter.this.outStream.write(CCSOutputter.this.mimeStartPartContentID.getBytes(CCSOutputter.UTF8));
                CCSOutputter.this.outStream.write(CRLF);
            }
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            CCSOutputter.this.anEnvelope.writeAsXML((OutputStream)byteArrayOutputStream);
            byte[] byArray2 = byteArrayOutputStream.toByteArray();
            if (CCSOutputter.this.doTrustedRequest) {
                byArray2 = this.signTrustedRequest(byArray2);
            }
            String string = CCSOutputter.CONTENT_LENGTH + Integer.toString(byArray2.length);
            CCSOutputter.this.outStream.write(string.getBytes(CCSOutputter.UTF8));
            CCSOutputter.this.outStream.write(CRLF);
            CCSOutputter.this.outStream.write(CRLF);
            CCSOutputter.this.outStream.write(byArray2);
        }

        protected void writeAttachments(byte[] byArray) throws IOException {
            CCSOutputter.this.outStream.write(byArray);
            String string = CCSOutputter.CONTENT_TYPE + CCSOutputter.this.m_Transport.getContentType() + "\r\n";
            if (CCSOutputter.this.locationHeader != null) {
                string = string + CCSOutputter.LOCATION + CCSOutputter.this.locationHeader + "\r\n";
            }
            string = string + "\r\n";
            CCSOutputter.this.outStream.write(string.getBytes("UTF-8"));
            CCSOutputter.this.writeRESTOutput();
        }

        @Override
        boolean canResend() {
            return false;
        }

        @Override
        protected void write() throws IOException {
            try {
                byte[] byArray = ("\r\n--" + CCSOutputter.this.getMimeBoundary() + "\r\n").getBytes(CCSOutputter.UTF8);
                byte[] byArray2 = ("\r\n--" + CCSOutputter.this.getMimeBoundary() + "--\r\n").getBytes(CCSOutputter.UTF8);
                if (CCSOutputter.this.anEnvelope != null) {
                    this.writeSOAPPart(byArray);
                }
                this.writeAttachments(byArray);
                CCSOutputter.this.outStream.write(byArray2);
                CCSOutputter.this.outStream.flush();
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                throw new IOException(unsupportedEncodingException.getLocalizedMessage());
            }
        }

        @Override
        protected String getContentType() {
            if (CCSOutputter.this.mimeStartPartContentID == null) {
                return CCSOutputter.MULTI_PART_CONTENT_TYPE + CCSOutputter.this.getMimeBoundary() + "\"";
            }
            return CCSOutputter.MULTI_PART_CONTENT_TYPE_P1 + CCSOutputter.this.mimeStartPartContentID + CCSOutputter.MULTI_PART_CONTENT_TYPE_P2 + CCSOutputter.this.getMimeBoundary() + "\"";
        }
    }

    private class SimpleOutputter
    extends Outputter {
        private SimpleOutputter() {
        }

        @Override
        protected void write() throws IOException {
            if (CCSOutputter.this.m_Transport instanceof SOAPTransport) {
                if (CCSOutputter.this.m_Result != null) {
                    String[] stringArray;
                    String string = ((BIBusEnvelope)CCSOutputter.this.anEnvelope).getAsString();
                    String string2 = "<ccsdatamarker/>";
                    boolean bl = false;
                    if (string.indexOf("<ccscdatamarker/>") != -1) {
                        string2 = "<ccscdatamarker/>";
                        bl = true;
                    }
                    if ((stringArray = string.split(string2)).length != 2 || CCSOutputter.this.m_Result == null) {
                        CCSOutputter.this.outStream.write(string.getBytes("UTF-8"));
                    } else {
                        CCSOutputter.this.outStream.write(stringArray[0].trim().getBytes("UTF-8"));
                        if (bl) {
                            CCSOutputter.this.outStream.write(CCSOutputter.START_CDATA.getBytes("UTF-8"));
                        }
                        CCSOutputter.this.m_Result.writeResultToStream(CCSOutputter.this.outStream);
                        if (bl) {
                            CCSOutputter.this.outStream.write(CCSOutputter.END_CDATA.getBytes("UTF-8"));
                        }
                        CCSOutputter.this.outStream.write(stringArray[1].trim().getBytes("UTF-8"));
                    }
                    CCSOutputter.this.outStream.flush();
                } else {
                    CCSOutputter.this.anEnvelope.writeAsXML(CCSOutputter.this.outStream);
                }
            } else {
                CCSOutputter.this.writeRESTOutput();
            }
        }

        @Override
        protected String getContentType() {
            return CCSOutputter.this.m_Transport.getContentType();
        }

        @Override
        boolean canResend() {
            return true;
        }
    }

    private abstract class Outputter {
        private Outputter() {
        }

        protected byte[] signTrustedRequest(byte[] byArray) throws IOException {
            try {
                return CryptoFacility.signRequest((byte[])byArray, (String)CCSOutputter.this.serviceID);
            }
            catch (Exception exception) {
                cat.error("Exception signing trusted request: ", (Throwable)exception);
                throw new IOException("Exception signing trusted request");
            }
        }

        protected abstract void write() throws IOException;

        protected abstract String getContentType();

        boolean canResend() {
            return false;
        }
    }
}

