/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.ccs.service;

import com.cognos.ccs.service.CCSDataResult;
import com.cognos.ccs.service.CCSLogger;
import com.cognos.ccs.service.CCSOutputter;
import com.cognos.ccs.transports.Transport;
import com.cognos.ccs.utility.Utilities;
import com.cognos.indications.LogPerfIndication;
import com.cognos.p2pd.httptools.MimeHeaderUtil;
import com.cognos.pogo.impl.PogoResponder;
import com.cognos.pogo.impl.PogoSOAPAttachmentResponder;
import com.cognos.pogo.impl.PogoSOAPMessageResponder;
import com.cognos.pogo.pdk.Fault;
import com.cognos.pogo.pdk.MessageContext;
import com.cognos.pogo.pdk.SOAPEnvelope;
import com.cognos.pogo.pdk.SOAPXMLSource;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collections;
import java.util.Iterator;
import javax.mail.internet.InternetHeaders;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import org.apache.log.Hierarchy;
import org.apache.log.Logger;

public class CCSResponder
extends PogoResponder {
    static final Logger cat = Hierarchy.getDefaultHierarchy().getLoggerFor(PogoSOAPMessageResponder.class.getName());
    private Logger perf_cat = Hierarchy.getDefaultHierarchy().getLoggerFor("perf." + PogoSOAPAttachmentResponder.class.getName());
    private static final InternetHeaders nullInternetHeaders = new InternetHeaders();
    protected CCSDataResult m_Data = null;
    protected String m_OutputBuffer = null;
    protected Transport m_Transport;
    protected boolean m_balanced = false;

    public void setTransport(Transport transport) {
        this.m_Transport = transport;
    }

    public void setData(CCSDataResult cCSDataResult) {
        this.m_Data = cCSDataResult;
        this.m_Transport = cCSDataResult.getTransport();
    }

    public CCSDataResult getData() {
        return this.m_Data;
    }

    public void setBuffer(String string, Transport transport) {
        this.m_OutputBuffer = string;
        this.m_Transport = transport;
    }

    public void setBalanced(boolean bl) {
        this.m_balanced = bl;
    }

    public String getBuffer() {
        return this.m_OutputBuffer;
    }

    public boolean respondImpl(HttpServletResponse httpServletResponse, MessageContext messageContext, String string) throws IOException {
        String[] stringArray;
        Object object = CCSLogger.getInstance().startTimer(0, "execute", "CCSResponser:respondImpl - handling of request", null);
        int n = messageContext.getIntProperty(string + ".status_code", 500);
        SOAPEnvelope sOAPEnvelope = (SOAPEnvelope)messageContext.getProperty(string + ".envelope");
        if (n != 304 && sOAPEnvelope == null) {
            cat.error("No response was generated.");
            if (null == messageContext.getFault()) {
                messageContext.setFault(new Fault("NO_RESPONSE"));
            }
            return false;
        }
        InternetHeaders internetHeaders = (InternetHeaders)messageContext.getProperty(string + ".headers");
        if (internetHeaders == null) {
            internetHeaders = nullInternetHeaders;
        }
        Iterator iterator = (Iterator)messageContext.getProperty(string + ".attachments");
        int n2 = messageContext.getIntProperty("byteRanges", 0);
        if (n2 > 0 && iterator != null) {
            sOAPEnvelope = null;
        }
        if (iterator == null) {
            iterator = Collections.EMPTY_LIST.iterator();
        }
        String string2 = messageContext.getStrProperty(string + ".boundary");
        httpServletResponse.setStatus(n);
        internetHeaders.removeHeader("Content-Length");
        internetHeaders.removeHeader("Content-Type");
        internetHeaders.removeHeader("Transfer-Encoding");
        internetHeaders.removeHeader("Server");
        internetHeaders.removeHeader("Set-Cookie");
        MimeHeaderUtil.copyHeaders((InternetHeaders)internetHeaders, (HttpServletResponse)httpServletResponse);
        String[] stringArray2 = internetHeaders.getHeader("ETag");
        if (stringArray2 != null && stringArray2.length > 0 && stringArray2[0] != null) {
            if (cat.isDebugEnabled()) {
                cat.debug("Using Etag value: " + stringArray2[0]);
            }
            httpServletResponse.setHeader("ETag", this.quoteETagValue(stringArray2[0]));
        }
        if (n == 304) {
            httpServletResponse.setContentLength(0);
            httpServletResponse.getOutputStream().flush();
            CCSLogger.getInstance().stopTimer(object);
            return true;
        }
        ServletOutputStream servletOutputStream = httpServletResponse.getOutputStream();
        if (object instanceof LogPerfIndication) {
            stringArray = (String[])object;
            stringArray.setLogData("CCSResponser:respondImpl - handling of request\n outputBuffer: \n" + this.m_OutputBuffer);
        }
        CCSOutputter cCSOutputter = new CCSOutputter((SOAPXMLSource)sOAPEnvelope, this.m_Data, (OutputStream)servletOutputStream, this.m_Transport, this.m_OutputBuffer, this.m_balanced);
        stringArray = internetHeaders.getHeader("Location");
        if (stringArray != null && stringArray.length > 0) {
            cCSOutputter.setLocation(stringArray[0]);
        }
        String string3 = cCSOutputter.getContentType();
        httpServletResponse.setContentType(string3);
        if ("application/vnd.openxmlformats-officedocument.spreadsheetml.sheet".equals(string3)) {
            String string4 = messageContext.getStrProperty("path_info");
            String[] stringArray3 = string4.split("/");
            String string5 = null;
            if (stringArray3.length > 0) {
                string5 = stringArray3[stringArray3.length - 1];
            }
            if (Utilities.isNullOrBlank(string5)) {
                string5 = "output";
            }
            httpServletResponse.addHeader("Content-disposition", "attachment; filename=" + string5 + ".xlsx");
        }
        this.perf_cat.info("Started writing SOAP Message...");
        try {
            cCSOutputter.write();
            servletOutputStream.flush();
        }
        catch (IOException iOException) {
            CCSLogger.getInstance().logRuntimeErrorMessage(iOException.getMessage(), "CCSResponder.respondImpl() failed.", null, null, iOException.getStackTrace().toString());
            CCSLogger.getInstance().stopTimer(object);
            this.closeAttachmentStreams(null, iterator);
            throw iOException;
        }
        this.perf_cat.info("Finished writing SOAP Message...");
        CCSLogger.getInstance().stopTimer(object);
        return true;
    }

    void closeAttachmentStreams(InputStream inputStream, Iterator iterator) {
        try {
            if (inputStream != null) {
                inputStream.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        while (iterator.hasNext()) {
            InputStream inputStream2 = (InputStream)iterator.next();
            try {
                inputStream2.close();
            }
            catch (IOException iOException) {}
        }
    }
}

