/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.ccs.service;

import com.cognos.ccs.cache.PromptAnswersCache;
import com.cognos.ccs.content.PromptValue;
import com.cognos.ccs.exceptions.CCSAuthenticationException;
import com.cognos.ccs.exceptions.CCSGeneralException;
import com.cognos.ccs.service.Cognos8Connector;
import com.cognos.ccs.service.ConfigMgr;
import com.cognos.ccs.service.SessionManager;
import com.cognos.ccs.utility.CommandInfo;
import com.cognos.ccs.utility.Utilities;
import com.cognos.pogo.pdk.BIBusEnvelope;
import com.cognos.pogo.pdk.MessageContext;
import com.ibm.cognos.ccs.internal.utility.Constants;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Locale;
import javax.mail.internet.InternetHeaders;
import org.apache.commons.httpclient.Cookie;
import org.dom4j.Branch;
import org.dom4j.Element;
import org.dom4j.Namespace;

public abstract class CCSSession {
    private static final String SEPERATOR = ":";
    private HashMap properties = new HashMap();
    private CommandInfo cmdInfo = new CommandInfo();
    private String sessionConversationID = null;
    protected Locale m_locale = null;
    protected Namespace m_responseNamespace = new Namespace("rds", "http://developer.cognos.com/schemas/rds/types/1");
    protected String absoluteGatewayURL = null;
    protected boolean m_isAccessibilityFeaturesEnabled = false;
    private static String[] TLDs = new String[]{".com", ".edu", ".net", ".org", ".gov", ".mil", ".int"};
    protected String m_routingServerGroup = "";

    public static final void abortAll() {
        SessionManager.getInstance().cancelAll();
    }

    public static final boolean abortConversation(String string) {
        return SessionManager.getInstance().cancelConversation(string);
    }

    protected final void endConversation() {
        SessionManager.getInstance().removeConversation(this.sessionConversationID);
    }

    public final String getConversationID() {
        return this.sessionConversationID;
    }

    public final boolean isAborted() {
        int n = SessionManager.getInstance().getConversationState(this.sessionConversationID);
        return n == 1;
    }

    protected final void startConversation(String string) {
        SessionManager.getInstance().addConversation(string);
        this.sessionConversationID = string;
    }

    public Locale getUserJavaLocale() {
        return this.m_locale;
    }

    public void setUserJavaLocale(Locale locale) {
        this.m_locale = locale;
    }

    public Namespace getResponseNamespace() {
        return this.m_responseNamespace;
    }

    public String getAbsoluteGatewayURL() {
        return this.absoluteGatewayURL;
    }

    public String getGatewayURL(boolean bl) {
        return this.getGatewayURL(bl, false);
    }

    public String getGatewayURL(boolean bl, boolean bl2) {
        String string = null;
        if (bl2) {
            string = ConfigMgr.getInstance().getCognosGateway();
            if (bl) {
                string = Utilities.removeHostnameFromURL(string);
            }
        } else {
            string = bl ? this.getRelativeGatewayURL() : this.getAbsoluteGatewayURL();
        }
        return string;
    }

    public String getRelativeGatewayURL() {
        return Utilities.removeHostnameFromURL(this.getAbsoluteGatewayURL());
    }

    protected void buildGatewayURL(BIBusEnvelope bIBusEnvelope, MessageContext messageContext) {
        Object object;
        boolean bl = false;
        InternetHeaders internetHeaders = (InternetHeaders)messageContext.getProperty("request.headers");
        if (null != internetHeaders && (object = internetHeaders.getHeader("original-https")) != null && ((String[])object).length > 0 && object[0].equalsIgnoreCase("on")) {
            bl = true;
        }
        object = bl ? "https://" : "http://";
        String string = bIBusEnvelope.getEnvironmentValue("SERVER_NAME");
        String string2 = bIBusEnvelope.getEnvironmentValue("SERVER_PORT");
        String string3 = bIBusEnvelope.getEnvironmentValue("SCRIPT_NAME");
        if ((Utilities.isNullOrEmpty(string) || Utilities.isNullOrEmpty(string2) || Utilities.isNullOrEmpty(string3)) && internetHeaders != null) {
            String[] stringArray = internetHeaders.getHeader("original-host");
            if (stringArray != null && stringArray.length > 0) {
                string = stringArray[0];
            }
            if ((stringArray = internetHeaders.getHeader("original-server_port")) != null && stringArray.length > 0) {
                string2 = stringArray[0];
            }
            if ((stringArray = internetHeaders.getHeader("original-script-name")) != null && stringArray.length > 0) {
                string3 = stringArray[0];
            }
        }
        this.absoluteGatewayURL = Utilities.isNullOrEmpty(string) || Utilities.isNullOrEmpty(string2) || Utilities.isNullOrEmpty(string3) ? ConfigMgr.getInstance().getCognosGateway() : (String)object + string + SEPERATOR + string2 + string3;
    }

    public static Cookie[] populateCookies(BIBusEnvelope bIBusEnvelope, MessageContext messageContext) {
        ConfigMgr configMgr = ConfigMgr.getInstance();
        String string = CCSSession.getDomain(bIBusEnvelope, messageContext, configMgr);
        Element element = bIBusEnvelope.getSetCookieVars().createCopy();
        Element element2 = bIBusEnvelope.getCookieVars().createCopy();
        element.appendContent((Branch)element2);
        Cookie[] cookieArray = CCSSession.processCookies(element, string, configMgr, bIBusEnvelope);
        return cookieArray;
    }

    private static String getDomain(BIBusEnvelope bIBusEnvelope, MessageContext messageContext, ConfigMgr configMgr) {
        String string = configMgr.getCookieDomain();
        if (string == null || string.equals("")) {
            string = CCSSession.getDomainFromHttpHost(bIBusEnvelope, messageContext.getStrProperty("HTTP_HOST"));
        }
        if (string == null) {
            string = messageContext.getStrProperty("HTTP_HOST");
        }
        if (string == null) {
            string = bIBusEnvelope.getEnvironmentValue("HTTP_HOST");
        }
        return string;
    }

    private static Cookie[] processCookies(Element element, String string, ConfigMgr configMgr, BIBusEnvelope bIBusEnvelope) {
        Element element2;
        Element element3;
        LinkedHashSet<Object> linkedHashSet = new LinkedHashSet<Object>();
        Iterator iterator = element.elementIterator("item");
        boolean bl = false;
        while (iterator.hasNext()) {
            element3 = (Element)iterator.next();
            element2 = element3.element("name");
            Element element4 = element3.element("value");
            if (element2 == null || element4 == null) continue;
            Cookie cookie = new Cookie();
            cookie.setName(element2.getText());
            if (element2.getText().equals("cam_passport")) {
                bl = true;
            }
            cookie.setValue(element4.getText());
            cookie.setPath(configMgr.getCookiePath());
            cookie.setDomain(string);
            cookie.setSecure(configMgr.getCookieSecure());
            linkedHashSet.add(cookie);
        }
        if (!bl && (element3 = bIBusEnvelope.getCAM()).hasContent()) {
            try {
                element2 = new Cookie();
                element2.setName("cam_passport");
                element2.setValue(element3.element(BIBusEnvelope.BUS_CAMPASSPORT.getName()).element("id").getText());
                element2.setPath(configMgr.getCookiePath());
                element2.setDomain(string);
                element2.setSecure(configMgr.getCookieSecure());
                linkedHashSet.add(element2);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return linkedHashSet.toArray(new Cookie[linkedHashSet.size()]);
    }

    protected static boolean allNumericAddr(String string) {
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if (c == '.' || c >= '0' && c <= '9') continue;
            return false;
        }
        return true;
    }

    protected static String defaultAddr() {
        return null;
    }

    protected static String getDomainFromHttpHost(BIBusEnvelope bIBusEnvelope, String string) {
        String string2 = bIBusEnvelope.getEnvironmentValue("HTTP_HOST");
        if (string2 == null) {
            string2 = string;
        }
        return CCSSession.getDomainFromHttpHost(string2);
    }

    protected static String getDomainFromHttpHost(String string) {
        int n;
        if (string == null) {
            return CCSSession.defaultAddr();
        }
        int n2 = string.indexOf(58);
        if (n2 != -1) {
            string = string.substring(0, n2);
        }
        if (CCSSession.allNumericAddr(string)) {
            return CCSSession.defaultAddr();
        }
        int n3 = string.lastIndexOf(46);
        if (n3 == -1) {
            return CCSSession.defaultAddr();
        }
        int n4 = string.lastIndexOf(46, n3 - 1);
        if (n4 == -1) {
            return CCSSession.defaultAddr();
        }
        String string2 = string.substring(n3);
        for (n = 0; n < TLDs.length; ++n) {
            if (!string2.equalsIgnoreCase(TLDs[n])) continue;
            return string.substring(n4);
        }
        n = string.lastIndexOf(46, n4 - 1);
        if (n == -1) {
            return CCSSession.defaultAddr();
        }
        return string.substring(n);
    }

    protected abstract Cognos8Connector getConnect();

    public PromptValue[] getPrompts(String string) throws CCSGeneralException, CCSAuthenticationException {
        Cognos8Connector cognos8Connector = this.getConnect();
        PromptAnswersCache promptAnswersCache = cognos8Connector.promptAnswersCache();
        PromptValue[] promptValueArray = promptAnswersCache.promptAnswers(string);
        return promptValueArray;
    }

    public String getRoutingServerGroup() {
        return this.m_routingServerGroup;
    }

    public void setRoutingServerGroup(String string) {
        this.m_routingServerGroup = string;
    }

    public void setProperty(String string, Object object) {
        this.properties.put(string, object);
    }

    public Object getProperty(String string) {
        return this.properties.get(string);
    }

    public void parseRequestVersion(MessageContext messageContext) {
        this.cmdInfo.parse(messageContext);
    }

    public void setRequestVersion(Constants.RequestVersion requestVersion) {
        this.cmdInfo.setRequestVersion(requestVersion);
    }

    public Constants.RequestVersion getRequestVersion() {
        return this.cmdInfo.getRequestVersion();
    }

    public boolean getIsAccessibilityFeaturesEnabled() {
        return this.m_isAccessibilityFeaturesEnabled;
    }
}

