/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.ccs.service;

import com.cognos.caf.CAFSecureErrorHandler;
import com.cognos.caf.common.CAFException;
import com.cognos.ccs.cache.ConversationCache;
import com.cognos.ccs.content.ContentProvider;
import com.cognos.ccs.exceptions.CCSAuthenticationException;
import com.cognos.ccs.exceptions.CCSException;
import com.cognos.ccs.exceptions.CCSFault;
import com.cognos.ccs.exceptions.CCSGeneralException;
import com.cognos.ccs.exceptions.CCSPromptException;
import com.cognos.ccs.formats.CCSFormatter;
import com.cognos.ccs.formats.FormatLoader;
import com.cognos.ccs.service.CCSDataResult;
import com.cognos.ccs.service.CCSLogger;
import com.cognos.ccs.service.CCSResponder;
import com.cognos.ccs.service.CCSSession;
import com.cognos.ccs.service.Cognos8Connector;
import com.cognos.ccs.service.ConfigMgr;
import com.cognos.ccs.service.Conversation;
import com.cognos.ccs.service.command.ACommand;
import com.cognos.ccs.service.command.CommandMap;
import com.cognos.ccs.transports.SOAPTransport;
import com.cognos.ccs.transports.Transport;
import com.cognos.ccs.transports.XMLTransport;
import com.cognos.ccs.utility.PathPart;
import com.cognos.ccs.utility.Utilities;
import com.cognos.p2plb.model.NodeID;
import com.cognos.pogo.pdk.BIBusEnvelope;
import com.cognos.pogo.pdk.Fault;
import com.cognos.pogo.pdk.MessageContext;
import com.cognos.pogo.pdk.SOAPEnvelope;
import com.ibm.cognos.ccs.internal.utility.Constants;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import javax.mail.internet.InternetHeaders;
import org.apache.commons.httpclient.Cookie;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.Namespace;
import org.dom4j.QName;

public class CommandSession
extends CCSSession {
    private static final String DEFAULT_WEBCONTENT = "/ibmcognos";
    private static final String SYSTEM_RECOVERABLE_CAM_FAULT = "camAuthSystemRecoverable";
    private static final String IMAGES = "images";
    private static final String SKINS = "skins";
    private static final String COMMON = "common";
    private static final String SCHEMAS = "schemas";
    protected Cognos8Connector m_connect = null;
    protected Cookie[] m_cookies = null;
    protected Transport m_transport = null;
    protected CCSResponder m_responder = null;
    protected static FormatLoader m_loader = null;
    protected String m_sessionID = null;
    protected String m_requestID = null;
    protected BIBusEnvelope m_response = null;
    protected BIBusEnvelope m_request = null;
    protected boolean m_isSimplified = false;
    protected int relative_count = 0;
    protected String webcontent = null;
    protected boolean showErrorTrace = false;

    public void processFormMessage(BIBusEnvelope bIBusEnvelope, MessageContext messageContext, boolean bl) {
        block15: {
            try {
                if (this.hasCAMSystemRecoverableFault(bIBusEnvelope, messageContext)) {
                    return;
                }
                messageContext.setFault(null);
                this.m_request = bIBusEnvelope;
                try {
                    this.showErrorTrace = Boolean.TRUE.toString().equals(System.getenv().get("CCS_DEBUG")) ? true : (bIBusEnvelope.getPassportID() != null ? CAFSecureErrorHandler.canReceiveDetailedErrors((BIBusEnvelope)bIBusEnvelope) : false);
                }
                catch (CAFException cAFException) {
                    this.showErrorTrace = false;
                }
                this.m_responseNamespace = this.getRequestVersion() == Constants.RequestVersion.V3 ? new Namespace("rds", "http://www.ibm.com/xmlns/prod/cognos/rds/types/201310") : new Namespace("rds", "http://developer.cognos.com/schemas/rds/types/2");
                this.m_sessionID = bIBusEnvelope.getPassportID();
                this.m_requestID = bIBusEnvelope.getTrackingRequestContext();
                this.m_transport = new XMLTransport();
                this.webcontent = bIBusEnvelope.getEnvironmentValue("WEB_CONTENT_ROOT");
                this.buildGatewayURL(bIBusEnvelope, messageContext);
                this.logBIBusTrace(bIBusEnvelope);
                String string = (String)messageContext.getProperty("path_info");
                String[] stringArray = string.split("/");
                if (stringArray.length < 3) {
                    throw new CCSGeneralException("REQUEST_ERROR", 400);
                }
                this.relative_count = stringArray.length - 2;
                String string2 = stringArray[2];
                boolean bl2 = string2.equalsIgnoreCase("outputFormat");
                String string3 = this.getSourceType(string2, stringArray);
                if (this.isExternalImageResourceRequest(string3)) {
                    Object object;
                    this.prepareErrorResponse(messageContext, bIBusEnvelope, false);
                    String string4 = this.extractSourceTypeID(stringArray, bl2, true);
                    String string5 = "";
                    String string6 = stringArray[stringArray.length - 1];
                    ACommand aCommand = this.getCommand(string2, bIBusEnvelope, messageContext);
                    try {
                        string5 = aCommand.getSavedOutputStoreID(bIBusEnvelope, messageContext, string4);
                    }
                    catch (Exception exception) {
                        object = new CCSGeneralException("RUNTIME_ERROR", exception, 500);
                        CCSLogger.getInstance().logRuntimeErrorMessage(((CCSException)object).getServerLocaleMessage(), "rest", null, null, ((CCSGeneralException)object).getSourceTrace());
                    }
                    StringBuilder stringBuilder = new StringBuilder(this.getRelativeRoot());
                    stringBuilder.append("gdi/");
                    stringBuilder.append(string5);
                    stringBuilder.append("/");
                    object = "graphic[@name=\"" + string6 + "\"]";
                    try {
                        object = URLEncoder.encode((String)object, "UTF-8");
                    }
                    catch (UnsupportedEncodingException unsupportedEncodingException) {
                        CCSGeneralException cCSGeneralException = new CCSGeneralException("RUNTIME_ERROR", unsupportedEncodingException, 500);
                        CCSLogger.getInstance().logRuntimeErrorMessage(cCSGeneralException.getServerLocaleMessage(), "rest", null, null, cCSGeneralException.getSourceTrace());
                    }
                    stringBuilder.append((String)object);
                    this.generateRedirectionHeaders(stringBuilder.toString(), messageContext);
                    break block15;
                }
                if (Utilities.isCSSFilePath(string3) || this.isExternalResourceRequest(string3)) {
                    this.prepareErrorResponse(messageContext, bIBusEnvelope, false);
                    StringBuilder stringBuilder = new StringBuilder("../../");
                    stringBuilder.append(this.getRelativeRoot());
                    int n = 0;
                    n = bl2 ? (PathPart.SEARCHPATH.equalsIgnoreCase(stringArray[3]) || PathPart.PATH.equalsIgnoreCase(stringArray[3]) ? this.getExternalResourceStartIndex(stringArray) : 4) : 3;
                    for (int i = n; i < stringArray.length; ++i) {
                        stringBuilder.append(stringArray[i]);
                        if (i >= stringArray.length - 1) continue;
                        stringBuilder.append("/");
                    }
                    this.generateRedirectionHeaders(stringBuilder.toString(), messageContext);
                } else {
                    String string7 = this.extractSourceTypeID(stringArray, bl2, false);
                    ACommand aCommand = null;
                    aCommand = CommandMap.IsExtensionRequest(stringArray[1]) ? this.getExtensionCommand(string2, stringArray[1], bIBusEnvelope, messageContext) : this.getCommand(string2, bIBusEnvelope, messageContext);
                    this.m_responder.setBalanced(bl);
                    Object object = CCSLogger.getInstance().startTimer(0, "execute", "CommandSession:processFormMessage (REST command) - " + aCommand.getClass().getName(), null);
                    aCommand.performRestAction(bIBusEnvelope, messageContext, string7);
                    CCSLogger.getInstance().stopTimer(object);
                    this.m_connect.populateCCSBiBusFromRS(this.m_response);
                }
            }
            catch (CCSGeneralException cCSGeneralException) {
                this.prepareErrorResponse(messageContext, bIBusEnvelope, false);
                this.generateRESTErrorBlock(cCSGeneralException, messageContext);
            }
            catch (RuntimeException runtimeException) {
                this.prepareErrorResponse(messageContext, bIBusEnvelope, false);
                CCSGeneralException cCSGeneralException = new CCSGeneralException("RUNTIME_ERROR", runtimeException, 500);
                this.generateRESTErrorBlock(cCSGeneralException, messageContext);
            }
        }
    }

    private String getSourceType(String string, String[] stringArray) {
        boolean bl = string.equalsIgnoreCase("outputFormat");
        boolean bl2 = string.equalsIgnoreCase("providerOutput");
        boolean bl3 = string.equalsIgnoreCase("sessionOutput");
        int n = stringArray.length;
        if (stringArray[n - 2].equalsIgnoreCase(IMAGES)) {
            if (bl && stringArray[n - 3].equalsIgnoreCase("HTML")) {
                return IMAGES;
            }
            if (bl3 && n >= 4 && Utilities.isStoreIdValid(stringArray[n - 3]) && PathPart.CONVERSATIONID.equalsIgnoreCase(stringArray[n - 4])) {
                return IMAGES;
            }
        }
        String string2 = "";
        if ((bl2 || bl3) && n > 3) {
            string2 = stringArray[3];
        } else if (bl) {
            string2 = stringArray[n - 1];
        }
        return string2;
    }

    private boolean isExternalResourceRequest(String string) {
        return (string = string.toLowerCase()).equals(SKINS) || string.equals(COMMON) || string.equals(SCHEMAS);
    }

    private int getExternalResourceStartIndex(String[] stringArray) {
        if (stringArray != null) {
            for (int i = stringArray.length - 1; i >= 0; --i) {
                if (!this.isExternalResourceRequest(stringArray[i])) continue;
                return i;
            }
        }
        return 0;
    }

    private boolean isExternalImageResourceRequest(String string) {
        return string.equalsIgnoreCase(IMAGES);
    }

    private boolean hasCAMSystemRecoverableFault(BIBusEnvelope bIBusEnvelope, MessageContext messageContext) {
        String string;
        Element element;
        Element element2;
        return messageContext.getFault() != null && (element2 = (element = bIBusEnvelope.getCAM()).element("exception")) != null && SYSTEM_RECOVERABLE_CAM_FAULT.equals(string = element2.elementText("errorCodeString"));
    }

    public String getRelativeRoot() {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < this.relative_count; ++i) {
            stringBuffer.append("../");
        }
        return stringBuffer.toString();
    }

    public void prepareErrorResponse(MessageContext messageContext, BIBusEnvelope bIBusEnvelope, boolean bl) {
        this.m_transport = bl ? new SOAPTransport() : new XMLTransport();
        this.m_response = this.m_transport.prepareResponse(bIBusEnvelope, messageContext, new Namespace[]{this.m_responseNamespace});
        this.m_responder = new CCSResponder();
        this.m_responder.setTransport(this.m_transport);
        messageContext.setProperty("pogo.responder", (Object)this.m_responder);
    }

    public void processGeneratedSOAPCommand(BIBusEnvelope bIBusEnvelope, MessageContext messageContext) {
        try {
            if (this.hasCAMSystemRecoverableFault(bIBusEnvelope, messageContext)) {
                return;
            }
            this.m_isSimplified = true;
            messageContext.setFault(null);
            this.m_request = bIBusEnvelope;
            this.m_responseNamespace = new Namespace("raas", "http://developer.cognos.com/schemas/raas/1");
            this.webcontent = bIBusEnvelope.getEnvironmentValue("WEB_CONTENT_ROOT");
            this.buildGatewayURL(bIBusEnvelope, messageContext);
            this.m_sessionID = bIBusEnvelope.getPassportID();
            this.m_requestID = bIBusEnvelope.getTrackingRequestContext();
            this.logBIBusTrace(bIBusEnvelope);
            this.m_transport = new SOAPTransport();
            Element element = this.getSOAPRequest(bIBusEnvelope, messageContext);
            String string = null;
            String string2 = element.getName();
            string = string2.equals("GetCognosURLRequest") || string2.equals("GetPromptPageRequest") || string2.equals("GetPromptAnswersRequest") ? string2 : (string2.startsWith("Get") ? "get" : (element.getName().startsWith("Drill") ? "drill_simple" : element.getName()));
            ACommand aCommand = this.getCommand(string, bIBusEnvelope, messageContext);
            aCommand.performSoapAction(element, messageContext);
            this.m_connect.populateCCSBiBusFromRS(this.m_response);
            this.logBIBusTrace(this.m_response);
            this.endConversation();
        }
        catch (CCSException cCSException) {
            this.prepareErrorResponse(messageContext, bIBusEnvelope, true);
            this.generateSOAPFault(messageContext, cCSException);
        }
        catch (RuntimeException runtimeException) {
            this.prepareErrorResponse(messageContext, bIBusEnvelope, true);
            CCSGeneralException cCSGeneralException = new CCSGeneralException("RUNTIME_ERROR", runtimeException, 500);
            this.generateSOAPFault(messageContext, cCSGeneralException);
        }
    }

    protected Element getSOAPRequest(BIBusEnvelope bIBusEnvelope, MessageContext messageContext) throws CCSGeneralException {
        if (bIBusEnvelope.getBody().elements().size() <= 0) {
            throw new CCSGeneralException("REQUEST_ERROR", 400);
        }
        Element element = (Element)bIBusEnvelope.getBody().elements().get(0);
        return element;
    }

    public void processSOAPCommand(BIBusEnvelope bIBusEnvelope, MessageContext messageContext) {
        try {
            if (this.hasCAMSystemRecoverableFault(bIBusEnvelope, messageContext)) {
                return;
            }
            messageContext.setFault(null);
            this.m_request = bIBusEnvelope;
            this.webcontent = bIBusEnvelope.getEnvironmentValue("WEB_CONTENT_ROOT");
            this.m_sessionID = bIBusEnvelope.getPassportID();
            this.m_requestID = bIBusEnvelope.getTrackingRequestContext();
            this.logBIBusTrace(bIBusEnvelope);
            this.buildGatewayURL(bIBusEnvelope, messageContext);
            this.m_transport = new SOAPTransport();
            Element element = this.getSOAPRequest(bIBusEnvelope, messageContext);
            this.m_responseNamespace = element.getNamespace();
            String string = (String)messageContext.getProperty("request.soapaction");
            ACommand aCommand = null;
            aCommand = CommandMap.IsExtensionRequest(string) ? this.getExtensionCommand(element.getName(), string, bIBusEnvelope, messageContext) : this.getCommand(element.getName(), bIBusEnvelope, messageContext);
            Object object = CCSLogger.getInstance().startTimer(0, "execute", "CommandSession:processSOAPCommand - " + aCommand.getClass().getName(), null);
            aCommand.performSoapAction(element, messageContext);
            CCSLogger.getInstance().stopTimer(object);
            this.m_connect.populateCCSBiBusFromRS(this.m_response);
            this.logBIBusTrace(this.m_response);
            this.endConversation();
        }
        catch (CCSException cCSException) {
            this.prepareErrorResponse(messageContext, bIBusEnvelope, true);
            this.generateSOAPFault(messageContext, cCSException);
        }
        catch (RuntimeException runtimeException) {
            this.prepareErrorResponse(messageContext, bIBusEnvelope, true);
            CCSGeneralException cCSGeneralException = new CCSGeneralException("RUNTIME_ERROR", runtimeException, 500);
            this.generateSOAPFault(messageContext, cCSGeneralException);
        }
    }

    public void generateSOAPFault(MessageContext messageContext, CCSException cCSException) {
        String string = null;
        if (cCSException instanceof CCSGeneralException) {
            string = ((CCSGeneralException)cCSException).getSourceTrace();
        }
        CCSLogger.getInstance().logRuntimeErrorMessage(cCSException.getServerLocaleMessage(), "soap", null, null, string);
        CCSFault cCSFault = cCSException.getFault();
        cCSFault.setMessageContext(messageContext);
        cCSFault.setResponseNamespace(this.m_responseNamespace);
        SOAPEnvelope sOAPEnvelope = cCSFault.generateEnvelope(this.m_response);
        messageContext.setResponseName("response");
        messageContext.setProperty("response.envelope", (Object)sOAPEnvelope);
        messageContext.setProperty("response.status_code", (Object)"500");
        InternetHeaders internetHeaders = new InternetHeaders();
        internetHeaders.setHeader("Content-Type", "text/xml");
        messageContext.setProperty("response.headers", (Object)internetHeaders);
        messageContext.setProperty("response.status_msg", (Object)"Internal Server error");
        messageContext.setProperty("response.boundary", null);
        messageContext.setProperty("response.attachments", null);
    }

    protected void logBIBusTrace(BIBusEnvelope bIBusEnvelope) {
        try {
            if (CCSLogger.getInstance().isSystemRequestLogging()) {
                CCSLogger.getInstance().logSystemRequest(bIBusEnvelope.getAsString(), this.m_sessionID, this.m_requestID);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    protected void logTrace(String string) {
        if (CCSLogger.getInstance().isSystemRequestLogging()) {
            CCSLogger.getInstance().logSystemRequest(string, this.m_sessionID, this.m_requestID);
        }
    }

    protected ACommand getCommand(String string, BIBusEnvelope bIBusEnvelope, MessageContext messageContext) throws CCSGeneralException {
        ACommand aCommand = CommandMap.getInstance().getCommand(string);
        if (aCommand == null) {
            throw new CCSGeneralException("REQUEST_ERROR", 400);
        }
        this.prepareCommand(bIBusEnvelope, messageContext, aCommand);
        return aCommand;
    }

    protected ACommand getExtensionCommand(String string, String string2, BIBusEnvelope bIBusEnvelope, MessageContext messageContext) throws CCSGeneralException {
        ACommand aCommand = CommandMap.getInstance().getExtensionCommand(string2, string);
        if (aCommand == null) {
            throw new CCSGeneralException("REQUEST_ERROR", 400);
        }
        this.prepareCommand(bIBusEnvelope, messageContext, aCommand);
        return aCommand;
    }

    protected void prepareCommand(BIBusEnvelope bIBusEnvelope, MessageContext messageContext, ACommand aCommand) throws CCSGeneralException {
        this.m_cookies = CommandSession.populateCookies(bIBusEnvelope, messageContext);
        this.m_responder = new CCSResponder();
        this.m_connect = new Cognos8Connector();
        this.m_connect.connectToReportServer();
        this.m_locale = ConfigMgr.getJavaLocale(bIBusEnvelope.getUserPreferenceValue("productLocale"));
        messageContext.setProperty("pogo.responder", (Object)this.m_responder);
        this.m_connect.populateSDKBiBus(bIBusEnvelope);
        this.m_response = this.m_transport.prepareResponse(bIBusEnvelope, messageContext, new Namespace[]{this.m_responseNamespace});
        this.m_responder.setTransport(this.m_transport);
        this.m_isAccessibilityFeaturesEnabled = "true".equals(bIBusEnvelope.getUserPreferenceValue("http://developer.cognos.com/ceba/constants/systemOptionEnum#accessibilityFeatures"));
        aCommand.setSession(this);
    }

    protected String extractSourceTypeID(String[] stringArray, boolean bl, boolean bl2) throws CCSGeneralException {
        if (stringArray.length < 5) {
            return null;
        }
        String string = stringArray[3];
        if (PathPart.STOREID.equals(string) || PathPart.REPORT.equals(string)) {
            if (!Utilities.isStoreIdValid(stringArray[4])) {
                throw new CCSGeneralException("REQUEST_ERROR", 400);
            }
            return (Object)((Object)PathPart.STOREID) + "(\"" + stringArray[4] + "\")";
        }
        if (PathPart.CONVERSATIONID.equals(string)) {
            if (!Utilities.isStoreIdValid(stringArray[4])) {
                throw new CCSGeneralException("REQUEST_ERROR", 400);
            }
            return stringArray[4];
        }
        if (PathPart.SEARCHPATH.equals(string)) {
            StringBuilder stringBuilder = new StringBuilder();
            int n = bl ? stringArray.length - 1 : stringArray.length;
            String string2 = "";
            for (int i = 4; i < n; ++i) {
                String string3 = CCSFormatter.decodeName(stringArray[i]);
                if (bl2 && string3.equalsIgnoreCase("HTML")) break;
                stringBuilder.append(string2);
                string2 = "/";
                stringBuilder.append(string3);
            }
            return stringBuilder.toString();
        }
        if (PathPart.PATH.equals(string)) {
            StringBuilder stringBuilder = new StringBuilder();
            int n = bl ? stringArray.length - 1 : stringArray.length;
            String string4 = "";
            for (int i = 4; i < n; ++i) {
                String string5 = stringArray[i];
                if (bl2 && string5.equalsIgnoreCase("HTML")) break;
                stringBuilder.append(string4);
                string4 = "/";
                stringBuilder.append(string5);
            }
            return ContentProvider.convertResourcePathtoSearchPath(stringBuilder.toString(), true);
        }
        if (PathPart.METRICS.equals(string)) {
            return (Object)((Object)PathPart.METRICS) + "(\"" + stringArray[4] + "\")";
        }
        if (PathPart.TOPIC.equalsIgnoreCase(string) || PathPart.ID.equalsIgnoreCase(string)) {
            return null;
        }
        throw new CCSGeneralException("REQUEST_ERROR", 400);
    }

    public void handleRESTCCSException(CCSException cCSException, MessageContext messageContext) {
        BIBusEnvelope bIBusEnvelope = Utilities.getCAMSystemRecoverableFaultEnvelope(cCSException);
        if (bIBusEnvelope != null) {
            messageContext.setFault(new Fault("", (SOAPEnvelope)bIBusEnvelope));
        } else {
            this.generateRESTErrorBlock(cCSException, messageContext);
        }
    }

    public void handleSOAPCCSException(MessageContext messageContext, CCSException cCSException) {
        BIBusEnvelope bIBusEnvelope = Utilities.getCAMSystemRecoverableFaultEnvelope(cCSException);
        if (bIBusEnvelope != null) {
            messageContext.setFault(new Fault("", (SOAPEnvelope)bIBusEnvelope));
        } else {
            this.generateSOAPFault(messageContext, cCSException);
        }
    }

    public void generateRESTErrorBlock(CCSException cCSException, MessageContext messageContext) {
        CCSPromptException cCSPromptException;
        String string = null;
        if (cCSException instanceof CCSGeneralException) {
            string = ((CCSGeneralException)cCSException).getSourceTrace();
        }
        CCSLogger.getInstance().logRuntimeErrorMessage(cCSException.getServerLocaleMessage(), "rest", null, null, string);
        ((XMLTransport)this.m_transport).setContentType("text/xml; charset=UTF-8");
        messageContext.setProperty("response.status_code", (Object)Integer.toString(cCSException.getErrorType()));
        Element element = DocumentHelper.createElement((QName)new QName("error", this.m_responseNamespace));
        Element element2 = element.addElement(new QName("message", this.m_responseNamespace));
        element2.setText(cCSException.getUserLocaleMessage(this.m_locale));
        if (this.showErrorTrace && string != null) {
            cCSPromptException = element.addElement(new QName("trace", this.m_responseNamespace));
            cCSPromptException.setText(string);
        }
        if (cCSException instanceof CCSPromptException) {
            cCSPromptException = (CCSPromptException)cCSException;
            Element element3 = element.addElement(new QName("promptID", this.m_responseNamespace));
            element3.setText(cCSPromptException.getPromptID());
            Element element4 = element.addElement(new QName("url", this.m_responseNamespace));
            element4.setText(cCSPromptException.getURL());
        }
        this.m_responder.setBuffer(element.asXML(), this.m_transport);
    }

    public void generateRedirectionHeaders(String string, MessageContext messageContext) {
        ((XMLTransport)this.m_transport).setContentType("text/xml; charset=UTF-8");
        messageContext.setProperty("response.status_code", (Object)"302");
        InternetHeaders internetHeaders = (InternetHeaders)messageContext.getProperty("response.headers");
        internetHeaders.addHeader("Location", string);
        messageContext.setProperty("response.headers", (Object)internetHeaders);
    }

    public ContentProvider getProviderFromConversation(Conversation conversation) throws CCSGeneralException, CCSAuthenticationException {
        String string = (String)conversation.getProperty("searchPath");
        ContentProvider contentProvider = ContentProvider.getProvider(string, this.m_connect, this.m_cookies, this);
        Constants.Compatibility compatibility = (Constants.Compatibility)((Object)conversation.getProperty("downgrade"));
        if (compatibility != null) {
            contentProvider.setDowngrade(compatibility);
        }
        if (this.m_isSimplified) {
            this.m_responseNamespace = this.getSimplifiedResponseNamespace(contentProvider);
        }
        return contentProvider;
    }

    public ContentProvider getProviderFromID(String string) throws CCSGeneralException, CCSAuthenticationException {
        ContentProvider contentProvider = ContentProvider.getProvider(string, this.m_connect, this.m_cookies, this);
        if (this.m_isSimplified) {
            this.m_responseNamespace = this.getSimplifiedResponseNamespace(contentProvider);
        }
        return contentProvider;
    }

    public String extractSourceIDFromPath(MessageContext messageContext) {
        String string = (String)messageContext.getProperty("path_info");
        if (string == null) {
            return null;
        }
        String[] stringArray = (string = string.replaceAll("\\+", " ")).split("/");
        if (stringArray.length < 3) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 2; i < stringArray.length; ++i) {
            if (stringArray.length > 3) {
                stringBuffer.append("/");
            }
            stringBuffer.append(stringArray[i]);
        }
        return stringBuffer.toString();
    }

    public ContentProvider getProviderFromPath(MessageContext messageContext) throws CCSGeneralException, CCSAuthenticationException {
        String string = (String)messageContext.getProperty("path_info");
        ContentProvider contentProvider = this.getProviderFromPath(string);
        return contentProvider;
    }

    private ContentProvider getProviderFromPath(String string) throws CCSGeneralException, CCSAuthenticationException {
        try {
            String string2 = URLDecoder.decode(string, "UTF-8");
            string2 = string2.replace("/rds/Simple/", "/rds/");
            string2 = string2.replace("/rds/LDX/", "/rds/");
            string2 = string2.replace("/rds/thumbnail/report/", "/rds/");
            string2 = string2.replaceAll("\\+", " ");
            String[] stringArray = string2.split("/");
            if (stringArray.length < 3) {
                throw new CCSGeneralException("REQUEST_ERROR", 400);
            }
            if (!Utilities.isStoreIdPathValid(stringArray[2])) {
                throw new CCSGeneralException("REQUEST_ERROR", 400);
            }
            StringBuffer stringBuffer = new StringBuffer();
            for (int i = 2; i < stringArray.length; ++i) {
                if (stringArray.length > 3) {
                    stringBuffer.append("/");
                }
                stringBuffer.append(stringArray[i]);
            }
            String string3 = stringBuffer.toString();
            ContentProvider contentProvider = ContentProvider.getProvider(string3, this.m_connect, this.m_cookies, this);
            if (this.m_isSimplified) {
                this.m_responseNamespace = this.getSimplifiedResponseNamespace(contentProvider);
            }
            return contentProvider;
        }
        catch (CCSGeneralException cCSGeneralException) {
            throw cCSGeneralException;
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new CCSGeneralException("REQUEST_ERROR", 400);
        }
    }

    @Override
    public Cognos8Connector getConnect() {
        return this.m_connect;
    }

    public Cookie[] getCookies() {
        return this.m_cookies;
    }

    public Transport getTransport() {
        return this.m_transport;
    }

    public CCSResponder getResponder() {
        return this.m_responder;
    }

    public BIBusEnvelope getResponse() {
        return this.m_response;
    }

    public void setResponseAsString(String string) {
        this.logTrace(string);
        this.m_responder.setBuffer(string, this.m_transport);
    }

    public void setSOAPResponse(Element element) {
        this.m_response.getBody().add(element);
    }

    public void setSOAPResponse(Element element, CCSDataResult cCSDataResult) {
        this.m_response.getBody().add(element);
        if (null != cCSDataResult) {
            this.m_responder.setData(cCSDataResult);
        }
    }

    public void updateConversation(Conversation conversation, String string) throws CCSGeneralException {
        Cognos8Connector cognos8Connector = this.getConnect();
        ConversationCache conversationCache = cognos8Connector.conversationCache();
        conversationCache.updateConversation(string, conversation);
    }

    public String saveConversation(Conversation conversation) throws CCSGeneralException, CCSAuthenticationException {
        Cognos8Connector cognos8Connector = this.getConnect();
        ConversationCache conversationCache = cognos8Connector.conversationCache();
        String string = conversationCache.addConversation(conversation);
        return string;
    }

    public void deleteConversation(String string) {
        Cognos8Connector cognos8Connector = this.getConnect();
        ConversationCache conversationCache = cognos8Connector.conversationCache();
        conversationCache.deleteConversation(string);
    }

    public Conversation recoverConversation(String string) throws CCSGeneralException, CCSAuthenticationException {
        Conversation conversation = null;
        if (string != null) {
            ConversationCache conversationCache = this.m_connect.conversationCache();
            conversation = conversationCache.getConversation(string);
        }
        return conversation;
    }

    public synchronized FormatLoader getFormatLoader() {
        if (m_loader == null) {
            m_loader = new FormatLoader();
        }
        return m_loader;
    }

    protected Namespace getSimplifiedResponseNamespace(ContentProvider contentProvider) throws CCSAuthenticationException, CCSGeneralException {
        String string = "http://developer.cognos.com/schemas/raas/";
        String string2 = contentProvider.getReportName();
        string2 = string2 == null ? "1" : CCSFormatter.encodeName(string2);
        return new Namespace("", string + string2);
    }

    public String getWebcontentRoot() {
        if (null != this.webcontent) {
            return this.webcontent;
        }
        return DEFAULT_WEBCONTENT;
    }

    public void generateConversationContext() {
        this.m_response.setConversationContextID(this.m_request.getTrackingRequestContext());
        this.m_response.setConversationContextNodeID(NodeID.getSelf().getGuid());
        this.m_response.setConversationContextProcessID(-1);
        this.m_response.setConversationContextAffinityStrength(5000);
        this.m_response.setConversationContextStatus("complete");
    }

    public void clearConversationContext() {
        this.m_response.clearConversationContext();
    }

    public BIBusEnvelope getRequestEnvelope() {
        return this.m_request;
    }

    public BIBusEnvelope getResponseEnvelope() {
        return this.m_response;
    }

    public void setConnect(Cognos8Connector cognos8Connector) {
        this.m_connect = cognos8Connector;
    }
}

