/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.ccs.service;

import com.cognos.cclcfgapi.CCLConfigurationException;
import com.cognos.cclcfgapi.ICCLConfiguration;
import com.cognos.ccs.service.CCLConfigurationStub;
import com.cognos.ccs.service.CCLMessage;
import com.cognos.ccs.service.CCSLogger;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Properties;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;

public class ConfigMgr {
    private static ConfigMgr m_Singleton = null;
    private static Object mutex = new Object();
    private long m_DataLimit = 10240000L;
    private String m_FilePath = "";
    private String m_CrnDispatcher = "http://localhost:9300/p2pd/servlet/dispatch";
    private String m_CrnGateway = "http://localhost:80/crn/cgi-bin/cognos.cgi";
    private String m_AuditLevel = null;
    private ICCLConfiguration m_C8Config = null;
    private HashMap m_PPMappings;
    private boolean m_bCookieSecure = false;
    private String m_sCookieDomain = null;
    private String m_sCookiePath = null;
    private Locale m_ServerLocale = null;
    private String m_collaborationService = null;
    private String m_collaborationServiceURI = null;
    private Properties m_advancedSettings = new Properties();
    private boolean m_generateUniqueCssStyleNames = false;
    static final String ADV_SETTINGS_CSS_STYLE_NAMES = "rdsGenerateUniqueCssStyleNames";
    static final String KEY_ADVANCED_SETTINGS = "advancedSettings";
    static final String KEY_ADV_SETTINGS_SETTING = "setting";
    static final String KEY_ADV_SETTINGS_NAME = "name";

    public static synchronized ConfigMgr getInstance() {
        if (m_Singleton == null) {
            m_Singleton = new ConfigMgr();
            if (System.getProperty("ccstestrun") != null) {
                CCLConfigurationStub cCLConfigurationStub = new CCLConfigurationStub();
                ConfigMgr.m_Singleton.m_C8Config = cCLConfigurationStub;
            }
        }
        return m_Singleton;
    }

    public static Locale getJavaLocale(String string) {
        Locale locale = null;
        if (null == string || string.equals("")) {
            locale = Locale.getDefault();
            CCSLogger.getInstance().logRuntimeErrorMessage(CCLMessage.getResMessage("ERRSYSTEMLOCALE", locale), "", null, null, null);
        } else {
            int n = string.indexOf(45);
            locale = n == -1 ? new Locale(string, "") : new Locale(string.substring(0, n), string.substring(n + 1));
        }
        return locale;
    }

    private ConfigMgr() {
        this.m_PPMappings = new HashMap();
    }

    public String getCognosDispatcher() {
        return this.m_CrnDispatcher;
    }

    public String getCognosGateway() {
        return this.m_CrnGateway;
    }

    public String getCookieDomain() {
        return this.m_sCookieDomain;
    }

    public String getCookiePath() {
        return this.m_sCookiePath;
    }

    public boolean getCookieSecure() {
        return this.m_bCookieSecure;
    }

    public long getDataLimit() {
        return this.m_DataLimit;
    }

    public boolean generateUniqueCssStyleNames() {
        return this.m_generateUniqueCssStyleNames;
    }

    public String getFilePath() {
        return this.m_FilePath;
    }

    public void setFilePath(String string) {
        this.m_FilePath = string;
    }

    public InputStream getFileStream(String string) {
        InputStream inputStream = null;
        try {
            if (System.getProperty("ccstestrun") != null) {
                String string2 = System.getProperty("ccstestpath");
                String string3 = (string2 != null ? string2 : "") + "prod/templates/ccs";
                try {
                    FileInputStream fileInputStream = new FileInputStream(string3 + string);
                    return fileInputStream;
                }
                catch (FileNotFoundException fileNotFoundException) {
                    return null;
                }
            }
            FileInputStream fileInputStream = new FileInputStream(this.m_FilePath + string);
            return fileInputStream;
        }
        catch (Exception exception) {
            CCSLogger.getInstance().logRuntimeErrorMessage(CCLMessage.getResMessage("FAILFILEERROR", new String[]{string}, this.m_ServerLocale), "", null, null, null);
            return inputStream;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getPPMapping(String string) {
        String string2;
        Object object = mutex;
        synchronized (object) {
            string2 = (String)this.m_PPMappings.get(string.toUpperCase());
        }
        if (string2 != null) {
            return string2;
        }
        return string;
    }

    public Locale getServerLocale() {
        if (this.m_ServerLocale == null) {
            return Locale.getDefault();
        }
        return this.m_ServerLocale;
    }

    public String mapContentLocale(String string) {
        try {
            if (this.m_C8Config != null) {
                return this.m_C8Config.normalizeLocale(string);
            }
        }
        catch (CCLConfigurationException cCLConfigurationException) {
            // empty catch block
        }
        return string;
    }

    public String mapProductLocale(String string) {
        try {
            if (this.m_C8Config != null) {
                return this.m_C8Config.mapProductLocale(string, true);
            }
        }
        catch (CCLConfigurationException cCLConfigurationException) {
            // empty catch block
        }
        return string;
    }

    public void populateConfig(ICCLConfiguration iCCLConfiguration) {
        try {
            Object object;
            Iterator iterator;
            Element element;
            this.m_C8Config = iCCLConfiguration;
            this.m_CrnDispatcher = iCCLConfiguration.getValue("internalDispatcher", true);
            this.m_CrnGateway = iCCLConfiguration.getValue("gateway", true);
            this.m_sCookieDomain = iCCLConfiguration.getValue("cookieDomain", true);
            this.m_sCookiePath = iCCLConfiguration.getValue("cookiePath", true);
            Element element2 = iCCLConfiguration.getValueElement("rdsGatewayMappings", true);
            String string = iCCLConfiguration.getValue("serverLocale", true);
            this.m_ServerLocale = ConfigMgr.getJavaLocale(string);
            String string2 = iCCLConfiguration.getValue("cookieSecure", true);
            if (string2 != null) {
                this.m_bCookieSecure = Boolean.getBoolean(string2);
            }
            this.m_FilePath = iCCLConfiguration.resolveEffectivePath("../templates/ccs");
            String string3 = iCCLConfiguration.getValue("rdsMaximumDataSize", true);
            long l = Long.parseLong(string3);
            this.m_DataLimit = l = l * 1024L * 1024L;
            this.m_AuditLevel = iCCLConfiguration.getValue("rdsAuditLevel", true);
            this.loadAdvancedSettings(iCCLConfiguration);
            if (this.m_advancedSettings != null) {
                this.m_generateUniqueCssStyleNames = Boolean.parseBoolean(this.m_advancedSettings.getProperty(ADV_SETTINGS_CSS_STYLE_NAMES, Boolean.toString(Boolean.FALSE)));
            }
            if (null != (element = iCCLConfiguration.getValueElement("HTS", true))) {
                iterator = element.elementIterator("parameter");
                while (iterator.hasNext()) {
                    object = (Element)iterator.next();
                    if (object.attributeValue(KEY_ADV_SETTINGS_NAME).equals("htsCollaborationService")) {
                        this.m_collaborationService = object.elementText("value");
                    }
                    if (!object.attributeValue(KEY_ADV_SETTINGS_NAME).equals("collaborationServiceURI")) continue;
                    this.m_collaborationServiceURI = object.elementText("value");
                }
            }
            if (null != element2) {
                iterator = element2.getDocument();
                if (iterator == null) {
                    iterator = DocumentHelper.createDocument();
                    iterator.add(element2);
                }
                object = iterator.selectNodes("//crn:value/value/*");
                Iterator iterator2 = object.iterator();
                while (iterator2.hasNext()) {
                    Element element3 = (Element)iterator2.next();
                    if (element3.element("externalURI") == null || element3.element("internalURI") == null) continue;
                    String string4 = element3.element("externalURI").getText().toUpperCase();
                    String string5 = element3.element("internalURI").getText();
                    this.m_PPMappings.put(string4, string5);
                }
            }
        }
        catch (CCLConfigurationException cCLConfigurationException) {
            CCSLogger.getInstance().logRuntimeErrorMessage(CCLMessage.getResMessage("ERRUPDATECONFIG", Locale.getDefault()), "", null, null, null);
        }
    }

    private void loadAdvancedSettings(ICCLConfiguration iCCLConfiguration) throws CCLConfigurationException {
        String string;
        Element element = iCCLConfiguration.getValueElement(KEY_ADVANCED_SETTINGS, true);
        if (element != null && (string = element.getText()) != null) {
            StringReader stringReader = new StringReader(string);
            SAXReader sAXReader = new SAXReader();
            try {
                Document document = sAXReader.read((Reader)stringReader);
                Element element2 = document.getRootElement();
                Iterator iterator = element2.elementIterator(KEY_ADV_SETTINGS_SETTING);
                while (iterator.hasNext()) {
                    Element element3 = (Element)iterator.next();
                    String string2 = element3.attributeValue(KEY_ADV_SETTINGS_NAME);
                    String string3 = element3.getText();
                    if (string2 == null) continue;
                    this.m_advancedSettings.put(string2, string3);
                }
            }
            catch (DocumentException documentException) {
                CCSLogger.getInstance().logRuntimeErrorMessage(CCLMessage.getResMessage("ERRUPDATECONFIG", Locale.getDefault()), "", null, null, null);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateConfiguration(ICCLConfiguration iCCLConfiguration) {
        block18: {
            try {
                Object object;
                Object object2;
                Object object3;
                String string = iCCLConfiguration.getValue("rdsMaximumDataSize", true);
                long l = Long.parseLong(string);
                l = l * 1024L * 1024L;
                if (l != this.m_DataLimit) {
                    object3 = mutex;
                    synchronized (object3) {
                        this.m_DataLimit = l;
                    }
                }
                if ((object3 = iCCLConfiguration.getValueElement("rdsGatewayMappings", true)) != null) {
                    object2 = object3.getDocument();
                    if (object2 == null) {
                        object2 = DocumentHelper.createDocument();
                        object2.add((Element)object3);
                    }
                    object = object2.selectNodes("//crn:value/value/*");
                    Iterator iterator = object.iterator();
                    while (iterator.hasNext()) {
                        Element element = (Element)iterator.next();
                        if (element.element("externalURI") == null || element.element("internalURI") == null) continue;
                        String string2 = element.element("externalURI").getText().toUpperCase();
                        String string3 = element.element("internalURI").getText();
                        Object object4 = mutex;
                        synchronized (object4) {
                            if (!string3.equals((String)this.m_PPMappings.get(string2))) {
                                this.m_PPMappings.put(string2, string3);
                                break;
                            }
                            if (this.m_PPMappings.get(string2) == null) {
                                this.m_PPMappings.put(string2, string3);
                                break;
                            }
                        }
                    }
                }
                if ((object2 = iCCLConfiguration.getValue("rdsAuditLevel", true)) == this.m_AuditLevel) break block18;
                object = mutex;
                synchronized (object) {
                    this.m_AuditLevel = object2;
                }
            }
            catch (NumberFormatException numberFormatException) {
                StringWriter stringWriter = new StringWriter();
                PrintWriter printWriter = new PrintWriter(stringWriter);
                numberFormatException.printStackTrace(printWriter);
                CCSLogger.getInstance().logRuntimeErrorMessage(CCLMessage.getResMessage("ERRUPDATECONFIG", this.m_ServerLocale), "", null, null, stringWriter.toString());
            }
            catch (CCLConfigurationException cCLConfigurationException) {
                StringWriter stringWriter = new StringWriter();
                PrintWriter printWriter = new PrintWriter(stringWriter);
                cCLConfigurationException.printStackTrace(printWriter);
                CCSLogger.getInstance().logRuntimeErrorMessage(CCLMessage.getResMessage("ERRUPDATECONFIG", this.m_ServerLocale), "", null, null, stringWriter.toString());
            }
        }
    }

    public String getCollaborationService() {
        return this.m_collaborationService;
    }

    public String getCollaborationServiceURI() {
        return this.m_collaborationServiceURI;
    }

    public void setGatewayForTest(String string) {
        this.m_CrnGateway = string;
    }
}

