/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.ccs.service;

import com.cognos.ccs.service.CommandSession;
import com.cognos.ccs.service.ManagedAttachment;
import com.cognos.developer.schemas.bibus._3.AsynchRequest;
import com.cognos.developer.schemas.bibus._3.AsynchSpecification;
import com.cognos.developer.schemas.bibus._3.BiBusHeader;
import com.cognos.developer.schemas.bibus._3.CookieVar;
import com.cognos.developer.schemas.bibus._3.Option;
import com.cognos.developer.schemas.bibus._3.ParameterValue;
import com.cognos.developer.schemas.bibus._3.SearchPathSingleObject;
import com.cognos.developer.schemas.bibus._3.SetCookieVar;
import com.cognos.developer.schemas.bibus._3.XmlEncodedXML;
import com.cognos.pogo.pdk.MessageContext;
import java.io.Serializable;
import java.util.HashMap;
import org.apache.commons.httpclient.Cookie;

public class Conversation
implements Serializable {
    private static final String NULL_VALUE = "NULL";
    private static final String STATE_DATA_KEY = ".stateData";
    private static final String SPECIFICATION_KEY = ".specification";
    private static final String PARAMETERS_KEY = ".parameters";
    private static final String OPTIONS_KEY = ".options";
    private static final String SEARCH_PATH_KEY = ".searchPath";
    private static final String OPERATION_KEY = ".operation";
    private static final long serialVersionUID = -5468735786439L;
    public AsynchRequest m_Req;
    private BiBusHeader m_Hdr;
    private HashMap properties = new HashMap();
    private transient ManagedAttachment attachment;

    public Conversation(BiBusHeader biBusHeader) {
        this.m_Hdr = biBusHeader;
    }

    public void setHeader(BiBusHeader biBusHeader) {
        this.m_Hdr = biBusHeader;
    }

    public BiBusHeader getHeader() {
        return this.m_Hdr;
    }

    public void setProperty(String string, Object object) {
        this.properties.put(string, object);
    }

    public Object getProperty(String string) {
        return this.properties.get(string);
    }

    public void removeProperty(String string) {
        this.properties.remove(string);
    }

    public void setAttachement(ManagedAttachment managedAttachment) {
        this.attachment = managedAttachment;
    }

    public ManagedAttachment getAttachment() {
        return this.attachment;
    }

    public static void serializeAsyncRequest(Conversation conversation, AsynchRequest asynchRequest, String string) {
        if (asynchRequest == null) {
            conversation.setProperty(string, NULL_VALUE);
            return;
        }
        conversation.setProperty(string + OPERATION_KEY, asynchRequest.getName());
        conversation.setProperty(string + SEARCH_PATH_KEY, asynchRequest.getObjectPath());
        conversation.setProperty(string + OPTIONS_KEY, asynchRequest.getOptions());
        conversation.setProperty(string + PARAMETERS_KEY, asynchRequest.getParameters());
        conversation.setProperty(string + SPECIFICATION_KEY, asynchRequest.getSpecification());
        conversation.setProperty(string + STATE_DATA_KEY, asynchRequest.getStateData());
        conversation.removeProperty(string);
    }

    public static AsynchRequest deserializeAsyncRequest(Conversation conversation, String string) {
        String string2 = (String)conversation.getProperty(string);
        if (null != string2) {
            return null;
        }
        AsynchRequest asynchRequest = new AsynchRequest();
        asynchRequest.setName((String)conversation.getProperty(string + OPERATION_KEY));
        asynchRequest.setObjectPath((SearchPathSingleObject)conversation.getProperty(string + SEARCH_PATH_KEY));
        asynchRequest.setOptions((Option[])conversation.getProperty(string + OPTIONS_KEY));
        asynchRequest.setParameters((ParameterValue[])conversation.getProperty(string + PARAMETERS_KEY));
        asynchRequest.setSpecification((AsynchSpecification[])conversation.getProperty(string + SPECIFICATION_KEY));
        asynchRequest.setStateData((XmlEncodedXML)conversation.getProperty(string + STATE_DATA_KEY));
        return asynchRequest;
    }

    public void embedImagesUpdate(boolean bl, CommandSession commandSession, MessageContext messageContext) {
        Cookie[] cookieArray;
        this.setProperty("embedImages", new Boolean(bl));
        if (bl && null != (cookieArray = commandSession.getCookies())) {
            Cookie cookie;
            this.setProperty("cookies", cookieArray);
            CookieVar[] cookieVarArray = new CookieVar[cookieArray.length];
            SetCookieVar[] setCookieVarArray = new SetCookieVar[cookieArray.length];
            for (int i = 0; i < cookieArray.length; ++i) {
                SetCookieVar setCookieVar;
                CookieVar cookieVar;
                cookie = cookieArray[i];
                String string = cookie.getDomain();
                String string2 = cookie.getName();
                String string3 = cookie.getPath();
                boolean bl2 = cookie.getSecure();
                String string4 = cookie.getValue();
                cookieVarArray[i] = cookieVar = new CookieVar(string2, string4);
                setCookieVarArray[i] = setCookieVar = new SetCookieVar(string, -1, string2, string3, bl2, string4);
            }
            BiBusHeader biBusHeader = this.getHeader();
            cookie = biBusHeader.getHdrSession();
            cookie.setCookieVars(cookieVarArray);
            cookie.setSetCookieVars(setCookieVarArray);
        }
    }
}

