/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.ccs.service;

import com.cognos.ccs.exceptions.CCSGeneralException;
import com.cognos.ccs.service.CCSLogger;
import com.cognos.developer.schemas.bibus._3.BiBusHeader;
import com.cognos.developer.schemas.bibus._3.CAF;
import com.cognos.developer.schemas.bibus._3.CAM;
import com.cognos.developer.schemas.bibus._3.CAMPassport;
import com.cognos.developer.schemas.bibus._3.ContentManagerService_PortType;
import com.cognos.developer.schemas.bibus._3.ContentManagerService_ServiceLocator;
import com.cognos.developer.schemas.bibus._3.CookieVar;
import com.cognos.developer.schemas.bibus._3.EnvironmentVar;
import com.cognos.developer.schemas.bibus._3.HdrSession;
import com.cognos.developer.schemas.bibus._3.PowerPlayService_PortType;
import com.cognos.developer.schemas.bibus._3.PowerPlayService_ServiceLocator;
import com.cognos.developer.schemas.bibus._3.ReportService_PortType;
import com.cognos.developer.schemas.bibus._3.ReportService_ServiceLocator;
import com.cognos.developer.schemas.bibus._3.SetCookieVar;
import com.cognos.developer.schemas.bibus._3.UserCapabilityCache;
import com.cognos.developer.schemas.bibus._3.UserCapabilityEnum;
import com.cognos.developer.schemas.bibus._3.UserPreferenceVar;
import com.cognos.pogo.pdk.BIBusEnvelope;
import java.lang.reflect.Field;
import java.net.URL;
import java.rmi.RemoteException;
import java.util.Hashtable;
import java.util.Iterator;
import org.apache.axis.client.Stub;
import org.apache.axis.encoding.Base64;
import org.apache.axis.message.SOAPHeaderElement;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.QName;

public class CrnConnector {
    protected ReportService_PortType m_CognosRS;
    protected ReportService_ServiceLocator m_CognosRSLocator;
    protected ContentManagerService_PortType m_CognosCM;
    protected ContentManagerService_ServiceLocator m_CognosCMLocator;
    protected PowerPlayService_PortType m_PowerPlay;
    protected PowerPlayService_ServiceLocator m_PowerPlayLocator;
    private String m_GatewayURL;

    public CrnConnector(String string) {
        this.m_GatewayURL = string;
        System.setProperty("axis.socketSecureFactory", "org.apache.axis.components.net.SunFakeTrustSocketFactory");
    }

    public void connectToReportServer() throws CCSGeneralException {
        String string = this.m_GatewayURL;
        this.m_CognosRSLocator = new ReportService_ServiceLocator();
        this.m_CognosCMLocator = new ContentManagerService_ServiceLocator();
        this.m_PowerPlayLocator = new PowerPlayService_ServiceLocator();
        try {
            this.m_PowerPlay = this.m_PowerPlayLocator.getpowerPlayService(new URL(string));
            ((Stub)this.m_PowerPlay)._setProperty("sendMultiRefs", (Object)Boolean.FALSE);
            this.m_CognosRS = this.m_CognosRSLocator.getreportService(new URL(string));
            ((Stub)this.m_CognosRS)._setProperty("sendMultiRefs", (Object)Boolean.FALSE);
            this.m_CognosCM = this.m_CognosCMLocator.getcontentManagerService(new URL(string));
            ((Stub)this.m_CognosCM)._setProperty("sendMultiRefs", (Object)Boolean.FALSE);
            Hashtable<String, String> hashtable = new Hashtable<String, String>();
            hashtable.put("Cognos-Gateway", "false");
            this.getCognosCMServiceStub()._setProperty("HTTP-Request-Headers", hashtable);
        }
        catch (Exception exception) {
            throw new CCSGeneralException("CRN_CONNECT_ERROR", exception, 500);
        }
        ((Stub)this.m_CognosCM).setHeader("http://developer.cognos.com/schemas/bibus/3/", "biBusHeader", (Object)new BiBusHeader());
        this.syncHeadersToCM();
    }

    public void populateSDKBiBus(BIBusEnvelope bIBusEnvelope) {
        Element element;
        UserPreferenceVar[] userPreferenceVarArray;
        Element element2;
        Iterator iterator;
        Object object;
        CookieVar[] cookieVarArray;
        CAM cAM;
        CAMPassport cAMPassport;
        BiBusHeader biBusHeader = this.getCMBus();
        if (biBusHeader.getCAM() == null) {
            biBusHeader.setCAM(new CAM());
        }
        if (null == (cAMPassport = (cAM = biBusHeader.getCAM()).getCAMPassport())) {
            cAMPassport = new CAMPassport();
        }
        cAMPassport.setId(bIBusEnvelope.getPassportID());
        cAM.setCAMPassport(cAMPassport);
        if (cAM.getException() != null) {
            cAM.setException(null);
        }
        if (biBusHeader.getCAF() == null) {
            biBusHeader.setCAF(new CAF());
        }
        CAF cAF = biBusHeader.getCAF();
        cAF.setSecureState(bIBusEnvelope.getCAFSecureState());
        Element element3 = bIBusEnvelope.getCookieVars();
        if (element3 != null) {
            cookieVarArray = new CookieVar[element3.elements("item").size()];
            object = element3.elementIterator("item");
            int n = 0;
            while (object.hasNext()) {
                iterator = new CookieVar();
                Element element4 = (Element)object.next();
                element2 = element4.element("name");
                userPreferenceVarArray = element4.element("value");
                if (element2 != null) {
                    iterator.setName(element2.getTextTrim());
                }
                if (userPreferenceVarArray != null) {
                    iterator.setValue(userPreferenceVarArray.getTextTrim());
                }
                cookieVarArray[n] = iterator;
                ++n;
            }
            if (biBusHeader.getHdrSession() == null) {
                biBusHeader.setHdrSession(new HdrSession());
            }
            biBusHeader.getHdrSession().setCookieVars(cookieVarArray);
        }
        cookieVarArray = bIBusEnvelope.getEnvironmentVars();
        object = new EnvironmentVar[cookieVarArray.elements("item").size()];
        iterator = cookieVarArray.elementIterator("item");
        int n = 0;
        while (iterator.hasNext()) {
            EnvironmentVar environmentVar = new EnvironmentVar();
            element2 = (Element)iterator.next();
            userPreferenceVarArray = element2.element("name");
            element = element2.element("value");
            if (userPreferenceVarArray != null) {
                environmentVar.setName(userPreferenceVarArray.getText());
            }
            if (element != null) {
                environmentVar.setValue(element.getText());
            }
            object[n] = environmentVar;
            ++n;
        }
        biBusHeader.getHdrSession().setEnvironmentVars((EnvironmentVar[])object);
        element2 = bIBusEnvelope.getUserPreferenceVars();
        userPreferenceVarArray = new UserPreferenceVar[element2.elements("item").size()];
        Iterator iterator2 = element2.elementIterator("item");
        n = 0;
        while (iterator2.hasNext()) {
            element = new UserPreferenceVar();
            Element element5 = (Element)iterator2.next();
            Element element6 = element5.element("name");
            Element element7 = element5.element("value");
            if (element6 != null) {
                element.setName(element6.getText());
            }
            if (element7 != null) {
                element.setValue(element7.getText());
            }
            userPreferenceVarArray[n] = element;
            ++n;
        }
        biBusHeader.setUserPreferenceVars(userPreferenceVarArray);
        this.copyUserCapabilityCacheToSDK(bIBusEnvelope, biBusHeader, iterator2, n);
        this.setServiceHeaders(biBusHeader);
    }

    protected void setServiceHeaders(BiBusHeader biBusHeader) {
        Stub stub = (Stub)this.m_CognosRS;
        Stub stub2 = (Stub)this.m_CognosCM;
        Stub stub3 = (Stub)this.m_PowerPlay;
        stub.clearHeaders();
        stub2.clearHeaders();
        stub3.clearHeaders();
        stub.setHeader("http://developer.cognos.com/schemas/bibus/3/", "biBusHeader", (Object)biBusHeader);
        stub2.setHeader("http://developer.cognos.com/schemas/bibus/3/", "biBusHeader", (Object)biBusHeader);
        stub3.setHeader("http://developer.cognos.com/schemas/bibus/3/", "biBusHeader", (Object)biBusHeader);
    }

    private void copyUserCapabilityCacheToSDK(BIBusEnvelope bIBusEnvelope, BiBusHeader biBusHeader, Iterator iterator, int n) {
        try {
            Element element;
            if (bIBusEnvelope.getUserCapabilitiesCache() == null) {
                return;
            }
            Element element2 = bIBusEnvelope.getUserCapabilitiesCache().element("signature");
            if (element2 == null) {
                return;
            }
            byte[] byArray = Base64.decode((String)element2.getText());
            Element element3 = bIBusEnvelope.getUserCapabilitiesCache().element("userCapabilities");
            UserCapabilityEnum[] userCapabilityEnumArray = new UserCapabilityEnum[element3.elements("item").size()];
            iterator = element3.elements("item").iterator();
            if (userCapabilityEnumArray.length == 0) {
                userCapabilityEnumArray = new UserCapabilityEnum[bIBusEnvelope.getUserCapabilitiesCache().elements("userCapabilities").size()];
                iterator = bIBusEnvelope.getUserCapabilitiesCache().elementIterator("userCapabilities");
            }
            n = 0;
            while (iterator.hasNext()) {
                element = (Element)iterator.next();
                userCapabilityEnumArray[n] = this.getEnumForValue(element.getText());
                ++n;
            }
            element = new UserCapabilityCache();
            element.setUserCapabilities(userCapabilityEnumArray);
            element.setSignature(byArray);
            biBusHeader.setUserCapabilityCache((UserCapabilityCache)element);
        }
        catch (CCSGeneralException cCSGeneralException) {
            CCSLogger.getInstance().logRuntimeErrorMessage(cCSGeneralException.getServerLocaleMessage(), null, null, null, cCSGeneralException.getSourceTrace());
            biBusHeader.setUserCapabilityCache(new UserCapabilityCache());
        }
    }

    public UserCapabilityEnum getEnumForValue(String string) throws CCSGeneralException {
        try {
            Class<UserCapabilityEnum> clazz = UserCapabilityEnum.class;
            Field field = clazz.getField(string);
            return (UserCapabilityEnum)field.get(UserCapabilityEnum.canReceiveDetailedErrors);
        }
        catch (Exception exception) {
            throw new CCSGeneralException("REQUEST_ERROR", 500);
        }
    }

    public void populateCCSBiBusFromRS(BIBusEnvelope bIBusEnvelope) {
        BiBusHeader biBusHeader = this.getRSBus();
        this.populateCCSBiBusFromSDKHeader(biBusHeader, bIBusEnvelope);
    }

    public void populateCCSBiBusFromCM(BIBusEnvelope bIBusEnvelope) {
        BiBusHeader biBusHeader = this.getCMBus();
        this.populateCCSBiBusFromSDKHeader(biBusHeader, bIBusEnvelope);
    }

    private void populateCCSBiBusFromSDKHeader(BiBusHeader biBusHeader, BIBusEnvelope bIBusEnvelope) {
        SetCookieVar[] setCookieVarArray;
        CookieVar[] cookieVarArray;
        UserPreferenceVar[] userPreferenceVarArray;
        if (biBusHeader.getCAM() != null) {
            Element element;
            Element element2;
            userPreferenceVarArray = bIBusEnvelope.getCAM();
            if (null != userPreferenceVarArray) {
                userPreferenceVarArray.detach();
            }
            cookieVarArray = DocumentHelper.createElement((QName)BIBusEnvelope.BUS_CAM);
            cookieVarArray.addAttribute(BIBusEnvelope.XSI_TYPE, cookieVarArray.getQualifiedName());
            if (biBusHeader.getCAM().getCAMPassport() != null && biBusHeader.getCAM().getCAMPassport().getId() != null) {
                element2 = cookieVarArray.addElement(BIBusEnvelope.BUS_CAMPASSPORT);
                element2.addAttribute(BIBusEnvelope.XSI_TYPE, element2.getQualifiedName());
                element = element2.addElement("id");
                element.addAttribute(BIBusEnvelope.XSI_TYPE, BIBusEnvelope.XSD_STRING);
                element.setText(biBusHeader.getCAM().getCAMPassport().getId());
            } else if (biBusHeader.getCAM().getException() != null) {
                element2 = cookieVarArray.addElement("exception");
                element2.addAttribute(BIBusEnvelope.XSI_TYPE, "bus:CAMException");
                element = element2.addElement("errorCodeString");
                element.addAttribute(BIBusEnvelope.XSI_TYPE, BIBusEnvelope.XSD_STRING);
                element.setText(biBusHeader.getCAM().getException().getErrorCodeString());
            }
            bIBusEnvelope.setCAM((Element)cookieVarArray);
        }
        if (biBusHeader.getCAF() != null) {
            bIBusEnvelope.setCAFSecureState(biBusHeader.getCAF().getSecureState());
        }
        if ((userPreferenceVarArray = biBusHeader.getUserPreferenceVars()) != null) {
            for (int i = 0; i < userPreferenceVarArray.length; ++i) {
                bIBusEnvelope.setUserPreference(userPreferenceVarArray[i].getName(), userPreferenceVarArray[i].getValue());
            }
        }
        if (biBusHeader.getHdrSession() == null) {
            return;
        }
        cookieVarArray = biBusHeader.getHdrSession().getCookieVars();
        if (cookieVarArray != null) {
            for (int i = 0; i < cookieVarArray.length; ++i) {
                bIBusEnvelope.setCookie(cookieVarArray[i].getName(), cookieVarArray[i].getValue());
            }
        }
        if ((setCookieVarArray = biBusHeader.getHdrSession().getSetCookieVars()) != null) {
            for (int i = 0; i < setCookieVarArray.length; ++i) {
                bIBusEnvelope.getBiBusHeader().getHdrSession().getSetCookieVars().setSetCookie(setCookieVarArray[i].getName(), setCookieVarArray[i].getValue());
            }
        }
    }

    public void logoffAll() throws CCSGeneralException {
        try {
            this.m_CognosCM.logoff();
            BiBusHeader biBusHeader = (BiBusHeader)((Stub)this.m_CognosCM).getHeader("", "biBusHeader").getObjectValue();
            ((Stub)this.m_CognosRS).setHeader("", "biBusHeader", (Object)biBusHeader);
        }
        catch (RemoteException remoteException) {
            throw new CCSGeneralException("CRN_LOGOFF_ERROR", remoteException, 500);
        }
    }

    public String getLocale() throws CCSGeneralException {
        try {
            BiBusHeader biBusHeader = this.getCMBus();
            UserPreferenceVar[] userPreferenceVarArray = biBusHeader.getUserPreferenceVars();
            for (int i = 0; i < userPreferenceVarArray.length; ++i) {
                String string;
                if (userPreferenceVarArray[i].getName().equalsIgnoreCase("contentLocale") && !(string = userPreferenceVarArray[i].getValue()).equals("")) {
                    return string;
                }
                if (!userPreferenceVarArray[i].getName().equalsIgnoreCase("productLocale")) continue;
                return userPreferenceVarArray[i].getValue();
            }
            return "en-us";
        }
        catch (Exception exception) {
            throw new CCSGeneralException("CRN_GET_LOCALE_ERROR", exception, 500);
        }
    }

    public ContentManagerService_PortType getCognosCMService() {
        return this.m_CognosCM;
    }

    public Stub getCognosCMServiceStub() {
        return (Stub)this.m_CognosCM;
    }

    public ReportService_PortType getCognos8RS() {
        return this.m_CognosRS;
    }

    public PowerPlayService_PortType getCognosPowerPlay() {
        return this.m_PowerPlay;
    }

    public void syncHeadersToRS() {
        BiBusHeader biBusHeader = this.getRSBus();
        this.setServiceHeaders(biBusHeader);
    }

    public void syncHeadersToCM() {
        BiBusHeader biBusHeader = this.getCMBus();
        this.setServiceHeaders(biBusHeader);
    }

    public void syncHeadersToPP() {
        BiBusHeader biBusHeader = this.getPPBus();
        this.setServiceHeaders(biBusHeader);
    }

    public BiBusHeader getPPBus() {
        SOAPHeaderElement sOAPHeaderElement = ((Stub)this.m_PowerPlay).getResponseHeader("http://developer.cognos.com/schemas/bibus/3/", "biBusHeader");
        if (sOAPHeaderElement == null) {
            sOAPHeaderElement = ((Stub)this.m_PowerPlay).getHeader("http://developer.cognos.com/schemas/bibus/3/", "biBusHeader");
        }
        return (BiBusHeader)sOAPHeaderElement.getObjectValue();
    }

    public BiBusHeader getCMBus() {
        SOAPHeaderElement sOAPHeaderElement = ((Stub)this.m_CognosCM).getResponseHeader("http://developer.cognos.com/schemas/bibus/3/", "biBusHeader");
        if (sOAPHeaderElement == null) {
            sOAPHeaderElement = ((Stub)this.m_CognosCM).getHeader("http://developer.cognos.com/schemas/bibus/3/", "biBusHeader");
        }
        return (BiBusHeader)sOAPHeaderElement.getObjectValue();
    }

    public BiBusHeader getCognosRSService() {
        return (BiBusHeader)((Stub)this.m_CognosRS).getHeader("http://developer.cognos.com/schemas/bibus/3/", "biBusHeader").getObjectValue();
    }

    public BiBusHeader getRSBus() {
        SOAPHeaderElement sOAPHeaderElement = ((Stub)this.m_CognosRS).getResponseHeader("http://developer.cognos.com/schemas/bibus/3/", "biBusHeader");
        if (sOAPHeaderElement == null) {
            sOAPHeaderElement = ((Stub)this.m_CognosRS).getHeader("http://developer.cognos.com/schemas/bibus/3/", "biBusHeader");
        }
        return (BiBusHeader)sOAPHeaderElement.getObjectValue();
    }
}

