/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.ccs.service;

import com.cognos.ccs.content.ContentProvider;
import com.cognos.ccs.exceptions.CCSGeneralException;
import com.cognos.ccs.exceptions.CCSGovernorException;
import com.cognos.ccs.service.CCSLogger;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;

public class GovernedInputStream
extends BufferedInputStream {
    private long lTotalBytesRead;
    private long lGovernorLimit;
    private String sReportID;

    public GovernedInputStream(String string, long l, InputStream inputStream) {
        super(inputStream);
        this.lTotalBytesRead = 0L;
        this.lGovernorLimit = l;
        this.sReportID = string;
    }

    public GovernedInputStream(String string, long l, long l2, InputStream inputStream) {
        super(inputStream);
        this.lTotalBytesRead = l2;
        this.lGovernorLimit = l;
        this.sReportID = string;
    }

    @Override
    public int read() throws IOException {
        int n = super.read();
        if (n != -1) {
            ++this.lTotalBytesRead;
            if (this.lTotalBytesRead > this.lGovernorLimit) {
                ContentProvider.logGovernorErrorDetails(null, null, null);
                CCSGovernorException cCSGovernorException = new CCSGovernorException("GOVERNOR_ERROR", new String[]{this.sReportID});
                CCSGeneralException cCSGeneralException = new CCSGeneralException("GOVERNOR_ERROR", cCSGovernorException, 400);
                CCSLogger.getInstance().logRuntimeErrorMessage(cCSGeneralException.getServerLocaleMessage(), "com.cognos.ccs.service.GovernedInputStream.read()", null, null, cCSGeneralException.getSourceTrace());
                throw cCSGovernorException;
            }
        }
        return n;
    }

    @Override
    public int read(byte[] byArray, int n, int n2) throws IOException {
        int n3 = super.read(byArray, n, n2);
        if (n3 != -1) {
            this.lTotalBytesRead += (long)n3;
            if (this.lTotalBytesRead > this.lGovernorLimit) {
                ContentProvider.logGovernorErrorDetails(null, null, null);
                CCSGovernorException cCSGovernorException = new CCSGovernorException("GOVERNOR_ERROR", new String[]{this.sReportID});
                CCSGeneralException cCSGeneralException = new CCSGeneralException("GOVERNOR_ERROR", cCSGovernorException, 400);
                CCSLogger.getInstance().logRuntimeErrorMessage(cCSGeneralException.getServerLocaleMessage(), "com.cognos.ccs.service.GovernedInputStream.read()", null, null, cCSGeneralException.getSourceTrace());
                throw cCSGovernorException;
            }
        }
        return n3;
    }

    @Override
    public int read(byte[] byArray) throws IOException {
        int n = super.read(byArray);
        if (n != -1) {
            this.lTotalBytesRead += (long)n;
            if (this.lTotalBytesRead > this.lGovernorLimit) {
                ContentProvider.logGovernorErrorDetails(null, null, null);
                CCSGovernorException cCSGovernorException = new CCSGovernorException("GOVERNOR_ERROR", new String[]{this.sReportID});
                CCSGeneralException cCSGeneralException = new CCSGeneralException("GOVERNOR_ERROR", cCSGovernorException, 400);
                CCSLogger.getInstance().logRuntimeErrorMessage(cCSGeneralException.getServerLocaleMessage(), "com.cognos.ccs.service.GovernedInputStream.read()", null, null, cCSGeneralException.getSourceTrace());
                throw cCSGovernorException;
            }
        }
        return n;
    }

    @Override
    public synchronized void reset() throws IOException {
        super.reset();
        this.lTotalBytesRead = 0L;
    }

    public long getTotalRead() {
        return this.lTotalBytesRead;
    }
}

