/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.ccs.service;

import com.cognos.ccs.content.ContentProvider;
import com.cognos.ccs.exceptions.CCSGeneralException;
import com.cognos.ccs.service.CCSLogger;
import com.cognos.ccs.service.ConfigMgr;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.axis.attachments.AttachmentPart;

public class ManagedAttachment {
    File m_file = null;
    byte[] m_bytes = null;
    String m_contentType = "text/xml";

    public ManagedAttachment(AttachmentPart attachmentPart) throws CCSGeneralException {
        this(attachmentPart, false);
    }

    public ManagedAttachment(AttachmentPart attachmentPart, boolean bl) throws CCSGeneralException {
        String string = attachmentPart.getAttachmentFile();
        String[] stringArray = attachmentPart.getMimeHeader("Content-Type");
        if (stringArray != null && stringArray.length > 0) {
            this.setContentType(stringArray[0]);
        }
        long l = ConfigMgr.getInstance().getDataLimit();
        if (string != null) {
            this.m_file = new File(string);
            attachmentPart.detachAttachmentFile();
            try {
                this.checkSize(bl, true, this.m_file.length(), l);
            }
            catch (CCSGeneralException cCSGeneralException) {
                this.delete();
                throw cCSGeneralException;
            }
            catch (Exception exception) {
                CCSGeneralException cCSGeneralException = new CCSGeneralException("FLRESP_ERROR", exception, 500);
                CCSLogger.getInstance().logRuntimeErrorMessage(cCSGeneralException.getServerLocaleMessage(), null, null, null, cCSGeneralException.getSourceTrace());
            }
        } else {
            try {
                InputStream inputStream = attachmentPart.getActivationDataHandler().getInputStream();
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(16384);
                int n = 0;
                byte[] byArray = new byte[4096];
                int n2 = 0;
                do {
                    if ((n = inputStream.read(byArray)) == -1) continue;
                    this.checkSize(bl, false, n2 += n, l);
                    byteArrayOutputStream.write(byArray, 0, n);
                } while (n != -1);
                this.m_bytes = byteArrayOutputStream.toByteArray();
            }
            catch (CCSGeneralException cCSGeneralException) {
                throw cCSGeneralException;
            }
            catch (Exception exception) {
                CCSGeneralException cCSGeneralException = new CCSGeneralException("REQUEST_ERROR", exception, 500);
                CCSLogger.getInstance().logRuntimeErrorMessage(cCSGeneralException.getServerLocaleMessage(), null, null, null, cCSGeneralException.getSourceTrace());
            }
        }
    }

    public ManagedAttachment(byte[] byArray) {
        this.m_bytes = byArray;
    }

    public ManagedAttachment(InputStream inputStream) {
        OutputStream outputStream;
        try {
            this.m_file = File.createTempFile("ccs", null);
            outputStream = new FileOutputStream(this.m_file);
        }
        catch (Exception exception) {
            outputStream = new ByteArrayOutputStream(16384);
        }
        try {
            int n = 0;
            byte[] byArray = new byte[4096];
            do {
                if ((n = inputStream.read(byArray)) == -1) continue;
                outputStream.write(byArray, 0, n);
                outputStream.flush();
            } while (n != -1);
            outputStream.close();
            if (outputStream instanceof ByteArrayOutputStream) {
                this.m_bytes = ((ByteArrayOutputStream)outputStream).toByteArray();
            }
        }
        catch (Exception exception) {
            CCSGeneralException cCSGeneralException = new CCSGeneralException("REQUEST_ERROR", exception, 500);
            CCSLogger.getInstance().logRuntimeErrorMessage(cCSGeneralException.getServerLocaleMessage(), null, null, null, cCSGeneralException.getSourceTrace());
        }
    }

    private void checkSize(boolean bl, boolean bl2, long l, long l2) throws CCSGeneralException {
        if (bl && l > l2) {
            CCSGeneralException cCSGeneralException = new CCSGeneralException("GOVERNOR_ERROR", 400);
            l = bl2 ? l : 0L;
            ContentProvider.logGovernorErrorDetails(l, null, null);
            throw cCSGeneralException;
        }
    }

    public void delete() {
        if (this.m_file != null) {
            this.m_file.delete();
            this.m_file = null;
        }
    }

    public InputStream getStream() throws CCSGeneralException {
        try {
            if (this.m_file != null) {
                return new FileInputStream(this.m_file);
            }
            return new ByteArrayInputStream(this.m_bytes);
        }
        catch (Exception exception) {
            throw new CCSGeneralException("SERVER_ERROR", exception, 500);
        }
    }

    public void setContentType(String string) {
        this.m_contentType = string;
    }

    public String getContentType() {
        return this.m_contentType;
    }

    public String getCharsetFromContentType() {
        Pattern pattern;
        Matcher matcher;
        String string = null;
        if (this.m_contentType != null && (matcher = (pattern = Pattern.compile("(?i)\\bcharset=\\s*\"?([^\\s;\"]*)")).matcher(this.m_contentType)).find()) {
            string = matcher.group(1).trim().toUpperCase();
        }
        return string;
    }

    protected void finalize() throws Throwable {
        this.delete();
        super.finalize();
    }
}

