/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.ccs.service;

import com.cognos.ccs.auth.AuthService;
import com.cognos.ccs.service.BaseRDSSession;
import com.cognos.ccs.service.CCSLogger;
import com.cognos.ccs.service.CommandSession;
import com.cognos.ccs.service.ConfigMgr;
import com.cognos.pogo.async.AsyncContext;
import com.cognos.pogo.async.AsyncService;
import com.cognos.pogo.async.AsyncServiceBase;
import com.cognos.pogo.async.Asyncable;
import com.cognos.pogo.pdk.BIBusEnvelope;
import com.cognos.pogo.pdk.BasicHandler;
import com.cognos.pogo.pdk.Configuration;
import com.cognos.pogo.pdk.MessageContext;
import com.cognos.pogo.pdk.PogoException;
import com.ibm.cognos.ccs.internal.thumbnailservice.ThumbnailService;
import javax.mail.internet.InternetHeaders;
import org.apache.log.Hierarchy;
import org.apache.log.Logger;
import org.dom4j.Element;

public class RDSServiceHandler2
extends BasicHandler
implements Asyncable {
    private static final Logger logger = Hierarchy.getDefaultHierarchy().getLoggerFor(RDSServiceHandler2.class.getName());
    private ConfigMgr m_cnfMgr = ConfigMgr.getInstance();

    public RDSServiceHandler2() {
        super(logger);
    }

    public void resume() {
    }

    public void start() {
    }

    public void stop() {
        BaseRDSSession.abortAll();
    }

    public void suspend(boolean bl) {
        if (bl) {
            BaseRDSSession.abortAll();
        }
    }

    public void invokeImpl(MessageContext messageContext) throws PogoException {
        boolean bl;
        String string;
        if (CCSLogger.getInstance().isPerfLevelEnabled(0)) {
            CCSLogger.getInstance().setRequestId(messageContext.getStrProperty("requestID"));
            CCSLogger.getInstance().setSessionId(messageContext.getStrProperty("auth.passportid"));
        }
        Object object = CCSLogger.getInstance().startTimer(0, "execute", "RDSServiceHandler2:invokeImpl - handling of request", null);
        BIBusEnvelope bIBusEnvelope = (BIBusEnvelope)messageContext.getProperty("request.envelope");
        if (AuthService.isAuthCommand(messageContext)) {
            AuthService authService = new AuthService();
            authService.ProcessAuthCommand(bIBusEnvelope, messageContext);
            return;
        }
        CommandSession commandSession = new CommandSession();
        commandSession.parseRequestVersion(messageContext);
        boolean bl2 = bIBusEnvelope.getBody().elements().size() == 0;
        boolean bl3 = false;
        Boolean bl4 = (Boolean)messageContext.getProperty("balancedRequest");
        if (bl4 != null && bl4.booleanValue()) {
            bl3 = true;
        }
        if ((string = (String)messageContext.getProperty("path_info")) != null && string.startsWith("/rds/thumbnail")) {
            ThumbnailService thumbnailService = new ThumbnailService();
            thumbnailService.processRequest(bIBusEnvelope, messageContext, commandSession);
            return;
        }
        boolean bl5 = bl = string != null && string.startsWith("/rds/");
        if (bl2) {
            commandSession.processFormMessage(bIBusEnvelope, messageContext, bl3);
        } else if (bl) {
            commandSession.processGeneratedSOAPCommand(bIBusEnvelope, messageContext);
        } else {
            Element element = (Element)bIBusEnvelope.getBody().elements().get(0);
            if (element.getNamespace().getURI().equals("http://developer.cognos.com/schemas/rds/types/1")) {
                this.processLegacyRequest(messageContext, bIBusEnvelope);
            } else {
                commandSession.processSOAPCommand(bIBusEnvelope, messageContext);
            }
        }
        CCSLogger.getInstance().stopTimer(object);
    }

    private void processLegacyRequest(MessageContext messageContext, BIBusEnvelope bIBusEnvelope) {
        BaseRDSSession baseRDSSession = this.getSession(messageContext);
        BIBusEnvelope bIBusEnvelope2 = baseRDSSession.processSOAPMessage(bIBusEnvelope, messageContext, null);
        if (messageContext.getFault() == null) {
            messageContext.setResponseName("response");
            messageContext.setProperty("response.envelope", (Object)bIBusEnvelope2);
            messageContext.setProperty("response.status_code", (Object)"200");
        } else {
            messageContext.setProperty("response.envelope", null);
        }
    }

    public AsyncService getAsyncRequest(MessageContext messageContext) {
        boolean bl;
        InternetHeaders internetHeaders = (InternetHeaders)messageContext.getProperty("request.headers");
        String[] stringArray = internetHeaders.getHeader("soapAction");
        boolean bl2 = stringArray == null;
        String string = (String)messageContext.getProperty("path_info");
        boolean bl3 = bl = string != null && string.startsWith("/rds/");
        if (bl2 || bl) {
            return null;
        }
        BaseRDSSession baseRDSSession = this.getSession(messageContext);
        if (baseRDSSession.isAsyncRDSRequest(messageContext)) {
            return new RDSService(baseRDSSession);
        }
        return null;
    }

    public void configure(Configuration configuration) {
        super.configure(configuration);
        this.m_cnfMgr.populateConfig(configuration.getICCLConfiguration());
    }

    public void reconfigure(Configuration configuration) {
        super.reconfigure(configuration);
        this.m_cnfMgr.updateConfiguration(configuration.getICCLConfiguration());
    }

    private BaseRDSSession getSession(MessageContext messageContext) {
        InternetHeaders internetHeaders = (InternetHeaders)messageContext.getProperty("request.headers");
        String[] stringArray = internetHeaders.getHeader("soapAction");
        BaseRDSSession baseRDSSession = null;
        if (stringArray.length > 0) {
            baseRDSSession = new BaseRDSSession();
        }
        return baseRDSSession;
    }

    public class RDSService
    extends AsyncServiceBase {
        private BaseRDSSession m_Session;

        public RDSService(BaseRDSSession baseRDSSession) {
            this.m_Session = baseRDSSession;
            this.setAsyncThreshold(10);
        }

        protected void cancelImpl(MessageContext messageContext, AsyncContext asyncContext) {
            BIBusEnvelope bIBusEnvelope = (BIBusEnvelope)messageContext.getProperty("response.envelope");
            messageContext.setProperty("response.envelope", (Object)this.m_Session.processCancel(bIBusEnvelope, messageContext, asyncContext.getConversationID()));
        }

        public void abandonImpl(AsyncContext asyncContext) {
            BaseRDSSession.abortConversation(asyncContext.getConversationID());
        }

        public void workingImpl(MessageContext messageContext, AsyncContext asyncContext) {
            messageContext.setProperty("response.envelope", (Object)this.m_Session.processWait((BIBusEnvelope)messageContext.getProperty("request.envelope"), messageContext));
        }

        public void stillWorkingImpl(MessageContext messageContext, AsyncContext asyncContext) {
            messageContext.setProperty("response.envelope", (Object)this.m_Session.processWait((BIBusEnvelope)messageContext.getProperty("request.envelope"), messageContext));
        }

        public void getOutputImpl(MessageContext messageContext, AsyncContext asyncContext) {
        }

        public void releaseImpl(MessageContext messageContext) {
        }

        public void invoke(AsyncContext asyncContext) {
            MessageContext messageContext = asyncContext.getMessageContext();
            BIBusEnvelope bIBusEnvelope = (BIBusEnvelope)messageContext.getProperty("request.envelope");
            bIBusEnvelope.getBody();
            bIBusEnvelope.getBIBusHeader();
            messageContext.setResponseName("response");
            messageContext.setProperty("response.envelope", (Object)this.m_Session.processSOAPMessage(bIBusEnvelope, messageContext, asyncContext.getConversationID()));
            messageContext.setProperty("response.status_code", (Object)"200");
        }

        public void responseReadyImpl(MessageContext messageContext, AsyncContext asyncContext) {
            this.collectResponse(asyncContext.getMessageContext(), messageContext);
            Object object = asyncContext.getMessageContext().getProperty("pogo.responder");
            if (null != object) {
                messageContext.setProperty("pogo.responder", object);
            }
        }

        public void replyNow(MessageContext messageContext, AsyncContext asyncContext) {
            super.replyNow(messageContext, asyncContext);
            Object object = asyncContext.getMessageContext().getProperty("pogo.responder");
            if (null != object) {
                messageContext.setProperty("pogo.responder", object);
            }
        }
    }
}

