/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.ccs.service;

import com.cognos.ccs.content.PromptValue;
import com.cognos.ccs.exceptions.CCSGeneralException;
import com.cognos.ccs.filter.Filter;
import com.cognos.ccs.formats.CCSFormatter;
import com.cognos.ccs.service.SoapParms;
import com.cognos.ccs.utility.Utilities;
import com.cognos.pogo.pdk.BIBusEnvelope;
import com.cognos.pogo.util.NameValuePair;
import java.io.StringReader;
import java.util.List;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;
import org.xml.sax.InputSource;

public class RestOptions {
    protected String m_versionType;
    protected String m_versionName;
    protected String m_versionPath;
    protected String m_burstKey;
    protected String m_burstID;
    CCSFormatter m_formatter;
    protected PromptValue[] m_promptValues;
    protected boolean m_isPaged;
    protected int m_rowLimit;
    protected Filter[] m_Filters;
    protected boolean m_saveOutput;
    protected int m_width;
    protected int m_height;
    String m_fmt;

    public String getM_versionType() {
        return this.m_versionType;
    }

    public String getM_versionName() {
        return this.m_versionName;
    }

    public String getM_versionPath() {
        return this.m_versionPath;
    }

    public String getM_burstKey() {
        return this.m_burstKey;
    }

    public String getM_burstID() {
        return this.m_burstID;
    }

    public CCSFormatter getM_formatter() {
        return this.m_formatter;
    }

    public PromptValue[] getM_promptValues() {
        return this.m_promptValues;
    }

    public boolean isM_isPaged() {
        return this.m_isPaged;
    }

    public int getM_rowLimit() {
        return this.m_rowLimit;
    }

    public Filter[] getM_Filters() {
        return this.m_Filters;
    }

    public boolean isM_saveOutput() {
        return this.m_saveOutput;
    }

    public int getM_width() {
        return this.m_width;
    }

    public int getM_height() {
        return this.m_height;
    }

    public String getM_fmt() {
        return this.m_fmt;
    }

    public void extractRESTOptions(String string) throws CCSGeneralException {
        BIBusEnvelope bIBusEnvelope = this.createEnvelopeForQueryString(string);
        this.extractRESTOptions(bIBusEnvelope);
    }

    private BIBusEnvelope createEnvelopeForQueryString(String string) {
        BIBusEnvelope bIBusEnvelope = new BIBusEnvelope();
        String[] stringArray = string.split("&");
        for (int i = 0; i < stringArray.length; ++i) {
            String string2 = stringArray[i];
            String[] stringArray2 = string2.split("=");
            bIBusEnvelope.setFormField(stringArray2[0], stringArray2[1]);
        }
        return bIBusEnvelope;
    }

    public void extractRESTOptions(BIBusEnvelope bIBusEnvelope) throws CCSGeneralException {
        String string;
        String string2;
        this.m_versionType = bIBusEnvelope.getFormValue("version");
        this.m_versionName = bIBusEnvelope.getFormValue("versionID");
        this.m_versionPath = bIBusEnvelope.getFormValue("versionPath");
        this.m_saveOutput = false;
        if (bIBusEnvelope.getFormValue("saveOutput") != null) {
            this.m_saveOutput = Utilities.parseXMLBoolean(bIBusEnvelope.getFormValue("saveOutput"));
        }
        String string3 = bIBusEnvelope.getFormValue("width");
        String string4 = bIBusEnvelope.getFormValue("height");
        if (string3 != null) {
            this.m_width = Integer.parseInt(string3);
        }
        if (string4 != null) {
            this.m_height = Integer.parseInt(string4);
        }
        this.m_fmt = bIBusEnvelope.getFormValue("fmt");
        this.m_burstID = bIBusEnvelope.getFormValue("burstID");
        String string5 = bIBusEnvelope.getFormValue("xmlData");
        Element element = null != string5 ? this.extractXMLFormData(string5).getRootElement() : DocumentHelper.createElement((String)"promptAnswers");
        this.processSimplifiedRESTParameters(bIBusEnvelope, element);
        this.m_promptValues = SoapParms.getPromptParms(element, "promptValues", true);
        String string6 = bIBusEnvelope.getFormValue("selection");
        String string7 = bIBusEnvelope.getFormValue("xpath");
        if (string7 != null) {
            string6 = "<filters><filter>XPATH<filterType>XPATH</filterType><filterValue>" + string7 + "</filterValue></filter></filters>";
        }
        if (string6 != null) {
            this.m_Filters = this.extractFilters(string6);
        }
        if ((string2 = bIBusEnvelope.getFormValue("rowLimit")) != null) {
            this.m_rowLimit = Integer.parseInt(string2);
        }
        if ((string = bIBusEnvelope.getFormValue("paged")) != null && (string.equalsIgnoreCase("true") || string.equals("1"))) {
            this.m_isPaged = true;
        }
    }

    protected void processSimplifiedRESTParameters(BIBusEnvelope bIBusEnvelope, Element element) {
        List list = bIBusEnvelope.getFormFieldValues();
        for (NameValuePair nameValuePair : list) {
            String string = nameValuePair.getName();
            if (!string.startsWith("p_")) continue;
            string = string.substring(2);
            String string2 = nameValuePair.getValue();
            Element element2 = element.addElement("promptValues");
            Element element3 = element2.addElement("name");
            element3.setText(string);
            Element element4 = element2.addElement("values");
            Element element5 = element4.addElement("item");
            Element element6 = element5.addElement("SimplePValue");
            Element element7 = element6.addElement("inclusive");
            element7.setText("1");
            Element element8 = element6.addElement("useValue");
            element8.setText(string2);
        }
    }

    protected Document extractXMLFormData(String string) throws CCSGeneralException {
        try {
            if (null == string) {
                return null;
            }
            SAXReader sAXReader = new SAXReader();
            InputSource inputSource = new InputSource(new StringReader(string));
            Document document = sAXReader.read(inputSource);
            return document;
        }
        catch (DocumentException documentException) {
            throw new CCSGeneralException("REQUEST_ERROR", (Exception)((Object)documentException), 400);
        }
    }

    private Filter[] extractFilters(String string) throws CCSGeneralException {
        try {
            if (Utilities.isNullOrEmpty(string)) {
                return null;
            }
            if (string.startsWith("<filters")) {
                Document document = Utilities.parseText(string);
                return SoapParms.buildFilterArray(document.getRootElement().elements());
            }
            String[] stringArray = string.split(";");
            Filter[] filterArray = new Filter[stringArray.length];
            for (int i = 0; i < stringArray.length; ++i) {
                filterArray[i] = new Filter(CCSFormatter.decodeName(stringArray[i]), "OBJECT_ID");
            }
            return filterArray;
        }
        catch (DocumentException documentException) {
            throw new CCSGeneralException("REQUEST_ERROR", 400);
        }
    }
}

