/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.ccs.service;

import com.cognos.ccl4j.util.CCLWeb64;
import com.cognos.ccs.content.ContentProvider;
import com.cognos.ccs.content.PromptValue;
import com.cognos.ccs.content.SearchPromptValue;
import com.cognos.ccs.exceptions.CCSGeneralException;
import com.cognos.ccs.filter.ContextFilter;
import com.cognos.ccs.filter.Filter;
import com.cognos.ccs.filter.XPathFilter;
import com.cognos.ccs.utility.Utilities;
import com.ibm.cognos.ccs.internal.utility.Constants;
import java.util.Iterator;
import java.util.List;
import org.dom4j.Element;

public class SoapParms {
    public static final String XML_NAMESPACE = "nameSpace";
    public static final String XML_AUTH = "ticket";
    public static final String XML_PASSPORT = "passport";
    public static final String XML_LOCALE = "locale";
    public static final String XML_COOKIE = "cookie";
    public static final String GETCONTENT_PROVIDER = "providerId";
    public static final String GETCONTENT_REPORTID = "reportId";
    public static final String GETCONTENT_DATAFORMAT = "dataFormat";
    public static final String GETCONTENT_FORMAT_META = "metaDataOnly";
    public static final String GETCONTENT_FILTERFORMAT = "filterFormat";
    public static final String GETCONTENT_FILTERVALUE = "filterValue";
    public static final String GETCONTENT_FILTER_OBJECTID = "objectId";
    public static final String GETCONTENT_PROMPTS = "parameters";
    public static final String GETCONTENT_REPORTXML = "reportXml";
    public static final String GETCONTENT_ROWLIMIT = "rowLimit";
    public static final String FILTERTYPE_CONTEXT_SPEC = "CONTEXT_SPEC";
    public static final String FILTERTYPE_OBJECT_ID = "OBJECT_ID";
    public static final String FILTERTYPE_XPATH = "XPATH";
    public static final String GETPORTALTREE_ROOT = "root";
    public static final String GETPORTALTREE_DEPTH = "depth";
    public static final String GETPORTALTREE_FILTERLIST = "filterList";
    public static final String SETLOCALE_LOCALENAME = "localeName";
    public static final String LOGIN_USER = "username";
    public static final String LOGIN_PASSWORD = "password";
    public static final String LOGIN_NAMESPACE = "authNamespace";
    public static final String UPLOAD_FOLDER = "folderPortalId";
    public static final String UPLOAD_NAME = "reportName";
    public static final String UPLOAD_DESCRIPTION = "description";
    public static final String UPLOAD_TIP = "screenTip";
    public static final String UPLOAD_FILETYPE = "fileType";
    public static final String UPLOAD_FILETYPE_XL = "XLWB";
    public static final String UPLOAD_DATA = "fileData";
    public static final String GETFILE_NAME = "reportPortalId";
    public static final String PROMPT_CONVERSATION = "conversation";
    public static final String PROMPT_PREVPARMS = "prevPromptSelections";
    public static final String PROMPT_PROMPTSONLY = "promptsOnly";
    public static final String PROMPT_INCLUDEHTML = "includeHtml";
    public static final int NO_INT = Integer.MIN_VALUE;

    public static String base64encode(byte[] byArray) {
        return CCLWeb64.encode((byte[])byArray);
    }

    public static String getContainedStringParm(Element element, String string, String string2, String[] stringArray, boolean bl) throws CCSGeneralException {
        Object var5_5 = null;
        Element element2 = element.element(string);
        if (element2 != null) {
            return SoapParms.getStringParm(element2, string2, stringArray, bl);
        }
        if (bl) {
            return null;
        }
        throw new CCSGeneralException("REQUEST_ERROR", 400);
    }

    public static String getStringParm(Element element, String string, boolean bl) throws CCSGeneralException {
        return SoapParms.getStringParm(element, string, null, bl);
    }

    public static String getStringParm(Element element, String string, String[] stringArray, boolean bl) throws CCSGeneralException {
        String string2 = null;
        if (element.element(string) != null) {
            string2 = element.element(string).getText();
        }
        if (string2 != null) {
            if (stringArray != null) {
                if (SoapParms.testContains(stringArray, string2)) {
                    return string2;
                }
                throw new CCSGeneralException("REQUEST_ERROR", 400);
            }
            return string2;
        }
        if (bl) {
            return null;
        }
        throw new CCSGeneralException("REQUEST_ERROR", 400);
    }

    public static String[] getStringArrayParm(Element element, String string, String[] stringArray, boolean bl) throws CCSGeneralException {
        List list = element.elements(string);
        if (list.size() <= 0) {
            if (!bl) {
                throw new CCSGeneralException("REQUEST_ERROR", 400);
            }
            return null;
        }
        Iterator iterator = list.iterator();
        String[] stringArray2 = new String[list.size()];
        int n = 0;
        while (iterator.hasNext()) {
            Element element2 = (Element)iterator.next();
            stringArray2[n] = element2.getText();
            if (stringArray != null && !SoapParms.testContains(stringArray, stringArray2[n])) {
                throw new CCSGeneralException("REQUEST_ERROR", 400);
            }
            ++n;
        }
        return stringArray2;
    }

    public static byte[][] getB64ArrayParm(Element element, String string, boolean bl) throws CCSGeneralException {
        List list = element.elements(string);
        if (list.size() <= 0) {
            if (!bl) {
                throw new CCSGeneralException("REQUEST_ERROR", 400);
            }
            return null;
        }
        Iterator iterator = list.iterator();
        byte[][] byArrayArray = new byte[list.size()][];
        int n = 0;
        while (iterator.hasNext()) {
            Element element2 = (Element)iterator.next();
            try {
                byArrayArray[n] = CCLWeb64.decode((String)element2.getText());
            }
            catch (CCLWeb64.InvalidWeb64Exception invalidWeb64Exception) {
                throw new CCSGeneralException("REQUEST_ERROR", 400);
            }
            ++n;
        }
        return byArrayArray;
    }

    public static byte[] getB64Parm(Element element, String string, boolean bl) throws CCSGeneralException {
        if (element.element(string) != null) {
            byte[] byArray;
            try {
                byArray = CCLWeb64.decode((String)element.element(string).getText());
            }
            catch (CCLWeb64.InvalidWeb64Exception invalidWeb64Exception) {
                throw new CCSGeneralException("REQUEST_ERROR", 400);
            }
            if (null != byArray) {
                return byArray;
            }
        }
        if (!bl) {
            throw new CCSGeneralException("REQUEST_ERROR", 400);
        }
        return null;
    }

    public static int getIntParm(Element element, String string, int n, int n2, boolean bl) throws CCSGeneralException {
        if (element.element(string) != null) {
            try {
                return Integer.parseInt(element.element(string).getText());
            }
            catch (NumberFormatException numberFormatException) {
                throw new CCSGeneralException("REQUEST_ERROR", 400);
            }
        }
        if (!bl) {
            throw new CCSGeneralException("REQUEST_ERROR", 400);
        }
        return Integer.MIN_VALUE;
    }

    public static Filter[] getFilterParm(Element element, String string, boolean bl) throws CCSGeneralException {
        if (element.element(string) != null) {
            List list = element.elements(string);
            Filter[] filterArray = SoapParms.buildFilterArray(list);
            return filterArray;
        }
        return null;
    }

    public static Filter[] buildFilterArray(List list) throws CCSGeneralException {
        Filter[] filterArray = new Filter[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            Element element = (Element)list.get(i);
            Element element2 = element.element("filterType");
            Element element3 = element.element(GETCONTENT_FILTERVALUE);
            if (element2 == null || element3 == null) {
                throw new CCSGeneralException("REQUEST_ERROR", 400);
            }
            if (element2.getText().equals(FILTERTYPE_CONTEXT_SPEC)) {
                filterArray[i] = new ContextFilter(element3.getText(), element2.getText());
                ((ContextFilter)filterArray[i]).parseSelection();
                continue;
            }
            filterArray[i] = element2.getText().equals(FILTERTYPE_XPATH) ? new XPathFilter(element3.getText(), element2.getText()) : new Filter(element3.getText(), element2.getText());
        }
        return filterArray;
    }

    public static PromptValue[] getPromptParms(Element element, String string, boolean bl) throws CCSGeneralException {
        List list = element.elements(string);
        Iterator iterator = list.iterator();
        PromptValue[] promptValueArray = new PromptValue[list.size()];
        int n = 0;
        while (iterator.hasNext()) {
            promptValueArray[n] = PromptValue.parsePromptValue((Element)iterator.next(), Constants.NamespaceVersion.V1);
            ++n;
        }
        return promptValueArray;
    }

    public static SearchPromptValue getSearchValue(Element element, String string, boolean bl) throws CCSGeneralException {
        Element element2 = element.element("searchValue");
        if (element2 != null) {
            SearchPromptValue searchPromptValue = new SearchPromptValue();
            searchPromptValue.parseSearchXML(element2);
            return searchPromptValue;
        }
        if (!bl) {
            throw new CCSGeneralException("REQUEST_ERROR", 400);
        }
        return null;
    }

    public static boolean getBooleanParm(Element element, String string, boolean bl, boolean bl2) throws CCSGeneralException {
        String string2 = null;
        if (element.element(string) != null) {
            string2 = element.element(string).getText();
        }
        if (string2 != null) {
            return Utilities.parseXMLBoolean(string2);
        }
        if (bl2) {
            return bl;
        }
        throw new CCSGeneralException("REQUEST_ERROR", 400);
    }

    private static boolean testContains(String[] stringArray, String string) {
        for (int i = 0; i < stringArray.length; ++i) {
            if (!stringArray[i].equals(string)) continue;
            return true;
        }
        return false;
    }

    public static String extractSourceID(Element element) throws CCSGeneralException {
        String string = SoapParms.getContainedStringParm(element, "session", "conversationID", null, true);
        if (string != null) {
            if (!Utilities.isStoreIdValid(string)) {
                throw new CCSGeneralException("REQUEST_ERROR", 400);
            }
            return string;
        }
        String string2 = SoapParms.getStringParm(element, "sourceID", false);
        String string3 = SoapParms.getStringParm(element, "sourceType", false);
        if (string3.equals("storeID") || string3.equals("report")) {
            if (!Utilities.isStoreIdValid(string2)) {
                throw new CCSGeneralException("REQUEST_ERROR", 400);
            }
            return "storeID(\"" + string2 + "\")";
        }
        if (string3.equals("conversationID")) {
            if (!Utilities.isStoreIdValid(string2)) {
                throw new CCSGeneralException("REQUEST_ERROR", 400);
            }
            return string2;
        }
        if (string3.equals("searchPath")) {
            string2 = Utilities.unescapeXML(string2);
            return string2;
        }
        if (string3.equals("path")) {
            return ContentProvider.convertResourcePathtoSearchPath(string2, false);
        }
        if (string3.equals("metrics")) {
            return "metrics(\"" + string2 + "\")";
        }
        throw new CCSGeneralException("REQUEST_ERROR", 400);
    }
}

