/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.ccs.service;

import com.cognos.ccs.exceptions.CCSGeneralException;
import com.cognos.ccs.exceptions.CCSGovernorException;
import com.cognos.ccs.service.CCLMessage;
import com.cognos.ccs.service.CCSLogger;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.Locale;
import jd.xml.util.XmlSource;
import jd.xml.xslt.Stylesheet;
import jd.xml.xslt.XsltException;
import jd.xml.xslt.XsltResult;
import jd.xml.xslt.parser.XsltParseException;
import jd.xml.xslt.result.ResultBuilder;
import jd.xml.xslt.result.SaxResultBuilder;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.io.SAXContentHandler;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class Transform {
    private Stylesheet m_CachedSheet;

    public Transform(InputStream inputStream) {
        try {
            this.m_CachedSheet = new Stylesheet();
            this.m_CachedSheet.setup(new XmlSource(CCLMessage.getResMessage("INITTRANSERROR", Locale.getDefault()), inputStream, true));
        }
        catch (IOException iOException) {
            StringWriter stringWriter = new StringWriter();
            PrintWriter printWriter = new PrintWriter(stringWriter);
            iOException.printStackTrace(printWriter);
            CCSLogger.getInstance().logRuntimeErrorMessage(CCLMessage.getResMessage("INITTRANSERROR", Locale.getDefault()), "", null, null, stringWriter.toString());
        }
        catch (SAXException sAXException) {
            StringWriter stringWriter = new StringWriter();
            PrintWriter printWriter = new PrintWriter(stringWriter);
            sAXException.printStackTrace(printWriter);
            CCSLogger.getInstance().logRuntimeErrorMessage(CCLMessage.getResMessage("INITTRANSERROR", Locale.getDefault()), "", null, null, stringWriter.toString());
        }
        catch (XsltParseException xsltParseException) {
            StringWriter stringWriter = new StringWriter();
            PrintWriter printWriter = new PrintWriter(stringWriter);
            xsltParseException.printStackTrace(printWriter);
            CCSLogger.getInstance().logRuntimeErrorMessage(CCLMessage.getResMessage("INITTRANSERROR", Locale.getDefault()), "", null, null, stringWriter.toString());
        }
    }

    public Transform(InputStream inputStream, String[] stringArray, String[] stringArray2) {
        PrintWriter printWriter;
        StringWriter stringWriter;
        try {
            this.m_CachedSheet = new Stylesheet();
            this.m_CachedSheet.setup(new XmlSource(CCLMessage.getResMessage("INITTRANSERROR", Locale.getDefault()), inputStream, true));
        }
        catch (IOException iOException) {
            stringWriter = new StringWriter();
            printWriter = new PrintWriter(stringWriter);
            iOException.printStackTrace(printWriter);
            CCSLogger.getInstance().logRuntimeErrorMessage(CCLMessage.getResMessage("INITTRANSERROR", Locale.getDefault()), "", null, null, stringWriter.toString());
        }
        catch (SAXException sAXException) {
            stringWriter = new StringWriter();
            printWriter = new PrintWriter(stringWriter);
            sAXException.printStackTrace(printWriter);
            CCSLogger.getInstance().logRuntimeErrorMessage(CCLMessage.getResMessage("INITTRANSERROR", Locale.getDefault()), "", null, null, stringWriter.toString());
        }
        catch (XsltParseException xsltParseException) {
            stringWriter = new StringWriter();
            printWriter = new PrintWriter(stringWriter);
            xsltParseException.printStackTrace(printWriter);
            CCSLogger.getInstance().logRuntimeErrorMessage(CCLMessage.getResMessage("INITTRANSERROR", Locale.getDefault()), "", null, null, stringWriter.toString());
        }
        if (null != stringArray) {
            for (int i = 0; i < stringArray.length; ++i) {
                this.m_CachedSheet.setParameter(stringArray[i], (Object)stringArray2[i]);
            }
        }
    }

    public void convertToCCS(InputStream inputStream, Element element) throws CCSGeneralException, CCSGovernorException {
        this.convertToCCS(inputStream, element, null, null);
    }

    public void convertToCCS(InputStream inputStream, Element element, String[] stringArray, String[] stringArray2) throws CCSGeneralException, CCSGovernorException {
        XmlSource xmlSource = new XmlSource("", inputStream, true);
        SAXContentHandler sAXContentHandler = new SAXContentHandler();
        SaxResultBuilder saxResultBuilder = new SaxResultBuilder(null, (ContentHandler)sAXContentHandler);
        XsltResult xsltResult = new XsltResult((ResultBuilder)saxResultBuilder);
        if (null != stringArray) {
            for (int i = 0; i < stringArray.length; ++i) {
                this.m_CachedSheet.setParameter(stringArray[i], (Object)stringArray2[i]);
            }
        }
        try {
            this.m_CachedSheet.transform(xmlSource, xsltResult);
        }
        catch (XsltException xsltException) {
            throw new CCSGeneralException("TRANS_ERROR", (Exception)((Object)xsltException), 500);
        }
        catch (IOException iOException) {
            if (iOException instanceof CCSGovernorException) {
                throw (CCSGovernorException)iOException;
            }
            throw new CCSGeneralException("TRANS_ERROR", iOException, 500);
        }
        catch (SAXException sAXException) {
            throw new CCSGeneralException("TRANS_ERROR", sAXException, 500);
        }
        element.add(sAXContentHandler.getDocument().getRootElement());
        try {
            inputStream.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void convertToCCS(String string, Element element) throws CCSGeneralException {
        this.convertToCCS(string, element, null, null);
    }

    public Document convert(InputStream inputStream) throws CCSGeneralException {
        XmlSource xmlSource = new XmlSource("", inputStream, true);
        SAXContentHandler sAXContentHandler = new SAXContentHandler();
        SaxResultBuilder saxResultBuilder = new SaxResultBuilder(null, (ContentHandler)sAXContentHandler);
        XsltResult xsltResult = new XsltResult((ResultBuilder)saxResultBuilder);
        try {
            this.m_CachedSheet.transform(xmlSource, xsltResult);
            inputStream.close();
            return sAXContentHandler.getDocument();
        }
        catch (XsltException xsltException) {
            throw new CCSGeneralException("TRANS_ERROR", (Exception)((Object)xsltException), 500);
        }
        catch (IOException iOException) {
            throw new CCSGeneralException("TRANS_ERROR", iOException, 500);
        }
        catch (SAXException sAXException) {
            throw new CCSGeneralException("TRANS_ERROR", sAXException, 500);
        }
    }

    public Element convert(String string) throws CCSGeneralException {
        XmlSource xmlSource = new XmlSource("", (Reader)new StringReader(string), true, null);
        SAXContentHandler sAXContentHandler = new SAXContentHandler();
        SaxResultBuilder saxResultBuilder = new SaxResultBuilder(null, (ContentHandler)sAXContentHandler);
        XsltResult xsltResult = new XsltResult((ResultBuilder)saxResultBuilder);
        try {
            this.m_CachedSheet.transform(xmlSource, xsltResult);
        }
        catch (XsltException xsltException) {
            throw new CCSGeneralException("TRANS_ERROR", (Exception)((Object)xsltException), 500);
        }
        catch (IOException iOException) {
            throw new CCSGeneralException("TRANS_ERROR", iOException, 500);
        }
        catch (SAXException sAXException) {
            throw new CCSGeneralException("TRANS_ERROR", sAXException, 500);
        }
        return sAXContentHandler.getDocument().getRootElement();
    }

    public void convertToCCS(String string, Element element, String[] stringArray, String[] stringArray2) throws CCSGeneralException {
        XmlSource xmlSource = new XmlSource("", (Reader)new StringReader(string), true, null);
        SAXContentHandler sAXContentHandler = new SAXContentHandler();
        SaxResultBuilder saxResultBuilder = new SaxResultBuilder(null, (ContentHandler)sAXContentHandler);
        XsltResult xsltResult = new XsltResult((ResultBuilder)saxResultBuilder);
        if (null != stringArray) {
            for (int i = 0; i < stringArray.length; ++i) {
                this.m_CachedSheet.setParameter(stringArray[i], (Object)stringArray2[i]);
            }
        }
        try {
            this.m_CachedSheet.transform(xmlSource, xsltResult);
        }
        catch (XsltException xsltException) {
            throw new CCSGeneralException("TRANS_ERROR", (Exception)((Object)xsltException), 500);
        }
        catch (IOException iOException) {
            throw new CCSGeneralException("TRANS_ERROR", iOException, 500);
        }
        catch (SAXException sAXException) {
            throw new CCSGeneralException("TRANS_ERROR", sAXException, 500);
        }
        element.add(sAXContentHandler.getDocument().getRootElement());
    }
}

