/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.ccs.service.command;

import com.cognos.ccs.cache.ConversationCache;
import com.cognos.ccs.content.ContentProvider;
import com.cognos.ccs.exceptions.CCSAuthenticationException;
import com.cognos.ccs.exceptions.CCSException;
import com.cognos.ccs.exceptions.CCSGeneralException;
import com.cognos.ccs.exceptions.CCSPromptException;
import com.cognos.ccs.filter.Filter;
import com.cognos.ccs.filter.appenders.AnnotationAppender;
import com.cognos.ccs.filter.appenders.AppenderList;
import com.cognos.ccs.filter.appenders.DrillAppender;
import com.cognos.ccs.filter.appenders.DrillThroughAppender;
import com.cognos.ccs.formats.CCSFormatter;
import com.cognos.ccs.service.CCSDataResult;
import com.cognos.ccs.service.Cognos8Connector;
import com.cognos.ccs.service.CommandSession;
import com.cognos.ccs.service.Conversation;
import com.cognos.ccs.service.SoapParms;
import com.cognos.ccs.service.command.ACommand;
import com.cognos.ccs.utility.Utilities;
import com.cognos.pogo.pdk.BIBusEnvelope;
import com.cognos.pogo.pdk.MessageContext;
import com.ibm.cognos.ccs.internal.utility.Constants;
import javax.mail.internet.InternetHeaders;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.QName;

public abstract class AAsyncCommand
extends ACommand {
    protected String m_sourceID;
    protected static final int AUTO = 0;
    protected static final int OFF = 1;
    protected static final int MANUAL = 2;
    protected static final String AUTO_KEY = "auto";
    protected static final String OFF_KEY = "off";
    protected static final String MANUAL_KEY = "manual";
    protected static final String COMPLETE = "complete";
    protected static final String STATUS_KEY = "status";

    public AAsyncCommand() {
        this.m_asyncType = 0;
    }

    @Override
    public void performRestAction(BIBusEnvelope bIBusEnvelope, MessageContext messageContext, String string) {
        try {
            this.extractRESTOptions(bIBusEnvelope);
            this.m_sourceID = string;
            this.m_provider = this.m_session.getProviderFromID(string);
            this.checkSyncMode(bIBusEnvelope);
            if (1 == this.m_asyncType) {
                this.doRestSync(messageContext);
            } else {
                Conversation conversation = this.doRESTAsync(bIBusEnvelope, messageContext);
                conversation.setProperty("command", this.getClass().getName());
                this.createReciept(messageContext, conversation);
            }
        }
        catch (CCSException cCSException) {
            this.m_session.handleRESTCCSException(cCSException, messageContext);
        }
    }

    public void retrieveRESTSessionOutput(Conversation conversation, CommandSession commandSession, MessageContext messageContext) {
        try {
            this.m_session = commandSession;
            this.m_provider = this.m_session.getProviderFromConversation(conversation);
            this.doAsyncRESTOutput(conversation, messageContext);
        }
        catch (CCSException cCSException) {
            this.m_session.handleRESTCCSException(cCSException, messageContext);
        }
    }

    protected abstract void doAsyncRESTOutput(Conversation var1, MessageContext var2) throws CCSAuthenticationException, CCSGeneralException, CCSPromptException;

    protected abstract Conversation doRESTAsync(BIBusEnvelope var1, MessageContext var2) throws CCSGeneralException, CCSAuthenticationException, CCSPromptException;

    protected abstract void doRestSync(MessageContext var1) throws CCSGeneralException, CCSAuthenticationException, CCSPromptException;

    protected abstract void extractRESTOptions(BIBusEnvelope var1) throws CCSGeneralException;

    protected String generateOutputURL(String string) {
        String string2 = this.m_session.getRelativeRoot() + "rds/sessionOutput/conversationID/" + string;
        if (this.getSession().getRequestVersion() == Constants.RequestVersion.V3) {
            string2 = string2 + "?v=3";
        }
        return string2;
    }

    protected Element generateRecieptBody(Conversation conversation, String string, MessageContext messageContext) {
        String string2 = this.generateRecieptURL(string, conversation, this.m_sourceID);
        Element element = DocumentHelper.createElement((QName)new QName("receipt", this.m_session.getResponseNamespace()));
        Element element2 = element.addElement(new QName(STATUS_KEY, this.m_session.getResponseNamespace()));
        Element element3 = element.addElement(new QName("url", this.m_session.getResponseNamespace()));
        element3.setText(string2);
        Element element4 = element.addElement(new QName("conversationID", this.m_session.getResponseNamespace()));
        element4.setText(string);
        element2.setText((String)conversation.getProperty(STATUS_KEY));
        Integer n = (Integer)conversation.getProperty("syncMode");
        if (n == 2) {
            messageContext.setProperty("response.status_code", (Object)"202");
        } else {
            messageContext.setProperty("response.status_code", (Object)"303");
        }
        InternetHeaders internetHeaders = (InternetHeaders)messageContext.getProperty("response.headers");
        internetHeaders.addHeader("Location", string2);
        messageContext.setProperty("response.headers", (Object)internetHeaders);
        return element;
    }

    protected String generateRecieptURL(String string, Conversation conversation, String string2) {
        return this.generateOutputURL(string);
    }

    protected String generateStatusURL(String string, String string2, String string3) {
        String string4 = this.m_session.getRelativeRoot() + "rds/" + string3 + "/searchPath/" + Utilities.IRIEncode(string, true) + "?viewStatus=" + string2;
        return string4;
    }

    protected void checkSyncMode(BIBusEnvelope bIBusEnvelope) {
        String string = bIBusEnvelope.getFormValue("async");
        String string2 = bIBusEnvelope.getFormValue("forceSync");
        if (string2 != null) {
            if (string2.equalsIgnoreCase("true")) {
                this.m_asyncType = 1;
            }
        } else if (AUTO_KEY.equalsIgnoreCase(string) || null == string) {
            this.m_asyncType = 0;
        } else if (MANUAL_KEY.equalsIgnoreCase(string)) {
            this.m_asyncType = 2;
        } else if (OFF_KEY.equalsIgnoreCase(string)) {
            this.m_asyncType = 1;
        }
    }

    protected boolean isStatusCheck(BIBusEnvelope bIBusEnvelope) {
        String string = bIBusEnvelope.getFormValue("viewStatus");
        return string != null;
    }

    protected abstract CCSDataResult createResponse(Element var1, Conversation var2, String var3) throws CCSGeneralException, CCSPromptException, CCSAuthenticationException;

    public Conversation checkStatus(BIBusEnvelope bIBusEnvelope, MessageContext messageContext) throws CCSGeneralException, CCSAuthenticationException, CCSPromptException {
        String string = bIBusEnvelope.getFormValue("viewStatus");
        Cognos8Connector cognos8Connector = this.m_session.getConnect();
        ConversationCache conversationCache = cognos8Connector.conversationCache();
        Conversation conversation = conversationCache.getConversation(string);
        String string2 = (String)conversation.getProperty("searchPath");
        ContentProvider contentProvider = ContentProvider.getProvider(string2, cognos8Connector, this.m_session.getCookies(), this.m_session);
        return contentProvider.checkDataStatus(conversation);
    }

    protected void createReciept(MessageContext messageContext, Conversation conversation) throws CCSGeneralException, CCSAuthenticationException {
        conversation.setProperty("syncMode", new Integer(this.m_asyncType));
        String string = this.m_session.saveConversation(conversation);
        Element element = this.generateRecieptBody(conversation, string, messageContext);
        this.m_session.getResponder().setBuffer(element.asXML(), this.m_session.getTransport());
    }

    public void createReciept(MessageContext messageContext, Conversation conversation, String string) throws CCSGeneralException {
        Element element = this.generateRecieptBody(conversation, string, messageContext);
        this.m_session.getResponder().setBuffer(element.asXML(), this.m_session.getTransport());
    }

    protected CCSDataResult processSession(Element element, Element element2) throws CCSGeneralException, CCSPromptException, CCSAuthenticationException {
        String string = SoapParms.getStringParm(element2, "conversationID", false);
        Conversation conversation = this.m_session.recoverConversation(string);
        if (conversation == null) {
            throw new CCSGeneralException("INVALID_CONVERSATION", new String[]{string}, 404);
        }
        conversation = this.m_provider.checkDataStatus(conversation);
        CCSDataResult cCSDataResult = this.createResponse(element, conversation, string);
        return cCSDataResult;
    }

    public Element generateSession(Conversation conversation, String string) throws CCSGeneralException, CCSAuthenticationException {
        Element element = DocumentHelper.createElement((QName)new QName("session", this.m_session.getResponseNamespace()));
        Cognos8Connector cognos8Connector = this.m_session.getConnect();
        ConversationCache conversationCache = cognos8Connector.conversationCache();
        if (string == null) {
            string = conversationCache.addConversation(conversation);
        } else {
            conversationCache.updateConversation(string, conversation);
        }
        Element element2 = element.addElement(new QName("conversationID", this.m_session.getResponseNamespace()));
        element2.setText(string);
        Element element3 = element.addElement(new QName(STATUS_KEY, this.m_session.getResponseNamespace()));
        element3.setText((String)conversation.getProperty(STATUS_KEY));
        return element;
    }

    protected AppenderList getAppenderList(Conversation conversation) throws CCSGeneralException, CCSAuthenticationException {
        AppenderList appenderList = new AppenderList();
        AnnotationAppender annotationAppender = null;
        if (conversation.getProperty("annotations") != null && conversation.getProperty("annotations").equals(Boolean.TRUE)) {
            annotationAppender = new AnnotationAppender(this.m_provider.getStoreID(), conversation, this.getSession().getConnect());
        }
        DrillAppender drillAppender = null;
        if (conversation.getProperty("drillurls") != null && conversation.getProperty("drillurls").equals(Boolean.TRUE)) {
            drillAppender = new DrillAppender();
        }
        DrillThroughAppender drillThroughAppender = null;
        if (conversation.getProperty("drillthroughurls") != null && conversation.getProperty("drillthroughurls").equals(Boolean.TRUE)) {
            drillThroughAppender = new DrillThroughAppender();
        }
        appenderList.setAnnotationAppender(annotationAppender);
        appenderList.setDrillAppender(drillAppender);
        appenderList.setDrillThroughAppender(drillThroughAppender);
        return appenderList;
    }

    protected Filter[] extractFilters(String string) throws CCSGeneralException {
        try {
            if (Utilities.isNullOrEmpty(string)) {
                return null;
            }
            if (string.startsWith("<filters")) {
                Document document = Utilities.parseText(string);
                return SoapParms.buildFilterArray(document.getRootElement().elements());
            }
            String[] stringArray = string.split(";");
            Filter[] filterArray = new Filter[stringArray.length];
            for (int i = 0; i < stringArray.length; ++i) {
                filterArray[i] = new Filter(CCSFormatter.decodeName(stringArray[i]), "OBJECT_ID");
            }
            return filterArray;
        }
        catch (DocumentException documentException) {
            throw new CCSGeneralException("REQUEST_ERROR", 400);
        }
    }
}

