/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.ccs.service.command;

import com.cognos.ccs.exceptions.CCSAuthenticationException;
import com.cognos.ccs.exceptions.CCSException;
import com.cognos.ccs.exceptions.CCSGeneralException;
import com.cognos.ccs.exceptions.CCSPromptException;
import com.cognos.ccs.service.command.ACommand;
import com.cognos.ccs.utility.Utilities;
import com.cognos.pogo.pdk.BIBusEnvelope;
import com.cognos.pogo.pdk.MessageContext;
import java.io.InputStream;
import javax.mail.internet.InternetHeaders;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;

public abstract class AAtomPubCommand
extends ACommand {
    @Override
    protected void initialize() {
    }

    @Override
    public void performRestAction(BIBusEnvelope bIBusEnvelope, MessageContext messageContext, String string) {
        try {
            String string2;
            SAXReader sAXReader;
            InputStream inputStream;
            Document document = null;
            String string3 = (String)messageContext.getProperty("request.method");
            String string4 = bIBusEnvelope.getFormValue("_method");
            if (string4 != null && !string4.equals("")) {
                string3 = string4;
            }
            if ((inputStream = (InputStream)messageContext.getProperty("request.body")) != null) {
                sAXReader = Utilities.getSAXReader();
                document = sAXReader.read(inputStream);
            }
            if (string3.equalsIgnoreCase("GET")) {
                string2 = this.readResource(bIBusEnvelope, messageContext, string);
                messageContext.setProperty("response.status_code", (Object)"200");
                sAXReader = new InternetHeaders();
                sAXReader.setHeader("Content-Type", "Content-Type: application/atom+xml;charset=\"utf-8\"");
                messageContext.setProperty("response.headers", (Object)sAXReader);
                messageContext.setProperty("response.status_msg", (Object)"Ok");
            } else if (string3.equalsIgnoreCase("DELETE")) {
                string2 = this.deleteResource(bIBusEnvelope, messageContext, string);
            } else if (string3.equalsIgnoreCase("PUT")) {
                string2 = this.updateResource(bIBusEnvelope, messageContext, string, document);
            } else if (string3.equalsIgnoreCase("POST")) {
                string2 = this.createResource(bIBusEnvelope, messageContext, string, document);
                messageContext.setProperty("response.status_code", (Object)"201");
                sAXReader = new InternetHeaders();
                sAXReader.setHeader("Content-Type", "Content-Type: application/atom+xml;type=entry;charset=\"utf-8\"");
                messageContext.setProperty("response.headers", (Object)sAXReader);
                messageContext.setProperty("response.status_msg", (Object)"Created");
            } else {
                throw new CCSGeneralException("REQUEST_ERROR", 400);
            }
            this.m_session.setResponseAsString(string2);
        }
        catch (DocumentException documentException) {
            this.m_session.generateRESTErrorBlock(new CCSGeneralException("REQUEST_ERROR", 400), messageContext);
        }
        catch (CCSException cCSException) {
            this.m_session.handleRESTCCSException(cCSException, messageContext);
        }
    }

    @Override
    public void performSoapAction(Element element, MessageContext messageContext) {
        this.m_session.generateSOAPFault(messageContext, new CCSGeneralException("OP_NOT_SUPPORTED_ERROR", 400));
    }

    public static Document startFeed(String string, String string2) throws CCSGeneralException {
        try {
            Document document = Utilities.parseText("<?xml version=\"1.0\" encoding=\"utf-8\"?><feed xmlns=\"http://www.w3.org/2005/Atom\"/>");
            Element element = document.getRootElement();
            if (string != null && !string.equals("")) {
                element.addElement("id").setText("urn:uuid:" + string);
            }
            if (string2 != null && !string2.equals("")) {
                element.addElement("title").setText(string2);
            }
            return document;
        }
        catch (DocumentException documentException) {
            throw new CCSGeneralException("REQUEST_ERROR", 400);
        }
    }

    public static Element addEntry(Document document, String string, String string2, String string3, String string4, String string5, String string6, String string7, String string8) {
        if (document == null) {
            return null;
        }
        Element element = document.getRootElement().addElement("entry");
        if (string7 != null && !string7.equals("")) {
            element.addAttribute("xml:lang", string7);
        }
        if (string != null && !string.equals("")) {
            element.addElement("title").setText(string);
        }
        if (string2 != null && !string2.equals("")) {
            element.addElement("id").setText("urn:uuid:" + string2);
        }
        if (string3 != null && !string3.equals("")) {
            element.addElement("updated").setText(string3);
        }
        if (string4 != null && !string4.equals("")) {
            element.addElement("summary").setText(string4);
        }
        if (string5 != null || string6 != null) {
            Element element2;
            Element element3 = element.addElement("author");
            Element element4 = element3.addElement("name");
            element4.setText(string5);
            if (string6 != null) {
                element2 = element3.addElement("camId");
                element2.setText(string6);
            }
            if (string8 != null) {
                element2 = element3.addElement("email");
                element2.setText(string8);
            }
        }
        return element;
    }

    protected abstract String createResource(BIBusEnvelope var1, MessageContext var2, String var3, Document var4) throws CCSGeneralException, CCSAuthenticationException, CCSPromptException;

    protected abstract String readResource(BIBusEnvelope var1, MessageContext var2, String var3) throws CCSGeneralException, CCSAuthenticationException, CCSPromptException;

    protected abstract String updateResource(BIBusEnvelope var1, MessageContext var2, String var3, Document var4) throws CCSGeneralException, CCSAuthenticationException, CCSPromptException;

    protected abstract String deleteResource(BIBusEnvelope var1, MessageContext var2, String var3) throws CCSGeneralException, CCSAuthenticationException, CCSPromptException;
}

