/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.ccs.service.command;

import com.cognos.ccs.exceptions.CCSAuthenticationException;
import com.cognos.ccs.exceptions.CCSException;
import com.cognos.ccs.exceptions.CCSGeneralException;
import com.cognos.ccs.exceptions.CCSPromptException;
import com.cognos.ccs.service.Conversation;
import com.cognos.ccs.service.ManagedAttachment;
import com.cognos.ccs.service.command.AAsyncCommand;
import com.cognos.pogo.pdk.BIBusEnvelope;
import com.cognos.pogo.pdk.MessageContext;

public abstract class ASecondaryCommand
extends AAsyncCommand {
    Conversation m_conversation = null;

    @Override
    public void performRestAction(BIBusEnvelope bIBusEnvelope, MessageContext messageContext, String string) {
        try {
            this.extractRESTOptions(bIBusEnvelope);
            this.m_sourceID = string;
            this.m_conversation = this.m_session.recoverConversation(string);
            if (this.m_conversation == null) {
                throw new CCSGeneralException("INVALID_CONVERSATION", new String[]{string}, 404);
            }
            this.m_provider = this.m_session.getProviderFromConversation(this.m_conversation);
            this.checkSyncMode(bIBusEnvelope);
            if (1 == this.m_asyncType) {
                this.doRestSync(messageContext);
            } else {
                Conversation conversation = this.doRESTAsync(bIBusEnvelope, messageContext);
                conversation.setProperty("command", this.getClass().getName());
                ManagedAttachment managedAttachment = conversation.getAttachment();
                if (managedAttachment != null) {
                    managedAttachment.delete();
                }
                this.m_session.updateConversation(conversation, this.m_sourceID);
                this.createReciept(messageContext, conversation, string);
            }
        }
        catch (CCSException cCSException) {
            this.m_session.handleRESTCCSException(cCSException, messageContext);
        }
    }

    @Override
    protected abstract void doAsyncRESTOutput(Conversation var1, MessageContext var2) throws CCSAuthenticationException, CCSGeneralException, CCSPromptException;

    @Override
    protected abstract Conversation doRESTAsync(BIBusEnvelope var1, MessageContext var2) throws CCSGeneralException, CCSAuthenticationException, CCSPromptException;

    @Override
    protected abstract void doRestSync(MessageContext var1) throws CCSGeneralException, CCSAuthenticationException, CCSPromptException;

    @Override
    protected abstract void extractRESTOptions(BIBusEnvelope var1) throws CCSGeneralException;
}

